/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.directoryservicedata.internal.DirectoryServiceDataServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.directoryservicedata.model.AccessDeniedException;
import software.amazon.awssdk.services.directoryservicedata.model.AddGroupMemberRequest;
import software.amazon.awssdk.services.directoryservicedata.model.AddGroupMemberResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ConflictException;
import software.amazon.awssdk.services.directoryservicedata.model.CreateGroupRequest;
import software.amazon.awssdk.services.directoryservicedata.model.CreateGroupResponse;
import software.amazon.awssdk.services.directoryservicedata.model.CreateUserRequest;
import software.amazon.awssdk.services.directoryservicedata.model.CreateUserResponse;
import software.amazon.awssdk.services.directoryservicedata.model.DeleteGroupRequest;
import software.amazon.awssdk.services.directoryservicedata.model.DeleteGroupResponse;
import software.amazon.awssdk.services.directoryservicedata.model.DeleteUserRequest;
import software.amazon.awssdk.services.directoryservicedata.model.DeleteUserResponse;
import software.amazon.awssdk.services.directoryservicedata.model.DescribeGroupRequest;
import software.amazon.awssdk.services.directoryservicedata.model.DescribeGroupResponse;
import software.amazon.awssdk.services.directoryservicedata.model.DescribeUserRequest;
import software.amazon.awssdk.services.directoryservicedata.model.DescribeUserResponse;
import software.amazon.awssdk.services.directoryservicedata.model.DirectoryServiceDataException;
import software.amazon.awssdk.services.directoryservicedata.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.directoryservicedata.model.DisableUserRequest;
import software.amazon.awssdk.services.directoryservicedata.model.DisableUserResponse;
import software.amazon.awssdk.services.directoryservicedata.model.InternalServerException;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ListUsersRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListUsersResponse;
import software.amazon.awssdk.services.directoryservicedata.model.RemoveGroupMemberRequest;
import software.amazon.awssdk.services.directoryservicedata.model.RemoveGroupMemberResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsRequest;
import software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsResponse;
import software.amazon.awssdk.services.directoryservicedata.model.SearchUsersRequest;
import software.amazon.awssdk.services.directoryservicedata.model.SearchUsersResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ThrottlingException;
import software.amazon.awssdk.services.directoryservicedata.model.UpdateGroupRequest;
import software.amazon.awssdk.services.directoryservicedata.model.UpdateGroupResponse;
import software.amazon.awssdk.services.directoryservicedata.model.UpdateUserRequest;
import software.amazon.awssdk.services.directoryservicedata.model.UpdateUserResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ValidationException;
import software.amazon.awssdk.services.directoryservicedata.transform.AddGroupMemberRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.DisableUserRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.ListGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.ListGroupsForMemberRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.RemoveGroupMemberRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.SearchGroupsRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.SearchUsersRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.directoryservicedata.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link DirectoryServiceDataClient}.
 *
 * @see DirectoryServiceDataClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDirectoryServiceDataClient implements DirectoryServiceDataClient {
    private static final Logger log = Logger.loggerFor(DefaultDirectoryServiceDataClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDirectoryServiceDataClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds an existing user, group, or computer as a group member.
     * </p>
     *
     * @param addGroupMemberRequest
     * @return Result of the AddGroupMember operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ConflictException
     *         This error will occur when you try to create a resource that conflicts with an existing object. It can
     *         also occur when adding a member to a group that the member is already in.
     *         </p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.AddGroupMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/AddGroupMember"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddGroupMemberResponse addGroupMember(AddGroupMemberRequest addGroupMemberRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, DirectoryUnavailableException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddGroupMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddGroupMemberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addGroupMemberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addGroupMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddGroupMember");

            return clientHandler.execute(new ClientExecutionParams<AddGroupMemberRequest, AddGroupMemberResponse>()
                    .withOperationName("AddGroupMember").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addGroupMemberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddGroupMemberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new group.
     * </p>
     *
     * @param createGroupRequest
     * @return Result of the CreateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ConflictException
     *         This error will occur when you try to create a resource that conflicts with an existing object. It can
     *         also occur when adding a member to a group that the member is already in.
     *         </p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/CreateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, DirectoryUnavailableException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                    .withOperationName("CreateGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new user.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ConflictException
     *         This error will occur when you try to create a resource that conflicts with an existing object. It can
     *         also occur when adding a member to a group that the member is already in.
     *         </p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/CreateUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, DirectoryUnavailableException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");

            return clientHandler.execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>()
                    .withOperationName("CreateUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a group.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ConflictException
     *         This error will occur when you try to create a resource that conflicts with an existing object. It can
     *         also occur when adding a member to a group that the member is already in.
     *         </p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DeleteGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, DirectoryUnavailableException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                    .withOperationName("DeleteGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a user.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ConflictException
     *         This error will occur when you try to create a resource that conflicts with an existing object. It can
     *         also occur when adding a member to a group that the member is already in.
     *         </p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DeleteUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, DirectoryUnavailableException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>()
                    .withOperationName("DeleteUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specific group.
     * </p>
     *
     * @param describeGroupRequest
     * @return Result of the DescribeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DescribeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeGroupResponse describeGroup(DescribeGroupRequest describeGroupRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, DirectoryUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGroup");

            return clientHandler.execute(new ClientExecutionParams<DescribeGroupRequest, DescribeGroupResponse>()
                    .withOperationName("DescribeGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specific user.
     * </p>
     *
     * @param describeUserRequest
     * @return Result of the DescribeUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DescribeUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, DirectoryUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUser");

            return clientHandler.execute(new ClientExecutionParams<DescribeUserRequest, DescribeUserResponse>()
                    .withOperationName("DescribeUser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates an active user account. For information about how to enable an inactive user account, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ResetUserPassword.html"
     * >ResetUserPassword</a> in the <i>Directory Service API Reference</i>.
     * </p>
     *
     * @param disableUserRequest
     * @return Result of the DisableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ConflictException
     *         This error will occur when you try to create a resource that conflicts with an existing object. It can
     *         also occur when adding a member to a group that the member is already in.
     *         </p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.DisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DisableUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisableUserResponse disableUser(DisableUserRequest disableUserRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, DirectoryUnavailableException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DisableUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableUser");

            return clientHandler.execute(new ClientExecutionParams<DisableUserRequest, DisableUserResponse>()
                    .withOperationName("DisableUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(disableUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisableUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns member information for the specified group.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListGroupMembers.NextToken</code> member contains a token that you pass in
     * the next call to <code>ListGroupMembers</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param listGroupMembersRequest
     * @return Result of the ListGroupMembers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroupMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGroupMembersResponse listGroupMembers(ListGroupMembersRequest listGroupMembersRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            DirectoryUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGroupMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupMembers");

            return clientHandler.execute(new ClientExecutionParams<ListGroupMembersRequest, ListGroupMembersResponse>()
                    .withOperationName("ListGroupMembers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listGroupMembersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGroupMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns group information for the specified directory.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListGroups.NextToken</code> member contains a token that you pass in the
     * next call to <code>ListGroups</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, DirectoryUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");

            return clientHandler.execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>()
                    .withOperationName("ListGroups").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listGroupsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns group information for the specified member.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListGroupsForMember.NextToken</code> member contains a token that you pass
     * in the next call to <code>ListGroupsForMember</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param listGroupsForMemberRequest
     * @return Result of the ListGroupsForMember operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.ListGroupsForMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroupsForMember"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGroupsForMemberResponse listGroupsForMember(ListGroupsForMemberRequest listGroupsForMemberRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            DirectoryUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupsForMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListGroupsForMemberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsForMemberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsForMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupsForMember");

            return clientHandler.execute(new ClientExecutionParams<ListGroupsForMemberRequest, ListGroupsForMemberResponse>()
                    .withOperationName("ListGroupsForMember").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listGroupsForMemberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGroupsForMemberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns user information for the specified directory.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListUsers.NextToken</code> member contains a token that you pass in the
     * next call to <code>ListUsers</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListUsers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws AccessDeniedException, InternalServerException,
            ValidationException, DirectoryUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsers");

            return clientHandler.execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>()
                    .withOperationName("ListUsers").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listUsersRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     *
     * @param removeGroupMemberRequest
     * @return Result of the RemoveGroupMember operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ConflictException
     *         This error will occur when you try to create a resource that conflicts with an existing object. It can
     *         also occur when adding a member to a group that the member is already in.
     *         </p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.RemoveGroupMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/RemoveGroupMember"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveGroupMemberResponse removeGroupMember(RemoveGroupMemberRequest removeGroupMemberRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            DirectoryUnavailableException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException,
            DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveGroupMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemoveGroupMemberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeGroupMemberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeGroupMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveGroupMember");

            return clientHandler.execute(new ClientExecutionParams<RemoveGroupMemberRequest, RemoveGroupMemberResponse>()
                    .withOperationName("RemoveGroupMember").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(removeGroupMemberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveGroupMemberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches the specified directory for a group. You can find groups that match the <code>SearchString</code>
     * parameter with the value of their attributes included in the <code>SearchString</code> parameter.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>SearchGroups.NextToken</code> member contains a token that you pass in the
     * next call to <code>SearchGroups</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param searchGroupsRequest
     * @return Result of the SearchGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.SearchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/SearchGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchGroupsResponse searchGroups(SearchGroupsRequest searchGroupsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, DirectoryUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchGroups");

            return clientHandler.execute(new ClientExecutionParams<SearchGroupsRequest, SearchGroupsResponse>()
                    .withOperationName("SearchGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches the specified directory for a user. You can find users that match the <code>SearchString</code>
     * parameter with the value of their attributes included in the <code>SearchString</code> parameter.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>SearchUsers.NextToken</code> member contains a token that you pass in the
     * next call to <code>SearchUsers</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param searchUsersRequest
     * @return Result of the SearchUsers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/SearchUsers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchUsersResponse searchUsers(SearchUsersRequest searchUsersRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, DirectoryUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchUsers");

            return clientHandler.execute(new ClientExecutionParams<SearchUsersRequest, SearchUsersResponse>()
                    .withOperationName("SearchUsers").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(searchUsersRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchUsersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates group information.
     * </p>
     *
     * @param updateGroupRequest
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ConflictException
     *         This error will occur when you try to create a resource that conflicts with an existing object. It can
     *         also occur when adding a member to a group that the member is already in.
     *         </p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/UpdateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, DirectoryUnavailableException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                    .withOperationName("UpdateGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates user information.
     * </p>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have permission to perform the request or access the directory. It can also occur when the
     *         <code>DirectoryId</code> doesn't exist or the user, member, or group might be outside of your
     *         organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.
     * @throws InternalServerException
     *         The operation didn't succeed because an internal error occurred. Try again later.
     * @throws ValidationException
     *         The request isn't valid. Review the details in the error message to update the invalid parameters or
     *         values in your request.
     * @throws DirectoryUnavailableException
     *         The request could not be completed due to a problem in the configuration or current state of the
     *         specified directory.
     * @throws ConflictException
     *         This error will occur when you try to create a resource that conflicts with an existing object. It can
     *         also occur when adding a member to a group that the member is already in.
     *         </p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryServiceDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryServiceDataClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/UpdateUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, DirectoryUnavailableException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, DirectoryServiceDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUser");

            return clientHandler.execute(new ClientExecutionParams<UpdateUserRequest, UpdateUserResponse>()
                    .withOperationName("UpdateUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        DirectoryServiceDataServiceClientConfigurationBuilder serviceConfigBuilder = new DirectoryServiceDataServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(DirectoryServiceDataException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryUnavailableException")
                                .exceptionBuilderSupplier(DirectoryUnavailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build());
    }

    @Override
    public final DirectoryServiceDataServiceClientConfiguration serviceClientConfiguration() {
        return new DirectoryServiceDataServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
