/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserResponse extends DirectoryServiceDataResponse implements
        ToCopyableBuilder<DescribeUserResponse.Builder, DescribeUserResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DescribeUserResponse::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> DISTINGUISHED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistinguishedName").getter(getter(DescribeUserResponse::distinguishedName))
            .setter(setter(Builder::distinguishedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistinguishedName").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(DescribeUserResponse::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(DescribeUserResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GivenName").getter(getter(DescribeUserResponse::givenName)).setter(setter(Builder::givenName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()).build();

    private static final SdkField<Map<String, AttributeValue>> OTHER_ATTRIBUTES_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("OtherAttributes")
            .getter(getter(DescribeUserResponse::otherAttributes))
            .setter(setter(Builder::otherAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Realm")
            .getter(getter(DescribeUserResponse::realm)).setter(setter(Builder::realm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()).build();

    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMAccountName").getter(getter(DescribeUserResponse::samAccountName))
            .setter(setter(Builder::samAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()).build();

    private static final SdkField<String> SID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SID")
            .getter(getter(DescribeUserResponse::sid)).setter(setter(Builder::sid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()).build();

    private static final SdkField<String> SURNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Surname")
            .getter(getter(DescribeUserResponse::surname)).setter(setter(Builder::surname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()).build();

    private static final SdkField<String> USER_PRINCIPAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPrincipalName").getter(getter(DescribeUserResponse::userPrincipalName))
            .setter(setter(Builder::userPrincipalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPrincipalName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            DISTINGUISHED_NAME_FIELD, EMAIL_ADDRESS_FIELD, ENABLED_FIELD, GIVEN_NAME_FIELD, OTHER_ATTRIBUTES_FIELD, REALM_FIELD,
            SAM_ACCOUNT_NAME_FIELD, SID_FIELD, SURNAME_FIELD, USER_PRINCIPAL_NAME_FIELD));

    private final String directoryId;

    private final String distinguishedName;

    private final String emailAddress;

    private final Boolean enabled;

    private final String givenName;

    private final Map<String, AttributeValue> otherAttributes;

    private final String realm;

    private final String samAccountName;

    private final String sid;

    private final String surname;

    private final String userPrincipalName;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.distinguishedName = builder.distinguishedName;
        this.emailAddress = builder.emailAddress;
        this.enabled = builder.enabled;
        this.givenName = builder.givenName;
        this.otherAttributes = builder.otherAttributes;
        this.realm = builder.realm;
        this.samAccountName = builder.samAccountName;
        this.sid = builder.sid;
        this.surname = builder.surname;
        this.userPrincipalName = builder.userPrincipalName;
    }

    /**
     * <p>
     * The identifier (ID) of the directory that's associated with the user.
     * </p>
     * 
     * @return The identifier (ID) of the directory that's associated with the user.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The <a href="https://learn.microsoft.com/en-us/windows/win32/ad/object-names-and-identities#distinguished-name">
     * distinguished name</a> of the object.
     * </p>
     * 
     * @return The <a
     *         href="https://learn.microsoft.com/en-us/windows/win32/ad/object-names-and-identities#distinguished-name"
     *         >distinguished name</a> of the object.
     */
    public final String distinguishedName() {
        return distinguishedName;
    }

    /**
     * <p>
     * The email address of the user.
     * </p>
     * 
     * @return The email address of the user.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * Indicates whether the user account is active.
     * </p>
     * 
     * @return Indicates whether the user account is active.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The first name of the user.
     * </p>
     * 
     * @return The first name of the user.
     */
    public final String givenName() {
        return givenName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OtherAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOtherAttributes() {
        return otherAttributes != null && !(otherAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attribute values that are returned for the attribute names that are included in the request.
     * </p>
     * <note>
     * <p>
     * Attribute names are case insensitive.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOtherAttributes} method.
     * </p>
     * 
     * @return The attribute values that are returned for the attribute names that are included in the request. </p>
     *         <note>
     *         <p>
     *         Attribute names are case insensitive.
     *         </p>
     */
    public final Map<String, AttributeValue> otherAttributes() {
        return otherAttributes;
    }

    /**
     * <p>
     * The domain name that's associated with the user.
     * </p>
     * 
     * @return The domain name that's associated with the user.
     */
    public final String realm() {
        return realm;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public final String samAccountName() {
        return samAccountName;
    }

    /**
     * <p>
     * The unique security identifier (SID) of the user.
     * </p>
     * 
     * @return The unique security identifier (SID) of the user.
     */
    public final String sid() {
        return sid;
    }

    /**
     * <p>
     * The last name of the user.
     * </p>
     * 
     * @return The last name of the user.
     */
    public final String surname() {
        return surname;
    }

    /**
     * <p>
     * The UPN that is an Internet-style login name for a user and is based on the Internet standard <a
     * href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a>. The UPN is shorter than the distinguished name and
     * easier to remember.
     * </p>
     * 
     * @return The UPN that is an Internet-style login name for a user and is based on the Internet standard <a
     *         href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a>. The UPN is shorter than the distinguished name
     *         and easier to remember.
     */
    public final String userPrincipalName() {
        return userPrincipalName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(distinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(givenName());
        hashCode = 31 * hashCode + Objects.hashCode(hasOtherAttributes() ? otherAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(realm());
        hashCode = 31 * hashCode + Objects.hashCode(samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(sid());
        hashCode = 31 * hashCode + Objects.hashCode(surname());
        hashCode = 31 * hashCode + Objects.hashCode(userPrincipalName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(distinguishedName(), other.distinguishedName())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(givenName(), other.givenName()) && hasOtherAttributes() == other.hasOtherAttributes()
                && Objects.equals(otherAttributes(), other.otherAttributes()) && Objects.equals(realm(), other.realm())
                && Objects.equals(samAccountName(), other.samAccountName()) && Objects.equals(sid(), other.sid())
                && Objects.equals(surname(), other.surname()) && Objects.equals(userPrincipalName(), other.userPrincipalName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserResponse").add("DirectoryId", directoryId())
                .add("DistinguishedName", distinguishedName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***").add("Enabled", enabled())
                .add("GivenName", givenName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OtherAttributes", hasOtherAttributes() ? otherAttributes() : null).add("Realm", realm())
                .add("SAMAccountName", samAccountName()).add("SID", sid())
                .add("Surname", surname() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserPrincipalName", userPrincipalName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "DistinguishedName":
            return Optional.ofNullable(clazz.cast(distinguishedName()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "GivenName":
            return Optional.ofNullable(clazz.cast(givenName()));
        case "OtherAttributes":
            return Optional.ofNullable(clazz.cast(otherAttributes()));
        case "Realm":
            return Optional.ofNullable(clazz.cast(realm()));
        case "SAMAccountName":
            return Optional.ofNullable(clazz.cast(samAccountName()));
        case "SID":
            return Optional.ofNullable(clazz.cast(sid()));
        case "Surname":
            return Optional.ofNullable(clazz.cast(surname()));
        case "UserPrincipalName":
            return Optional.ofNullable(clazz.cast(userPrincipalName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryServiceDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeUserResponse> {
        /**
         * <p>
         * The identifier (ID) of the directory that's associated with the user.
         * </p>
         * 
         * @param directoryId
         *        The identifier (ID) of the directory that's associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The <a
         * href="https://learn.microsoft.com/en-us/windows/win32/ad/object-names-and-identities#distinguished-name"
         * >distinguished name</a> of the object.
         * </p>
         * 
         * @param distinguishedName
         *        The <a href=
         *        "https://learn.microsoft.com/en-us/windows/win32/ad/object-names-and-identities#distinguished-name"
         *        >distinguished name</a> of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distinguishedName(String distinguishedName);

        /**
         * <p>
         * The email address of the user.
         * </p>
         * 
         * @param emailAddress
         *        The email address of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * Indicates whether the user account is active.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the user account is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The first name of the user.
         * </p>
         * 
         * @param givenName
         *        The first name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder givenName(String givenName);

        /**
         * <p>
         * The attribute values that are returned for the attribute names that are included in the request.
         * </p>
         * <note>
         * <p>
         * Attribute names are case insensitive.
         * </p>
         * </note>
         * 
         * @param otherAttributes
         *        The attribute values that are returned for the attribute names that are included in the request. </p>
         *        <note>
         *        <p>
         *        Attribute names are case insensitive.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherAttributes(Map<String, AttributeValue> otherAttributes);

        /**
         * <p>
         * The domain name that's associated with the user.
         * </p>
         * 
         * @param realm
         *        The domain name that's associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realm(String realm);

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param samAccountName
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samAccountName(String samAccountName);

        /**
         * <p>
         * The unique security identifier (SID) of the user.
         * </p>
         * 
         * @param sid
         *        The unique security identifier (SID) of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sid(String sid);

        /**
         * <p>
         * The last name of the user.
         * </p>
         * 
         * @param surname
         *        The last name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder surname(String surname);

        /**
         * <p>
         * The UPN that is an Internet-style login name for a user and is based on the Internet standard <a
         * href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a>. The UPN is shorter than the distinguished name and
         * easier to remember.
         * </p>
         * 
         * @param userPrincipalName
         *        The UPN that is an Internet-style login name for a user and is based on the Internet standard <a
         *        href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a>. The UPN is shorter than the distinguished
         *        name and easier to remember.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPrincipalName(String userPrincipalName);
    }

    static final class BuilderImpl extends DirectoryServiceDataResponse.BuilderImpl implements Builder {
        private String directoryId;

        private String distinguishedName;

        private String emailAddress;

        private Boolean enabled;

        private String givenName;

        private Map<String, AttributeValue> otherAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String realm;

        private String samAccountName;

        private String sid;

        private String surname;

        private String userPrincipalName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            directoryId(model.directoryId);
            distinguishedName(model.distinguishedName);
            emailAddress(model.emailAddress);
            enabled(model.enabled);
            givenName(model.givenName);
            otherAttributes(model.otherAttributes);
            realm(model.realm);
            samAccountName(model.samAccountName);
            sid(model.sid);
            surname(model.surname);
            userPrincipalName(model.userPrincipalName);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getDistinguishedName() {
            return distinguishedName;
        }

        public final void setDistinguishedName(String distinguishedName) {
            this.distinguishedName = distinguishedName;
        }

        @Override
        public final Builder distinguishedName(String distinguishedName) {
            this.distinguishedName = distinguishedName;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getGivenName() {
            return givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getOtherAttributes() {
            Map<String, AttributeValue.Builder> result = AttributesCopier.copyToBuilder(this.otherAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOtherAttributes(Map<String, AttributeValue.BuilderImpl> otherAttributes) {
            this.otherAttributes = AttributesCopier.copyFromBuilder(otherAttributes);
        }

        @Override
        public final Builder otherAttributes(Map<String, AttributeValue> otherAttributes) {
            this.otherAttributes = AttributesCopier.copy(otherAttributes);
            return this;
        }

        public final String getRealm() {
            return realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final String getSamAccountName() {
            return samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSid() {
            return sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public final String getSurname() {
            return surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final String getUserPrincipalName() {
            return userPrincipalName;
        }

        public final void setUserPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
        }

        @Override
        public final Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            return this;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
