/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A group object that contains identifying information and attributes for a specified group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Group implements SdkPojo, Serializable, ToCopyableBuilder<Group.Builder, Group> {
    private static final SdkField<String> DISTINGUISHED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistinguishedName").getter(getter(Group::distinguishedName)).setter(setter(Builder::distinguishedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistinguishedName").build()).build();

    private static final SdkField<String> GROUP_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupScope").getter(getter(Group::groupScopeAsString)).setter(setter(Builder::groupScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupScope").build()).build();

    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupType").getter(getter(Group::groupTypeAsString)).setter(setter(Builder::groupType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupType").build()).build();

    private static final SdkField<Map<String, AttributeValue>> OTHER_ATTRIBUTES_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("OtherAttributes")
            .getter(getter(Group::otherAttributes))
            .setter(setter(Builder::otherAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMAccountName").getter(getter(Group::samAccountName)).setter(setter(Builder::samAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()).build();

    private static final SdkField<String> SID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SID")
            .getter(getter(Group::sid)).setter(setter(Builder::sid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTINGUISHED_NAME_FIELD,
            GROUP_SCOPE_FIELD, GROUP_TYPE_FIELD, OTHER_ATTRIBUTES_FIELD, SAM_ACCOUNT_NAME_FIELD, SID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String distinguishedName;

    private final String groupScope;

    private final String groupType;

    private final Map<String, AttributeValue> otherAttributes;

    private final String samAccountName;

    private final String sid;

    private Group(BuilderImpl builder) {
        this.distinguishedName = builder.distinguishedName;
        this.groupScope = builder.groupScope;
        this.groupType = builder.groupType;
        this.otherAttributes = builder.otherAttributes;
        this.samAccountName = builder.samAccountName;
        this.sid = builder.sid;
    }

    /**
     * <p>
     * The <a href="https://learn.microsoft.com/en-us/windows/win32/ad/object-names-and-identities#distinguished-name">
     * distinguished name</a> of the object.
     * </p>
     * 
     * @return The <a
     *         href="https://learn.microsoft.com/en-us/windows/win32/ad/object-names-and-identities#distinguished-name"
     *         >distinguished name</a> of the object.
     */
    public final String distinguishedName() {
        return distinguishedName;
    }

    /**
     * <p>
     * The scope of the AD group. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     * >Active Directory security groups</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupScope} will
     * return {@link GroupScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupScopeAsString}.
     * </p>
     * 
     * @return The scope of the AD group. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     *         >Active Directory security groups</a>
     * @see GroupScope
     */
    public final GroupScope groupScope() {
        return GroupScope.fromValue(groupScope);
    }

    /**
     * <p>
     * The scope of the AD group. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     * >Active Directory security groups</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupScope} will
     * return {@link GroupScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupScopeAsString}.
     * </p>
     * 
     * @return The scope of the AD group. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     *         >Active Directory security groups</a>
     * @see GroupScope
     */
    public final String groupScopeAsString() {
        return groupScope;
    }

    /**
     * <p>
     * The AD group type. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     * >Active Directory security group type</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupType} will
     * return {@link GroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupTypeAsString}.
     * </p>
     * 
     * @return The AD group type. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     *         >Active Directory security group type</a>.
     * @see GroupType
     */
    public final GroupType groupType() {
        return GroupType.fromValue(groupType);
    }

    /**
     * <p>
     * The AD group type. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     * >Active Directory security group type</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupType} will
     * return {@link GroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupTypeAsString}.
     * </p>
     * 
     * @return The AD group type. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     *         >Active Directory security group type</a>.
     * @see GroupType
     */
    public final String groupTypeAsString() {
        return groupType;
    }

    /**
     * For responses, this returns true if the service returned a value for the OtherAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOtherAttributes() {
        return otherAttributes != null && !(otherAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An expression of one or more attributes, data types, and the values of a group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOtherAttributes} method.
     * </p>
     * 
     * @return An expression of one or more attributes, data types, and the values of a group.
     */
    public final Map<String, AttributeValue> otherAttributes() {
        return otherAttributes;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public final String samAccountName() {
        return samAccountName;
    }

    /**
     * <p>
     * The unique security identifier (SID) of the group.
     * </p>
     * 
     * @return The unique security identifier (SID) of the group.
     */
    public final String sid() {
        return sid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(groupScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOtherAttributes() ? otherAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(sid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group) obj;
        return Objects.equals(distinguishedName(), other.distinguishedName())
                && Objects.equals(groupScopeAsString(), other.groupScopeAsString())
                && Objects.equals(groupTypeAsString(), other.groupTypeAsString())
                && hasOtherAttributes() == other.hasOtherAttributes()
                && Objects.equals(otherAttributes(), other.otherAttributes())
                && Objects.equals(samAccountName(), other.samAccountName()) && Objects.equals(sid(), other.sid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Group")
                .add("DistinguishedName", distinguishedName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GroupScope", groupScopeAsString()).add("GroupType", groupTypeAsString())
                .add("OtherAttributes", hasOtherAttributes() ? otherAttributes() : null).add("SAMAccountName", samAccountName())
                .add("SID", sid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistinguishedName":
            return Optional.ofNullable(clazz.cast(distinguishedName()));
        case "GroupScope":
            return Optional.ofNullable(clazz.cast(groupScopeAsString()));
        case "GroupType":
            return Optional.ofNullable(clazz.cast(groupTypeAsString()));
        case "OtherAttributes":
            return Optional.ofNullable(clazz.cast(otherAttributes()));
        case "SAMAccountName":
            return Optional.ofNullable(clazz.cast(samAccountName()));
        case "SID":
            return Optional.ofNullable(clazz.cast(sid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Group, T> g) {
        return obj -> g.apply((Group) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Group> {
        /**
         * <p>
         * The <a
         * href="https://learn.microsoft.com/en-us/windows/win32/ad/object-names-and-identities#distinguished-name"
         * >distinguished name</a> of the object.
         * </p>
         * 
         * @param distinguishedName
         *        The <a href=
         *        "https://learn.microsoft.com/en-us/windows/win32/ad/object-names-and-identities#distinguished-name"
         *        >distinguished name</a> of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distinguishedName(String distinguishedName);

        /**
         * <p>
         * The scope of the AD group. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         * >Active Directory security groups</a>
         * </p>
         * 
         * @param groupScope
         *        The scope of the AD group. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         *        >Active Directory security groups</a>
         * @see GroupScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupScope
         */
        Builder groupScope(String groupScope);

        /**
         * <p>
         * The scope of the AD group. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         * >Active Directory security groups</a>
         * </p>
         * 
         * @param groupScope
         *        The scope of the AD group. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         *        >Active Directory security groups</a>
         * @see GroupScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupScope
         */
        Builder groupScope(GroupScope groupScope);

        /**
         * <p>
         * The AD group type. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         * >Active Directory security group type</a>.
         * </p>
         * 
         * @param groupType
         *        The AD group type. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         *        >Active Directory security group type</a>.
         * @see GroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupType
         */
        Builder groupType(String groupType);

        /**
         * <p>
         * The AD group type. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         * >Active Directory security group type</a>.
         * </p>
         * 
         * @param groupType
         *        The AD group type. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         *        >Active Directory security group type</a>.
         * @see GroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupType
         */
        Builder groupType(GroupType groupType);

        /**
         * <p>
         * An expression of one or more attributes, data types, and the values of a group.
         * </p>
         * 
         * @param otherAttributes
         *        An expression of one or more attributes, data types, and the values of a group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherAttributes(Map<String, AttributeValue> otherAttributes);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param samAccountName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samAccountName(String samAccountName);

        /**
         * <p>
         * The unique security identifier (SID) of the group.
         * </p>
         * 
         * @param sid
         *        The unique security identifier (SID) of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sid(String sid);
    }

    static final class BuilderImpl implements Builder {
        private String distinguishedName;

        private String groupScope;

        private String groupType;

        private Map<String, AttributeValue> otherAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String samAccountName;

        private String sid;

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            distinguishedName(model.distinguishedName);
            groupScope(model.groupScope);
            groupType(model.groupType);
            otherAttributes(model.otherAttributes);
            samAccountName(model.samAccountName);
            sid(model.sid);
        }

        public final String getDistinguishedName() {
            return distinguishedName;
        }

        public final void setDistinguishedName(String distinguishedName) {
            this.distinguishedName = distinguishedName;
        }

        @Override
        public final Builder distinguishedName(String distinguishedName) {
            this.distinguishedName = distinguishedName;
            return this;
        }

        public final String getGroupScope() {
            return groupScope;
        }

        public final void setGroupScope(String groupScope) {
            this.groupScope = groupScope;
        }

        @Override
        public final Builder groupScope(String groupScope) {
            this.groupScope = groupScope;
            return this;
        }

        @Override
        public final Builder groupScope(GroupScope groupScope) {
            this.groupScope(groupScope == null ? null : groupScope.toString());
            return this;
        }

        public final String getGroupType() {
            return groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final Map<String, AttributeValue.Builder> getOtherAttributes() {
            Map<String, AttributeValue.Builder> result = AttributesCopier.copyToBuilder(this.otherAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOtherAttributes(Map<String, AttributeValue.BuilderImpl> otherAttributes) {
            this.otherAttributes = AttributesCopier.copyFromBuilder(otherAttributes);
        }

        @Override
        public final Builder otherAttributes(Map<String, AttributeValue> otherAttributes) {
            this.otherAttributes = AttributesCopier.copy(otherAttributes);
            return this;
        }

        public final String getSamAccountName() {
            return samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSid() {
            return sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        @Override
        public Group build() {
            return new Group(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
