/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupMembersResponse extends DirectoryServiceDataResponse implements
        ToCopyableBuilder<ListGroupMembersResponse.Builder, ListGroupMembersResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(ListGroupMembersResponse::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> MEMBER_REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberRealm").getter(getter(ListGroupMembersResponse::memberRealm)).setter(setter(Builder::memberRealm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberRealm").build()).build();

    private static final SdkField<List<Member>> MEMBERS_FIELD = SdkField
            .<List<Member>> builder(MarshallingType.LIST)
            .memberName("Members")
            .getter(getter(ListGroupMembersResponse::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Member> builder(MarshallingType.SDK_POJO)
                                            .constructor(Member::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupMembersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Realm")
            .getter(getter(ListGroupMembersResponse::realm)).setter(setter(Builder::realm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            MEMBER_REALM_FIELD, MEMBERS_FIELD, NEXT_TOKEN_FIELD, REALM_FIELD));

    private final String directoryId;

    private final String memberRealm;

    private final List<Member> members;

    private final String nextToken;

    private final String realm;

    private ListGroupMembersResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.memberRealm = builder.memberRealm;
        this.members = builder.members;
        this.nextToken = builder.nextToken;
        this.realm = builder.realm;
    }

    /**
     * <p>
     * Identifier (ID) of the directory associated with the group.
     * </p>
     * 
     * @return Identifier (ID) of the directory associated with the group.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The domain name that's associated with the member.
     * </p>
     * 
     * @return The domain name that's associated with the member.
     */
    public final String memberRealm() {
        return memberRealm;
    }

    /**
     * For responses, this returns true if the service returned a value for the Members property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMembers() {
        return members != null && !(members instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The member information that the request returns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMembers} method.
     * </p>
     * 
     * @return The member information that the request returns.
     */
    public final List<Member> members() {
        return members;
    }

    /**
     * <p>
     * An encoded paging token for paginated calls that can be passed back to retrieve the next page.
     * </p>
     * 
     * @return An encoded paging token for paginated calls that can be passed back to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The domain name that's associated with the group.
     * </p>
     * 
     * @return The domain name that's associated with the group.
     */
    public final String realm() {
        return realm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(memberRealm());
        hashCode = 31 * hashCode + Objects.hashCode(hasMembers() ? members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(realm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupMembersResponse)) {
            return false;
        }
        ListGroupMembersResponse other = (ListGroupMembersResponse) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(memberRealm(), other.memberRealm())
                && hasMembers() == other.hasMembers() && Objects.equals(members(), other.members())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(realm(), other.realm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupMembersResponse").add("DirectoryId", directoryId()).add("MemberRealm", memberRealm())
                .add("Members", hasMembers() ? members() : null)
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").add("Realm", realm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "MemberRealm":
            return Optional.ofNullable(clazz.cast(memberRealm()));
        case "Members":
            return Optional.ofNullable(clazz.cast(members()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Realm":
            return Optional.ofNullable(clazz.cast(realm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupMembersResponse, T> g) {
        return obj -> g.apply((ListGroupMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryServiceDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListGroupMembersResponse> {
        /**
         * <p>
         * Identifier (ID) of the directory associated with the group.
         * </p>
         * 
         * @param directoryId
         *        Identifier (ID) of the directory associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The domain name that's associated with the member.
         * </p>
         * 
         * @param memberRealm
         *        The domain name that's associated with the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberRealm(String memberRealm);

        /**
         * <p>
         * The member information that the request returns.
         * </p>
         * 
         * @param members
         *        The member information that the request returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<Member> members);

        /**
         * <p>
         * The member information that the request returns.
         * </p>
         * 
         * @param members
         *        The member information that the request returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Member... members);

        /**
         * <p>
         * The member information that the request returns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directoryservicedata.model.Member.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.directoryservicedata.model.Member#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directoryservicedata.model.Member.Builder#build()} is called
         * immediately and its result is passed to {@link #members(List<Member>)}.
         * 
         * @param members
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directoryservicedata.model.Member.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #members(java.util.Collection<Member>)
         */
        Builder members(Consumer<Member.Builder>... members);

        /**
         * <p>
         * An encoded paging token for paginated calls that can be passed back to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        An encoded paging token for paginated calls that can be passed back to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The domain name that's associated with the group.
         * </p>
         * 
         * @param realm
         *        The domain name that's associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realm(String realm);
    }

    static final class BuilderImpl extends DirectoryServiceDataResponse.BuilderImpl implements Builder {
        private String directoryId;

        private String memberRealm;

        private List<Member> members = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String realm;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupMembersResponse model) {
            super(model);
            directoryId(model.directoryId);
            memberRealm(model.memberRealm);
            members(model.members);
            nextToken(model.nextToken);
            realm(model.realm);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getMemberRealm() {
            return memberRealm;
        }

        public final void setMemberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
        }

        @Override
        public final Builder memberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
            return this;
        }

        public final List<Member.Builder> getMembers() {
            List<Member.Builder> result = MemberListCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<Member.BuilderImpl> members) {
            this.members = MemberListCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<Member> members) {
            this.members = MemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Member... members) {
            members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<Member.Builder>... members) {
            members(Stream.of(members).map(c -> Member.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRealm() {
            return realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        @Override
        public ListGroupMembersResponse build() {
            return new ListGroupMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
