/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupsForMemberRequest extends DirectoryServiceDataRequest implements
        ToCopyableBuilder<ListGroupsForMemberRequest.Builder, ListGroupsForMemberRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(ListGroupsForMemberRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListGroupsForMemberRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> MEMBER_REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberRealm").getter(getter(ListGroupsForMemberRequest::memberRealm))
            .setter(setter(Builder::memberRealm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberRealm").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupsForMemberRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Realm")
            .getter(getter(ListGroupsForMemberRequest::realm)).setter(setter(Builder::realm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()).build();

    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMAccountName").getter(getter(ListGroupsForMemberRequest::samAccountName))
            .setter(setter(Builder::samAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            MAX_RESULTS_FIELD, MEMBER_REALM_FIELD, NEXT_TOKEN_FIELD, REALM_FIELD, SAM_ACCOUNT_NAME_FIELD));

    private final String directoryId;

    private final Integer maxResults;

    private final String memberRealm;

    private final String nextToken;

    private final String realm;

    private final String samAccountName;

    private ListGroupsForMemberRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.maxResults = builder.maxResults;
        this.memberRealm = builder.memberRealm;
        this.nextToken = builder.nextToken;
        this.realm = builder.realm;
        this.samAccountName = builder.samAccountName;
    }

    /**
     * <p>
     * The identifier (ID) of the directory that's associated with the member.
     * </p>
     * 
     * @return The identifier (ID) of the directory that's associated with the member.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request.
     * </p>
     * 
     * @return The maximum number of results to be returned per request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The domain name that's associated with the group member.
     * </p>
     * <note>
     * <p>
     * This parameter is optional, so you can limit your results to the group members in a specific domain.
     * </p>
     * <p>
     * This parameter is case insensitive and defaults to <code>Realm</code>
     * </p>
     * </note>
     * 
     * @return The domain name that's associated with the group member. </p> <note>
     *         <p>
     *         This parameter is optional, so you can limit your results to the group members in a specific domain.
     *         </p>
     *         <p>
     *         This parameter is case insensitive and defaults to <code>Realm</code>
     *         </p>
     */
    public final String memberRealm() {
        return memberRealm;
    }

    /**
     * <p>
     * An encoded paging token for paginated calls that can be passed back to retrieve the next page.
     * </p>
     * 
     * @return An encoded paging token for paginated calls that can be passed back to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The domain name that's associated with the group.
     * </p>
     * <note>
     * <p>
     * This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When no value
     * is defined, only your Managed Microsoft AD groups are returned.
     * </p>
     * <p>
     * This value is case insensitive and defaults to your Managed Microsoft AD domain.
     * </p>
     * </note>
     * 
     * @return The domain name that's associated with the group. </p> <note>
     *         <p>
     *         This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When no
     *         value is defined, only your Managed Microsoft AD groups are returned.
     *         </p>
     *         <p>
     *         This value is case insensitive and defaults to your Managed Microsoft AD domain.
     *         </p>
     */
    public final String realm() {
        return realm;
    }

    /**
     * <p>
     * The <code>SAMAccountName</code> of the user, group, or computer that's a member of the group.
     * </p>
     * 
     * @return The <code>SAMAccountName</code> of the user, group, or computer that's a member of the group.
     */
    public final String samAccountName() {
        return samAccountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(memberRealm());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(realm());
        hashCode = 31 * hashCode + Objects.hashCode(samAccountName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsForMemberRequest)) {
            return false;
        }
        ListGroupsForMemberRequest other = (ListGroupsForMemberRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(memberRealm(), other.memberRealm()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(realm(), other.realm()) && Objects.equals(samAccountName(), other.samAccountName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupsForMemberRequest").add("DirectoryId", directoryId()).add("MaxResults", maxResults())
                .add("MemberRealm", memberRealm())
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").add("Realm", realm())
                .add("SAMAccountName", samAccountName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "MemberRealm":
            return Optional.ofNullable(clazz.cast(memberRealm()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Realm":
            return Optional.ofNullable(clazz.cast(realm()));
        case "SAMAccountName":
            return Optional.ofNullable(clazz.cast(samAccountName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsForMemberRequest, T> g) {
        return obj -> g.apply((ListGroupsForMemberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryServiceDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListGroupsForMemberRequest> {
        /**
         * <p>
         * The identifier (ID) of the directory that's associated with the member.
         * </p>
         * 
         * @param directoryId
         *        The identifier (ID) of the directory that's associated with the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The maximum number of results to be returned per request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The domain name that's associated with the group member.
         * </p>
         * <note>
         * <p>
         * This parameter is optional, so you can limit your results to the group members in a specific domain.
         * </p>
         * <p>
         * This parameter is case insensitive and defaults to <code>Realm</code>
         * </p>
         * </note>
         * 
         * @param memberRealm
         *        The domain name that's associated with the group member. </p> <note>
         *        <p>
         *        This parameter is optional, so you can limit your results to the group members in a specific domain.
         *        </p>
         *        <p>
         *        This parameter is case insensitive and defaults to <code>Realm</code>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberRealm(String memberRealm);

        /**
         * <p>
         * An encoded paging token for paginated calls that can be passed back to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        An encoded paging token for paginated calls that can be passed back to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The domain name that's associated with the group.
         * </p>
         * <note>
         * <p>
         * This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When no
         * value is defined, only your Managed Microsoft AD groups are returned.
         * </p>
         * <p>
         * This value is case insensitive and defaults to your Managed Microsoft AD domain.
         * </p>
         * </note>
         * 
         * @param realm
         *        The domain name that's associated with the group. </p> <note>
         *        <p>
         *        This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When
         *        no value is defined, only your Managed Microsoft AD groups are returned.
         *        </p>
         *        <p>
         *        This value is case insensitive and defaults to your Managed Microsoft AD domain.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realm(String realm);

        /**
         * <p>
         * The <code>SAMAccountName</code> of the user, group, or computer that's a member of the group.
         * </p>
         * 
         * @param samAccountName
         *        The <code>SAMAccountName</code> of the user, group, or computer that's a member of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samAccountName(String samAccountName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryServiceDataRequest.BuilderImpl implements Builder {
        private String directoryId;

        private Integer maxResults;

        private String memberRealm;

        private String nextToken;

        private String realm;

        private String samAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsForMemberRequest model) {
            super(model);
            directoryId(model.directoryId);
            maxResults(model.maxResults);
            memberRealm(model.memberRealm);
            nextToken(model.nextToken);
            realm(model.realm);
            samAccountName(model.samAccountName);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getMemberRealm() {
            return memberRealm;
        }

        public final void setMemberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
        }

        @Override
        public final Builder memberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRealm() {
            return realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final String getSamAccountName() {
            return samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupsForMemberRequest build() {
            return new ListGroupsForMemberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
