/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchGroupsResponse extends DirectoryServiceDataResponse implements
        ToCopyableBuilder<SearchGroupsResponse.Builder, SearchGroupsResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(SearchGroupsResponse::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<Group>> GROUPS_FIELD = SdkField
            .<List<Group>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(SearchGroupsResponse::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Group> builder(MarshallingType.SDK_POJO)
                                            .constructor(Group::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Realm")
            .getter(getter(SearchGroupsResponse::realm)).setter(setter(Builder::realm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            GROUPS_FIELD, NEXT_TOKEN_FIELD, REALM_FIELD));

    private final String directoryId;

    private final List<Group> groups;

    private final String nextToken;

    private final String realm;

    private SearchGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.groups = builder.groups;
        this.nextToken = builder.nextToken;
        this.realm = builder.realm;
    }

    /**
     * <p>
     * The identifier (ID) of the directory that's associated with the group.
     * </p>
     * 
     * @return The identifier (ID) of the directory that's associated with the group.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The group information that the request returns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The group information that the request returns.
     */
    public final List<Group> groups() {
        return groups;
    }

    /**
     * <p>
     * An encoded paging token for paginated calls that can be passed back to retrieve the next page.
     * </p>
     * 
     * @return An encoded paging token for paginated calls that can be passed back to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The domain that's associated with the group.
     * </p>
     * 
     * @return The domain that's associated with the group.
     */
    public final String realm() {
        return realm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(realm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGroupsResponse)) {
            return false;
        }
        SearchGroupsResponse other = (SearchGroupsResponse) obj;
        return Objects.equals(directoryId(), other.directoryId()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(realm(), other.realm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchGroupsResponse").add("DirectoryId", directoryId())
                .add("Groups", hasGroups() ? groups() : null)
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").add("Realm", realm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Realm":
            return Optional.ofNullable(clazz.cast(realm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchGroupsResponse, T> g) {
        return obj -> g.apply((SearchGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryServiceDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchGroupsResponse> {
        /**
         * <p>
         * The identifier (ID) of the directory that's associated with the group.
         * </p>
         * 
         * @param directoryId
         *        The identifier (ID) of the directory that's associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The group information that the request returns.
         * </p>
         * 
         * @param groups
         *        The group information that the request returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<Group> groups);

        /**
         * <p>
         * The group information that the request returns.
         * </p>
         * 
         * @param groups
         *        The group information that the request returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Group... groups);

        /**
         * <p>
         * The group information that the request returns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directoryservicedata.model.Group.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.directoryservicedata.model.Group#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directoryservicedata.model.Group.Builder#build()} is called
         * immediately and its result is passed to {@link #groups(List<Group>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directoryservicedata.model.Group.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<Group>)
         */
        Builder groups(Consumer<Group.Builder>... groups);

        /**
         * <p>
         * An encoded paging token for paginated calls that can be passed back to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        An encoded paging token for paginated calls that can be passed back to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The domain that's associated with the group.
         * </p>
         * 
         * @param realm
         *        The domain that's associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realm(String realm);
    }

    static final class BuilderImpl extends DirectoryServiceDataResponse.BuilderImpl implements Builder {
        private String directoryId;

        private List<Group> groups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String realm;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGroupsResponse model) {
            super(model);
            directoryId(model.directoryId);
            groups(model.groups);
            nextToken(model.nextToken);
            realm(model.realm);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final List<Group.Builder> getGroups() {
            List<Group.Builder> result = GroupListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<Group.BuilderImpl> groups) {
            this.groups = GroupListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<Group> groups) {
            this.groups = GroupListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Group... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<Group.Builder>... groups) {
            groups(Stream.of(groups).map(c -> Group.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRealm() {
            return realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        @Override
        public SearchGroupsResponse build() {
            return new SearchGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
