/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddGroupMemberRequest extends DirectoryServiceDataRequest implements
        ToCopyableBuilder<AddGroupMemberRequest.Builder, AddGroupMemberRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(AddGroupMemberRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(AddGroupMemberRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(AddGroupMemberRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> MEMBER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberName").getter(getter(AddGroupMemberRequest::memberName)).setter(setter(Builder::memberName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberName").build()).build();

    private static final SdkField<String> MEMBER_REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberRealm").getter(getter(AddGroupMemberRequest::memberRealm)).setter(setter(Builder::memberRealm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberRealm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DIRECTORY_ID_FIELD, GROUP_NAME_FIELD, MEMBER_NAME_FIELD, MEMBER_REALM_FIELD));

    private final String clientToken;

    private final String directoryId;

    private final String groupName;

    private final String memberName;

    private final String memberRealm;

    private AddGroupMemberRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.directoryId = builder.directoryId;
        this.groupName = builder.groupName;
        this.memberName = builder.memberName;
        this.memberRealm = builder.memberRealm;
    }

    /**
     * <p>
     * A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so multiple
     * identical calls have the same effect as one single call.
     * </p>
     * <p>
     * A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any request
     * with the same client token is treated as a new request. If the request succeeds, any future uses of that token
     * will be idempotent for another 8 hours.
     * </p>
     * <p>
     * If you submit a request with the same client token but change one of the other parameters within the 8-hour
     * idempotency window, Directory Service Data returns an <code>ConflictException</code>.
     * </p>
     * <note>
     * <p>
     * This parameter is optional when using the CLI or SDK.
     * </p>
     * </note>
     * 
     * @return A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so
     *         multiple identical calls have the same effect as one single call. </p>
     *         <p>
     *         A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
     *         request with the same client token is treated as a new request. If the request succeeds, any future uses
     *         of that token will be idempotent for another 8 hours.
     *         </p>
     *         <p>
     *         If you submit a request with the same client token but change one of the other parameters within the
     *         8-hour idempotency window, Directory Service Data returns an <code>ConflictException</code>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is optional when using the CLI or SDK.
     *         </p>
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier (ID) of the directory that's associated with the group.
     * </p>
     * 
     * @return The identifier (ID) of the directory that's associated with the group.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The <code>SAMAccountName</code> of the user, group, or computer to add as a group member.
     * </p>
     * 
     * @return The <code>SAMAccountName</code> of the user, group, or computer to add as a group member.
     */
    public final String memberName() {
        return memberName;
    }

    /**
     * <p>
     * The domain name that's associated with the group member. This parameter is required only when adding a member
     * outside of your Managed Microsoft AD domain to a group inside of your Managed Microsoft AD domain. This parameter
     * defaults to the Managed Microsoft AD domain.
     * </p>
     * <note>
     * <p>
     * This parameter is case insensitive.
     * </p>
     * </note>
     * 
     * @return The domain name that's associated with the group member. This parameter is required only when adding a
     *         member outside of your Managed Microsoft AD domain to a group inside of your Managed Microsoft AD domain.
     *         This parameter defaults to the Managed Microsoft AD domain. </p> <note>
     *         <p>
     *         This parameter is case insensitive.
     *         </p>
     */
    public final String memberRealm() {
        return memberRealm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(memberName());
        hashCode = 31 * hashCode + Objects.hashCode(memberRealm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddGroupMemberRequest)) {
            return false;
        }
        AddGroupMemberRequest other = (AddGroupMemberRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(memberName(), other.memberName())
                && Objects.equals(memberRealm(), other.memberRealm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddGroupMemberRequest").add("ClientToken", clientToken()).add("DirectoryId", directoryId())
                .add("GroupName", groupName()).add("MemberName", memberName()).add("MemberRealm", memberRealm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "MemberName":
            return Optional.ofNullable(clazz.cast(memberName()));
        case "MemberRealm":
            return Optional.ofNullable(clazz.cast(memberRealm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddGroupMemberRequest, T> g) {
        return obj -> g.apply((AddGroupMemberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryServiceDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AddGroupMemberRequest> {
        /**
         * <p>
         * A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so
         * multiple identical calls have the same effect as one single call.
         * </p>
         * <p>
         * A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
         * request with the same client token is treated as a new request. If the request succeeds, any future uses of
         * that token will be idempotent for another 8 hours.
         * </p>
         * <p>
         * If you submit a request with the same client token but change one of the other parameters within the 8-hour
         * idempotency window, Directory Service Data returns an <code>ConflictException</code>.
         * </p>
         * <note>
         * <p>
         * This parameter is optional when using the CLI or SDK.
         * </p>
         * </note>
         * 
         * @param clientToken
         *        A unique and case-sensitive identifier that you provide to make sure the idempotency of the request,
         *        so multiple identical calls have the same effect as one single call. </p>
         *        <p>
         *        A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
         *        request with the same client token is treated as a new request. If the request succeeds, any future
         *        uses of that token will be idempotent for another 8 hours.
         *        </p>
         *        <p>
         *        If you submit a request with the same client token but change one of the other parameters within the
         *        8-hour idempotency window, Directory Service Data returns an <code>ConflictException</code>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is optional when using the CLI or SDK.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier (ID) of the directory that's associated with the group.
         * </p>
         * 
         * @param directoryId
         *        The identifier (ID) of the directory that's associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param groupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The <code>SAMAccountName</code> of the user, group, or computer to add as a group member.
         * </p>
         * 
         * @param memberName
         *        The <code>SAMAccountName</code> of the user, group, or computer to add as a group member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberName(String memberName);

        /**
         * <p>
         * The domain name that's associated with the group member. This parameter is required only when adding a member
         * outside of your Managed Microsoft AD domain to a group inside of your Managed Microsoft AD domain. This
         * parameter defaults to the Managed Microsoft AD domain.
         * </p>
         * <note>
         * <p>
         * This parameter is case insensitive.
         * </p>
         * </note>
         * 
         * @param memberRealm
         *        The domain name that's associated with the group member. This parameter is required only when adding a
         *        member outside of your Managed Microsoft AD domain to a group inside of your Managed Microsoft AD
         *        domain. This parameter defaults to the Managed Microsoft AD domain. </p> <note>
         *        <p>
         *        This parameter is case insensitive.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberRealm(String memberRealm);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryServiceDataRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String directoryId;

        private String groupName;

        private String memberName;

        private String memberRealm;

        private BuilderImpl() {
        }

        private BuilderImpl(AddGroupMemberRequest model) {
            super(model);
            clientToken(model.clientToken);
            directoryId(model.directoryId);
            groupName(model.groupName);
            memberName(model.memberName);
            memberRealm(model.memberRealm);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getMemberName() {
            return memberName;
        }

        public final void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public final Builder memberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public final String getMemberRealm() {
            return memberRealm;
        }

        public final void setMemberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
        }

        @Override
        public final Builder memberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddGroupMemberRequest build() {
            return new AddGroupMemberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
