/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data type for an attribute. Each attribute value is described as a name-value pair. The name is the AD schema
 * name, and the value is the data itself. For a list of supported attributes, see <a
 * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory Service Data
 * Attributes</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeValue implements SdkPojo, Serializable, ToCopyableBuilder<AttributeValue.Builder, AttributeValue> {
    private static final SdkField<Boolean> BOOL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("BOOL")
            .getter(getter(AttributeValue::bool)).setter(setter(Builder::bool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BOOL").build()).build();

    private static final SdkField<Long> N_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("N")
            .getter(getter(AttributeValue::n)).setter(setter(Builder::n))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("N").build()).build();

    private static final SdkField<String> S_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S")
            .getter(getter(AttributeValue::s)).setter(setter(Builder::s))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()).build();

    private static final SdkField<List<String>> SS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SS")
            .getter(getter(AttributeValue::ss))
            .setter(setter(Builder::ss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SS").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOL_FIELD, N_FIELD, S_FIELD,
            SS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean bool;

    private final Long n;

    private final String s;

    private final List<String> ss;

    private final Type type;

    private AttributeValue(BuilderImpl builder) {
        this.bool = builder.bool;
        this.n = builder.n;
        this.s = builder.s;
        this.ss = builder.ss;
        this.type = builder.type;
    }

    /**
     * <p>
     * Indicates that the attribute type value is a boolean. For example:
     * </p>
     * <p>
     * <code>"BOOL": true</code>
     * </p>
     * 
     * @return Indicates that the attribute type value is a boolean. For example: </p>
     *         <p>
     *         <code>"BOOL": true</code>
     */
    public final Boolean bool() {
        return bool;
    }

    /**
     * <p>
     * Indicates that the attribute type value is a number. For example:
     * </p>
     * <p>
     * <code>"N": "16"</code>
     * </p>
     * 
     * @return Indicates that the attribute type value is a number. For example: </p>
     *         <p>
     *         <code>"N": "16"</code>
     */
    public final Long n() {
        return n;
    }

    /**
     * <p>
     * Indicates that the attribute type value is a string. For example:
     * </p>
     * <p>
     * <code>"S": "S Group"</code>
     * </p>
     * 
     * @return Indicates that the attribute type value is a string. For example: </p>
     *         <p>
     *         <code>"S": "S Group"</code>
     */
    public final String s() {
        return s;
    }

    /**
     * For responses, this returns true if the service returned a value for the SS property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSs() {
        return ss != null && !(ss instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates that the attribute type value is a string set. For example:
     * </p>
     * <p>
     * <code>"SS": ["sample_service_class/host.sample.com:1234/sample_service_name_1", "sample_service_class/host.sample.com:1234/sample_service_name_2"]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSs} method.
     * </p>
     * 
     * @return Indicates that the attribute type value is a string set. For example: </p>
     *         <p>
     *         <code>"SS": ["sample_service_class/host.sample.com:1234/sample_service_name_1", "sample_service_class/host.sample.com:1234/sample_service_name_2"]</code>
     */
    public final List<String> ss() {
        return ss;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bool());
        hashCode = 31 * hashCode + Objects.hashCode(n());
        hashCode = 31 * hashCode + Objects.hashCode(s());
        hashCode = 31 * hashCode + Objects.hashCode(hasSs() ? ss() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue) obj;
        return Objects.equals(bool(), other.bool()) && Objects.equals(n(), other.n()) && Objects.equals(s(), other.s())
                && hasSs() == other.hasSs() && Objects.equals(ss(), other.ss());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeValue").add("BOOL", bool() == null ? null : "*** Sensitive Data Redacted ***")
                .add("N", n() == null ? null : "*** Sensitive Data Redacted ***")
                .add("S", s() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SS", ss() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BOOL":
            return Optional.ofNullable(clazz.cast(bool()));
        case "N":
            return Optional.ofNullable(clazz.cast(n()));
        case "S":
            return Optional.ofNullable(clazz.cast(s()));
        case "SS":
            return Optional.ofNullable(clazz.cast(ss()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #bool()} initialized to the given value.
     *
     * <p>
     * Indicates that the attribute type value is a boolean. For example:
     * </p>
     * <p>
     * <code>"BOOL": true</code>
     * </p>
     * 
     * @param bool
     *        Indicates that the attribute type value is a boolean. For example: </p>
     *        <p>
     *        <code>"BOOL": true</code>
     */
    public static AttributeValue fromBool(Boolean bool) {
        return builder().bool(bool).build();
    }

    /**
     * Create an instance of this class with {@link #n()} initialized to the given value.
     *
     * <p>
     * Indicates that the attribute type value is a number. For example:
     * </p>
     * <p>
     * <code>"N": "16"</code>
     * </p>
     * 
     * @param n
     *        Indicates that the attribute type value is a number. For example: </p>
     *        <p>
     *        <code>"N": "16"</code>
     */
    public static AttributeValue fromN(Long n) {
        return builder().n(n).build();
    }

    /**
     * Create an instance of this class with {@link #s()} initialized to the given value.
     *
     * <p>
     * Indicates that the attribute type value is a string. For example:
     * </p>
     * <p>
     * <code>"S": "S Group"</code>
     * </p>
     * 
     * @param s
     *        Indicates that the attribute type value is a string. For example: </p>
     *        <p>
     *        <code>"S": "S Group"</code>
     */
    public static AttributeValue fromS(String s) {
        return builder().s(s).build();
    }

    /**
     * Create an instance of this class with {@link #ss()} initialized to the given value.
     *
     * <p>
     * Indicates that the attribute type value is a string set. For example:
     * </p>
     * <p>
     * <code>"SS": ["sample_service_class/host.sample.com:1234/sample_service_name_1", "sample_service_class/host.sample.com:1234/sample_service_name_2"]</code>
     * </p>
     * 
     * @param ss
     *        Indicates that the attribute type value is a string set. For example: </p>
     *        <p>
     *        <code>"SS": ["sample_service_class/host.sample.com:1234/sample_service_name_1", "sample_service_class/host.sample.com:1234/sample_service_name_2"]</code>
     */
    public static AttributeValue fromSs(List<String> ss) {
        return builder().ss(ss).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeValue, T> g) {
        return obj -> g.apply((AttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeValue> {
        /**
         * <p>
         * Indicates that the attribute type value is a boolean. For example:
         * </p>
         * <p>
         * <code>"BOOL": true</code>
         * </p>
         * 
         * @param bool
         *        Indicates that the attribute type value is a boolean. For example: </p>
         *        <p>
         *        <code>"BOOL": true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bool(Boolean bool);

        /**
         * <p>
         * Indicates that the attribute type value is a number. For example:
         * </p>
         * <p>
         * <code>"N": "16"</code>
         * </p>
         * 
         * @param n
         *        Indicates that the attribute type value is a number. For example: </p>
         *        <p>
         *        <code>"N": "16"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder n(Long n);

        /**
         * <p>
         * Indicates that the attribute type value is a string. For example:
         * </p>
         * <p>
         * <code>"S": "S Group"</code>
         * </p>
         * 
         * @param s
         *        Indicates that the attribute type value is a string. For example: </p>
         *        <p>
         *        <code>"S": "S Group"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s(String s);

        /**
         * <p>
         * Indicates that the attribute type value is a string set. For example:
         * </p>
         * <p>
         * <code>"SS": ["sample_service_class/host.sample.com:1234/sample_service_name_1", "sample_service_class/host.sample.com:1234/sample_service_name_2"]</code>
         * </p>
         * 
         * @param ss
         *        Indicates that the attribute type value is a string set. For example: </p>
         *        <p>
         *        <code>"SS": ["sample_service_class/host.sample.com:1234/sample_service_name_1", "sample_service_class/host.sample.com:1234/sample_service_name_2"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ss(Collection<String> ss);

        /**
         * <p>
         * Indicates that the attribute type value is a string set. For example:
         * </p>
         * <p>
         * <code>"SS": ["sample_service_class/host.sample.com:1234/sample_service_name_1", "sample_service_class/host.sample.com:1234/sample_service_name_2"]</code>
         * </p>
         * 
         * @param ss
         *        Indicates that the attribute type value is a string set. For example: </p>
         *        <p>
         *        <code>"SS": ["sample_service_class/host.sample.com:1234/sample_service_name_1", "sample_service_class/host.sample.com:1234/sample_service_name_2"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ss(String... ss);
    }

    static final class BuilderImpl implements Builder {
        private Boolean bool;

        private Long n;

        private String s;

        private List<String> ss = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            bool(model.bool);
            n(model.n);
            s(model.s);
            ss(model.ss);
        }

        public final Boolean getBool() {
            return bool;
        }

        public final void setBool(Boolean bool) {
            Object oldValue = this.bool;
            this.bool = bool;
            handleUnionValueChange(Type.BOOL, oldValue, this.bool);
        }

        @Override
        public final Builder bool(Boolean bool) {
            Object oldValue = this.bool;
            this.bool = bool;
            handleUnionValueChange(Type.BOOL, oldValue, this.bool);
            return this;
        }

        public final Long getN() {
            return n;
        }

        public final void setN(Long n) {
            Object oldValue = this.n;
            this.n = n;
            handleUnionValueChange(Type.N, oldValue, this.n);
        }

        @Override
        public final Builder n(Long n) {
            Object oldValue = this.n;
            this.n = n;
            handleUnionValueChange(Type.N, oldValue, this.n);
            return this;
        }

        public final String getS() {
            return s;
        }

        public final void setS(String s) {
            Object oldValue = this.s;
            this.s = s;
            handleUnionValueChange(Type.S, oldValue, this.s);
        }

        @Override
        public final Builder s(String s) {
            Object oldValue = this.s;
            this.s = s;
            handleUnionValueChange(Type.S, oldValue, this.s);
            return this;
        }

        public final Collection<String> getSs() {
            if (ss instanceof SdkAutoConstructList) {
                return null;
            }
            return ss;
        }

        public final void setSs(Collection<String> ss) {
            Object oldValue = this.ss;
            this.ss = StringSetAttributeValueCopier.copy(ss);
            handleUnionValueChange(Type.SS, oldValue, this.ss);
        }

        @Override
        public final Builder ss(Collection<String> ss) {
            Object oldValue = this.ss;
            this.ss = StringSetAttributeValueCopier.copy(ss);
            handleUnionValueChange(Type.SS, oldValue, this.ss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ss(String... ss) {
            ss(Arrays.asList(ss));
            return this;
        }

        @Override
        public AttributeValue build() {
            return new AttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AttributeValue#type()
     */
    public enum Type {
        BOOL,

        N,

        S,

        SS,

        UNKNOWN_TO_SDK_VERSION
    }
}
