/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends DirectoryServiceDataRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateUserRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(CreateUserRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(CreateUserRequest::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GivenName").getter(getter(CreateUserRequest::givenName)).setter(setter(Builder::givenName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()).build();

    private static final SdkField<Map<String, AttributeValue>> OTHER_ATTRIBUTES_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("OtherAttributes")
            .getter(getter(CreateUserRequest::otherAttributes))
            .setter(setter(Builder::otherAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMAccountName").getter(getter(CreateUserRequest::samAccountName))
            .setter(setter(Builder::samAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()).build();

    private static final SdkField<String> SURNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Surname")
            .getter(getter(CreateUserRequest::surname)).setter(setter(Builder::surname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DIRECTORY_ID_FIELD, EMAIL_ADDRESS_FIELD, GIVEN_NAME_FIELD, OTHER_ATTRIBUTES_FIELD, SAM_ACCOUNT_NAME_FIELD,
            SURNAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String directoryId;

    private final String emailAddress;

    private final String givenName;

    private final Map<String, AttributeValue> otherAttributes;

    private final String samAccountName;

    private final String surname;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.directoryId = builder.directoryId;
        this.emailAddress = builder.emailAddress;
        this.givenName = builder.givenName;
        this.otherAttributes = builder.otherAttributes;
        this.samAccountName = builder.samAccountName;
        this.surname = builder.surname;
    }

    /**
     * <p>
     * A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so multiple
     * identical calls have the same effect as one single call.
     * </p>
     * <p>
     * A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any request
     * with the same client token is treated as a new request. If the request succeeds, any future uses of that token
     * will be idempotent for another 8 hours.
     * </p>
     * <p>
     * If you submit a request with the same client token but change one of the other parameters within the 8-hour
     * idempotency window, Directory Service Data returns an <code>ConflictException</code>.
     * </p>
     * <note>
     * <p>
     * This parameter is optional when using the CLI or SDK.
     * </p>
     * </note>
     * 
     * @return A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so
     *         multiple identical calls have the same effect as one single call. </p>
     *         <p>
     *         A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
     *         request with the same client token is treated as a new request. If the request succeeds, any future uses
     *         of that token will be idempotent for another 8 hours.
     *         </p>
     *         <p>
     *         If you submit a request with the same client token but change one of the other parameters within the
     *         8-hour idempotency window, Directory Service Data returns an <code>ConflictException</code>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is optional when using the CLI or SDK.
     *         </p>
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier (ID) of the directory that’s associated with the user.
     * </p>
     * 
     * @return The identifier (ID) of the directory that’s associated with the user.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The email address of the user.
     * </p>
     * 
     * @return The email address of the user.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The first name of the user.
     * </p>
     * 
     * @return The first name of the user.
     */
    public final String givenName() {
        return givenName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OtherAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOtherAttributes() {
        return otherAttributes != null && !(otherAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An expression that defines one or more attribute names with the data type and value of each attribute. A key is
     * an attribute name, and the value is a list of maps. For a list of supported attributes, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory Service
     * Data Attributes</a>.
     * </p>
     * <note>
     * <p>
     * Attribute names are case insensitive.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOtherAttributes} method.
     * </p>
     * 
     * @return An expression that defines one or more attribute names with the data type and value of each attribute. A
     *         key is an attribute name, and the value is a list of maps. For a list of supported attributes, see <a
     *         href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory
     *         Service Data Attributes</a>. </p> <note>
     *         <p>
     *         Attribute names are case insensitive.
     *         </p>
     */
    public final Map<String, AttributeValue> otherAttributes() {
        return otherAttributes;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public final String samAccountName() {
        return samAccountName;
    }

    /**
     * <p>
     * The last name of the user.
     * </p>
     * 
     * @return The last name of the user.
     */
    public final String surname() {
        return surname;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(givenName());
        hashCode = 31 * hashCode + Objects.hashCode(hasOtherAttributes() ? otherAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(surname());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(givenName(), other.givenName())
                && hasOtherAttributes() == other.hasOtherAttributes()
                && Objects.equals(otherAttributes(), other.otherAttributes())
                && Objects.equals(samAccountName(), other.samAccountName()) && Objects.equals(surname(), other.surname());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserRequest").add("ClientToken", clientToken()).add("DirectoryId", directoryId())
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GivenName", givenName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OtherAttributes", hasOtherAttributes() ? otherAttributes() : null).add("SAMAccountName", samAccountName())
                .add("Surname", surname() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "GivenName":
            return Optional.ofNullable(clazz.cast(givenName()));
        case "OtherAttributes":
            return Optional.ofNullable(clazz.cast(otherAttributes()));
        case "SAMAccountName":
            return Optional.ofNullable(clazz.cast(samAccountName()));
        case "Surname":
            return Optional.ofNullable(clazz.cast(surname()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("EmailAddress", EMAIL_ADDRESS_FIELD);
        map.put("GivenName", GIVEN_NAME_FIELD);
        map.put("OtherAttributes", OTHER_ATTRIBUTES_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        map.put("Surname", SURNAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryServiceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so
         * multiple identical calls have the same effect as one single call.
         * </p>
         * <p>
         * A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
         * request with the same client token is treated as a new request. If the request succeeds, any future uses of
         * that token will be idempotent for another 8 hours.
         * </p>
         * <p>
         * If you submit a request with the same client token but change one of the other parameters within the 8-hour
         * idempotency window, Directory Service Data returns an <code>ConflictException</code>.
         * </p>
         * <note>
         * <p>
         * This parameter is optional when using the CLI or SDK.
         * </p>
         * </note>
         * 
         * @param clientToken
         *        A unique and case-sensitive identifier that you provide to make sure the idempotency of the request,
         *        so multiple identical calls have the same effect as one single call. </p>
         *        <p>
         *        A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
         *        request with the same client token is treated as a new request. If the request succeeds, any future
         *        uses of that token will be idempotent for another 8 hours.
         *        </p>
         *        <p>
         *        If you submit a request with the same client token but change one of the other parameters within the
         *        8-hour idempotency window, Directory Service Data returns an <code>ConflictException</code>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is optional when using the CLI or SDK.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier (ID) of the directory that’s associated with the user.
         * </p>
         * 
         * @param directoryId
         *        The identifier (ID) of the directory that’s associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The email address of the user.
         * </p>
         * 
         * @param emailAddress
         *        The email address of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The first name of the user.
         * </p>
         * 
         * @param givenName
         *        The first name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder givenName(String givenName);

        /**
         * <p>
         * An expression that defines one or more attribute names with the data type and value of each attribute. A key
         * is an attribute name, and the value is a list of maps. For a list of supported attributes, see <a
         * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory
         * Service Data Attributes</a>.
         * </p>
         * <note>
         * <p>
         * Attribute names are case insensitive.
         * </p>
         * </note>
         * 
         * @param otherAttributes
         *        An expression that defines one or more attribute names with the data type and value of each attribute.
         *        A key is an attribute name, and the value is a list of maps. For a list of supported attributes, see
         *        <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">
         *        Directory Service Data Attributes</a>. </p> <note>
         *        <p>
         *        Attribute names are case insensitive.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherAttributes(Map<String, AttributeValue> otherAttributes);

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param samAccountName
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samAccountName(String samAccountName);

        /**
         * <p>
         * The last name of the user.
         * </p>
         * 
         * @param surname
         *        The last name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder surname(String surname);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryServiceDataRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String directoryId;

        private String emailAddress;

        private String givenName;

        private Map<String, AttributeValue> otherAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String samAccountName;

        private String surname;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            clientToken(model.clientToken);
            directoryId(model.directoryId);
            emailAddress(model.emailAddress);
            givenName(model.givenName);
            otherAttributes(model.otherAttributes);
            samAccountName(model.samAccountName);
            surname(model.surname);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getGivenName() {
            return givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getOtherAttributes() {
            Map<String, AttributeValue.Builder> result = AttributesCopier.copyToBuilder(this.otherAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOtherAttributes(Map<String, AttributeValue.BuilderImpl> otherAttributes) {
            this.otherAttributes = AttributesCopier.copyFromBuilder(otherAttributes);
        }

        @Override
        public final Builder otherAttributes(Map<String, AttributeValue> otherAttributes) {
            this.otherAttributes = AttributesCopier.copy(otherAttributes);
            return this;
        }

        public final String getSamAccountName() {
            return samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSurname() {
            return surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
