/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserSummary> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(UserSummary.getter(UserSummary::enabled)).setter(UserSummary.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GivenName").getter(UserSummary.getter(UserSummary::givenName)).setter(UserSummary.setter(Builder::givenName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()}).build();
    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMAccountName").getter(UserSummary.getter(UserSummary::samAccountName)).setter(UserSummary.setter(Builder::samAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()}).build();
    private static final SdkField<String> SID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SID").getter(UserSummary.getter(UserSummary::sid)).setter(UserSummary.setter(Builder::sid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()}).build();
    private static final SdkField<String> SURNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Surname").getter(UserSummary.getter(UserSummary::surname)).setter(UserSummary.setter(Builder::surname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, GIVEN_NAME_FIELD, SAM_ACCOUNT_NAME_FIELD, SID_FIELD, SURNAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String givenName;
    private final String samAccountName;
    private final String sid;
    private final String surname;

    private UserSummary(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.givenName = builder.givenName;
        this.samAccountName = builder.samAccountName;
        this.sid = builder.sid;
        this.surname = builder.surname;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String givenName() {
        return this.givenName;
    }

    public final String samAccountName() {
        return this.samAccountName;
    }

    public final String sid() {
        return this.sid;
    }

    public final String surname() {
        return this.surname;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sid());
        hashCode = 31 * hashCode + Objects.hashCode(this.surname());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSummary)) {
            return false;
        }
        UserSummary other = (UserSummary)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.givenName(), other.givenName()) && Objects.equals(this.samAccountName(), other.samAccountName()) && Objects.equals(this.sid(), other.sid()) && Objects.equals(this.surname(), other.surname());
    }

    public final String toString() {
        return ToString.builder((String)"UserSummary").add("Enabled", (Object)this.enabled()).add("GivenName", (Object)(this.givenName() == null ? null : "*** Sensitive Data Redacted ***")).add("SAMAccountName", (Object)this.samAccountName()).add("SID", (Object)this.sid()).add("Surname", (Object)(this.surname() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "GivenName": {
                return Optional.ofNullable(clazz.cast(this.givenName()));
            }
            case "SAMAccountName": {
                return Optional.ofNullable(clazz.cast(this.samAccountName()));
            }
            case "SID": {
                return Optional.ofNullable(clazz.cast(this.sid()));
            }
            case "Surname": {
                return Optional.ofNullable(clazz.cast(this.surname()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("GivenName", GIVEN_NAME_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        map.put("SID", SID_FIELD);
        map.put("Surname", SURNAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserSummary, T> g) {
        return obj -> g.apply((UserSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String givenName;
        private String samAccountName;
        private String sid;
        private String surname;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSummary model) {
            this.enabled(model.enabled);
            this.givenName(model.givenName);
            this.samAccountName(model.samAccountName);
            this.sid(model.sid);
            this.surname(model.surname);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final String getSamAccountName() {
            return this.samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSid() {
            return this.sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public final String getSurname() {
            return this.surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public UserSummary build() {
            return new UserSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserSummary> {
        public Builder enabled(Boolean var1);

        public Builder givenName(String var1);

        public Builder samAccountName(String var1);

        public Builder sid(String var1);

        public Builder surname(String var1);
    }
}

