/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserResponse extends DirectoryServiceDataResponse implements
        ToCopyableBuilder<CreateUserResponse.Builder, CreateUserResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(CreateUserResponse::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMAccountName").getter(getter(CreateUserResponse::samAccountName))
            .setter(setter(Builder::samAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()).build();

    private static final SdkField<String> SID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SID")
            .getter(getter(CreateUserResponse::sid)).setter(setter(Builder::sid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            SAM_ACCOUNT_NAME_FIELD, SID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final String samAccountName;

    private final String sid;

    private CreateUserResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.samAccountName = builder.samAccountName;
        this.sid = builder.sid;
    }

    /**
     * <p>
     * The identifier (ID) of the directory where the address block is added.
     * </p>
     * 
     * @return The identifier (ID) of the directory where the address block is added.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public final String samAccountName() {
        return samAccountName;
    }

    /**
     * <p>
     * The unique security identifier (SID) of the user.
     * </p>
     * 
     * @return The unique security identifier (SID) of the user.
     */
    public final String sid() {
        return sid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(sid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserResponse)) {
            return false;
        }
        CreateUserResponse other = (CreateUserResponse) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(samAccountName(), other.samAccountName())
                && Objects.equals(sid(), other.sid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserResponse").add("DirectoryId", directoryId()).add("SAMAccountName", samAccountName())
                .add("SID", sid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "SAMAccountName":
            return Optional.ofNullable(clazz.cast(samAccountName()));
        case "SID":
            return Optional.ofNullable(clazz.cast(sid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        map.put("SID", SID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUserResponse, T> g) {
        return obj -> g.apply((CreateUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryServiceDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserResponse> {
        /**
         * <p>
         * The identifier (ID) of the directory where the address block is added.
         * </p>
         * 
         * @param directoryId
         *        The identifier (ID) of the directory where the address block is added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param samAccountName
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samAccountName(String samAccountName);

        /**
         * <p>
         * The unique security identifier (SID) of the user.
         * </p>
         * 
         * @param sid
         *        The unique security identifier (SID) of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sid(String sid);
    }

    static final class BuilderImpl extends DirectoryServiceDataResponse.BuilderImpl implements Builder {
        private String directoryId;

        private String samAccountName;

        private String sid;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserResponse model) {
            super(model);
            directoryId(model.directoryId);
            samAccountName(model.samAccountName);
            sid(model.sid);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getSamAccountName() {
            return samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSid() {
            return sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        @Override
        public CreateUserResponse build() {
            return new CreateUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
