/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGroupRequest extends DirectoryServiceDataRequest implements
        ToCopyableBuilder<DescribeGroupRequest.Builder, DescribeGroupRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DescribeGroupRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()).build();

    private static final SdkField<List<String>> OTHER_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OtherAttributes")
            .getter(getter(DescribeGroupRequest::otherAttributes))
            .setter(setter(Builder::otherAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Realm")
            .getter(getter(DescribeGroupRequest::realm)).setter(setter(Builder::realm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()).build();

    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMAccountName").getter(getter(DescribeGroupRequest::samAccountName))
            .setter(setter(Builder::samAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            OTHER_ATTRIBUTES_FIELD, REALM_FIELD, SAM_ACCOUNT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final List<String> otherAttributes;

    private final String realm;

    private final String samAccountName;

    private DescribeGroupRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.otherAttributes = builder.otherAttributes;
        this.realm = builder.realm;
        this.samAccountName = builder.samAccountName;
    }

    /**
     * <p>
     * The Identifier (ID) of the directory associated with the group.
     * </p>
     * 
     * @return The Identifier (ID) of the directory associated with the group.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the OtherAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOtherAttributes() {
        return otherAttributes != null && !(otherAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more attributes to be returned for the group. For a list of supported attributes, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory Service
     * Data Attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOtherAttributes} method.
     * </p>
     * 
     * @return One or more attributes to be returned for the group. For a list of supported attributes, see <a
     *         href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory
     *         Service Data Attributes</a>.
     */
    public final List<String> otherAttributes() {
        return otherAttributes;
    }

    /**
     * <p>
     * The domain name that's associated with the group.
     * </p>
     * <note>
     * <p>
     * This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When no value
     * is defined, only your Managed Microsoft AD groups are returned.
     * </p>
     * <p>
     * This value is case insensitive.
     * </p>
     * </note>
     * 
     * @return The domain name that's associated with the group. </p> <note>
     *         <p>
     *         This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When no
     *         value is defined, only your Managed Microsoft AD groups are returned.
     *         </p>
     *         <p>
     *         This value is case insensitive.
     *         </p>
     */
    public final String realm() {
        return realm;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public final String samAccountName() {
        return samAccountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasOtherAttributes() ? otherAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(realm());
        hashCode = 31 * hashCode + Objects.hashCode(samAccountName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupRequest)) {
            return false;
        }
        DescribeGroupRequest other = (DescribeGroupRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && hasOtherAttributes() == other.hasOtherAttributes()
                && Objects.equals(otherAttributes(), other.otherAttributes()) && Objects.equals(realm(), other.realm())
                && Objects.equals(samAccountName(), other.samAccountName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGroupRequest").add("DirectoryId", directoryId())
                .add("OtherAttributes", hasOtherAttributes() ? otherAttributes() : null).add("Realm", realm())
                .add("SAMAccountName", samAccountName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "OtherAttributes":
            return Optional.ofNullable(clazz.cast(otherAttributes()));
        case "Realm":
            return Optional.ofNullable(clazz.cast(realm()));
        case "SAMAccountName":
            return Optional.ofNullable(clazz.cast(samAccountName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("OtherAttributes", OTHER_ATTRIBUTES_FIELD);
        map.put("Realm", REALM_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupRequest, T> g) {
        return obj -> g.apply((DescribeGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryServiceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeGroupRequest> {
        /**
         * <p>
         * The Identifier (ID) of the directory associated with the group.
         * </p>
         * 
         * @param directoryId
         *        The Identifier (ID) of the directory associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * One or more attributes to be returned for the group. For a list of supported attributes, see <a
         * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory
         * Service Data Attributes</a>.
         * </p>
         * 
         * @param otherAttributes
         *        One or more attributes to be returned for the group. For a list of supported attributes, see <a
         *        href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html"
         *        >Directory Service Data Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherAttributes(Collection<String> otherAttributes);

        /**
         * <p>
         * One or more attributes to be returned for the group. For a list of supported attributes, see <a
         * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory
         * Service Data Attributes</a>.
         * </p>
         * 
         * @param otherAttributes
         *        One or more attributes to be returned for the group. For a list of supported attributes, see <a
         *        href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html"
         *        >Directory Service Data Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherAttributes(String... otherAttributes);

        /**
         * <p>
         * The domain name that's associated with the group.
         * </p>
         * <note>
         * <p>
         * This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When no
         * value is defined, only your Managed Microsoft AD groups are returned.
         * </p>
         * <p>
         * This value is case insensitive.
         * </p>
         * </note>
         * 
         * @param realm
         *        The domain name that's associated with the group. </p> <note>
         *        <p>
         *        This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When
         *        no value is defined, only your Managed Microsoft AD groups are returned.
         *        </p>
         *        <p>
         *        This value is case insensitive.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realm(String realm);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param samAccountName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samAccountName(String samAccountName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryServiceDataRequest.BuilderImpl implements Builder {
        private String directoryId;

        private List<String> otherAttributes = DefaultSdkAutoConstructList.getInstance();

        private String realm;

        private String samAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupRequest model) {
            super(model);
            directoryId(model.directoryId);
            otherAttributes(model.otherAttributes);
            realm(model.realm);
            samAccountName(model.samAccountName);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getOtherAttributes() {
            if (otherAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return otherAttributes;
        }

        public final void setOtherAttributes(Collection<String> otherAttributes) {
            this.otherAttributes = LdapDisplayNameListCopier.copy(otherAttributes);
        }

        @Override
        public final Builder otherAttributes(Collection<String> otherAttributes) {
            this.otherAttributes = LdapDisplayNameListCopier.copy(otherAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otherAttributes(String... otherAttributes) {
            otherAttributes(Arrays.asList(otherAttributes));
            return this;
        }

        public final String getRealm() {
            return realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final String getSamAccountName() {
            return samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGroupRequest build() {
            return new DescribeGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
