/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.directoryservicedata.model.AddGroupMemberRequest;
import software.amazon.awssdk.services.directoryservicedata.model.AddGroupMemberResponse;
import software.amazon.awssdk.services.directoryservicedata.model.CreateGroupRequest;
import software.amazon.awssdk.services.directoryservicedata.model.CreateGroupResponse;
import software.amazon.awssdk.services.directoryservicedata.model.CreateUserRequest;
import software.amazon.awssdk.services.directoryservicedata.model.CreateUserResponse;
import software.amazon.awssdk.services.directoryservicedata.model.DeleteGroupRequest;
import software.amazon.awssdk.services.directoryservicedata.model.DeleteGroupResponse;
import software.amazon.awssdk.services.directoryservicedata.model.DeleteUserRequest;
import software.amazon.awssdk.services.directoryservicedata.model.DeleteUserResponse;
import software.amazon.awssdk.services.directoryservicedata.model.DescribeGroupRequest;
import software.amazon.awssdk.services.directoryservicedata.model.DescribeGroupResponse;
import software.amazon.awssdk.services.directoryservicedata.model.DescribeUserRequest;
import software.amazon.awssdk.services.directoryservicedata.model.DescribeUserResponse;
import software.amazon.awssdk.services.directoryservicedata.model.DisableUserRequest;
import software.amazon.awssdk.services.directoryservicedata.model.DisableUserResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsResponse;
import software.amazon.awssdk.services.directoryservicedata.model.ListUsersRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListUsersResponse;
import software.amazon.awssdk.services.directoryservicedata.model.RemoveGroupMemberRequest;
import software.amazon.awssdk.services.directoryservicedata.model.RemoveGroupMemberResponse;
import software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsRequest;
import software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsResponse;
import software.amazon.awssdk.services.directoryservicedata.model.SearchUsersRequest;
import software.amazon.awssdk.services.directoryservicedata.model.SearchUsersResponse;
import software.amazon.awssdk.services.directoryservicedata.model.UpdateGroupRequest;
import software.amazon.awssdk.services.directoryservicedata.model.UpdateGroupResponse;
import software.amazon.awssdk.services.directoryservicedata.model.UpdateUserRequest;
import software.amazon.awssdk.services.directoryservicedata.model.UpdateUserResponse;
import software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupMembersPublisher;
import software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupsForMemberPublisher;
import software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupsPublisher;
import software.amazon.awssdk.services.directoryservicedata.paginators.ListUsersPublisher;
import software.amazon.awssdk.services.directoryservicedata.paginators.SearchGroupsPublisher;
import software.amazon.awssdk.services.directoryservicedata.paginators.SearchUsersPublisher;

/**
 * Service client for accessing AWS Directory Service Data asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Web Services Directory Service Data is an extension of Directory Service. This API reference provides detailed
 * information about Directory Service Data operations and object types.
 * </p>
 * <p>
 * With Directory Service Data, you can create, read, update, and delete users, groups, and memberships from your
 * Managed Microsoft AD without additional costs and without deploying dedicated management instances. You can also
 * perform built-in object management tasks across directories without direct network connectivity, which simplifies
 * provisioning and access management to achieve fully automated deployments. Directory Service Data supports user and
 * group write operations, such as <code>CreateUser</code> and <code>CreateGroup</code>, within the organizational unit
 * (OU) of your Managed Microsoft AD. Directory Service Data supports read operations, such as <code>ListUsers</code>
 * and <code>ListGroups</code>, on all users, groups, and group memberships within your Managed Microsoft AD and across
 * trusted realms. Directory Service Data supports adding and removing group members in your OU and the Amazon Web
 * Services Delegated Groups OU, so you can grant and deny access to specific roles and permissions. For more
 * information, see <a
 * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ms_ad_manage_users_groups.html">Manage users
 * and groups</a> in the <i>Directory Service Administration Guide</i>.
 * </p>
 * <note>
 * <p>
 * Directory management operations and configuration changes made against the Directory Service API will also reflect in
 * Directory Service Data API with eventual consistency. You can expect a short delay between management changes, such
 * as adding a new directory trust and calling the Directory Service Data API for the newly created trusted realm.
 * </p>
 * </note>
 * <p>
 * Directory Service Data connects to your Managed Microsoft AD domain controllers and performs operations on underlying
 * directory objects. When you create your Managed Microsoft AD, you choose subnets for domain controllers that
 * Directory Service creates on your behalf. If a domain controller is unavailable, Directory Service Data uses an
 * available domain controller. As a result, you might notice eventual consistency while objects replicate from one
 * domain controller to another domain controller. For more information, see <a
 * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ms_ad_getting_started_what_gets_created.html"
 * >What gets created</a> in the <i>Directory Service Administration Guide</i>. Directory limits vary by Managed
 * Microsoft AD edition:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Standard edition</b> – Supports 8 transactions per second (TPS) for read operations and 4 TPS for write operations
 * per directory. There's a concurrency limit of 10 concurrent requests.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Enterprise edition</b> – Supports 16 transactions per second (TPS) for read operations and 8 TPS for write
 * operations per directory. There's a concurrency limit of 10 concurrent requests.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Amazon Web Services Account</b> - Supports a total of 100 TPS for Directory Service Data operations across all
 * directories.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Directory Service Data only supports the Managed Microsoft AD directory type and is only available in the primary
 * Amazon Web Services Region. For more information, see <a
 * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Managed Microsoft
 * AD</a> and <a
 * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/multi-region-global-primary-additional.html"
 * >Primary vs additional Regions</a> in the <i>Directory Service Administration Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DirectoryServiceDataAsyncClient extends AwsClient {
    String SERVICE_NAME = "ds-data";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ds-data";

    /**
     * <p>
     * Adds an existing user, group, or computer as a group member.
     * </p>
     *
     * @param addGroupMemberRequest
     * @return A Java Future containing the result of the AddGroupMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.AddGroupMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/AddGroupMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddGroupMemberResponse> addGroupMember(AddGroupMemberRequest addGroupMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an existing user, group, or computer as a group member.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddGroupMemberRequest.Builder} avoiding the need to
     * create one manually via {@link AddGroupMemberRequest#builder()}
     * </p>
     *
     * @param addGroupMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.AddGroupMemberRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AddGroupMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.AddGroupMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/AddGroupMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddGroupMemberResponse> addGroupMember(Consumer<AddGroupMemberRequest.Builder> addGroupMemberRequest) {
        return addGroupMember(AddGroupMemberRequest.builder().applyMutation(addGroupMemberRequest).build());
    }

    /**
     * <p>
     * Creates a new group.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/CreateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.CreateGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/CreateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new user.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/CreateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.CreateUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/CreateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deletes a group.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DeleteGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.DeleteGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DeleteGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a user.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DeleteUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.DeleteUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DeleteUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific group.
     * </p>
     *
     * @param describeGroupRequest
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DescribeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGroupResponse> describeGroup(DescribeGroupRequest describeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupRequest#builder()}
     * </p>
     *
     * @param describeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.DescribeGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DescribeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGroupResponse> describeGroup(Consumer<DescribeGroupRequest.Builder> describeGroupRequest) {
        return describeGroup(DescribeGroupRequest.builder().applyMutation(describeGroupRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific user.
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DescribeUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.DescribeUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DescribeUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest) {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Deactivates an active user account. For information about how to enable an inactive user account, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ResetUserPassword.html"
     * >ResetUserPassword</a> in the <i>Directory Service API Reference</i>.
     * </p>
     *
     * @param disableUserRequest
     * @return A Java Future containing the result of the DisableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.DisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DisableUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableUserResponse> disableUser(DisableUserRequest disableUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates an active user account. For information about how to enable an inactive user account, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/devguide/API_ResetUserPassword.html"
     * >ResetUserPassword</a> in the <i>Directory Service API Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableUserRequest.Builder} avoiding the need to
     * create one manually via {@link DisableUserRequest#builder()}
     * </p>
     *
     * @param disableUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.DisableUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.DisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/DisableUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableUserResponse> disableUser(Consumer<DisableUserRequest.Builder> disableUserRequest) {
        return disableUser(DisableUserRequest.builder().applyMutation(disableUserRequest).build());
    }

    /**
     * <p>
     * Returns member information for the specified group.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListGroupMembers.NextToken</code> member contains a token that you pass in
     * the next call to <code>ListGroupMembers</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A Java Future containing the result of the ListGroupMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroupMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupMembersResponse> listGroupMembers(ListGroupMembersRequest listGroupMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns member information for the specified group.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListGroupMembers.NextToken</code> member contains a token that you pass in
     * the next call to <code>ListGroupMembers</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupMembersRequest#builder()}
     * </p>
     *
     * @param listGroupMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListGroupMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroupMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupMembersResponse> listGroupMembers(
            Consumer<ListGroupMembersRequest.Builder> listGroupMembersRequest) {
        return listGroupMembers(ListGroupMembersRequest.builder().applyMutation(listGroupMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupMembers(software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembers(software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroupMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupMembersPublisher listGroupMembersPaginator(ListGroupMembersRequest listGroupMembersRequest) {
        return new ListGroupMembersPublisher(this, listGroupMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupMembers(software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembers(software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupMembersRequest#builder()}
     * </p>
     *
     * @param listGroupMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroupMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupMembersPublisher listGroupMembersPaginator(Consumer<ListGroupMembersRequest.Builder> listGroupMembersRequest) {
        return listGroupMembersPaginator(ListGroupMembersRequest.builder().applyMutation(listGroupMembersRequest).build());
    }

    /**
     * <p>
     * Returns group information for the specified directory.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListGroups.NextToken</code> member contains a token that you pass in the
     * next call to <code>ListGroups</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns group information for the specified directory.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListGroups.NextToken</code> member contains a token that you pass in the
     * next call to <code>ListGroups</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.ListGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Returns group information for the specified member.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListGroupsForMember.NextToken</code> member contains a token that you pass
     * in the next call to <code>ListGroupsForMember</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param listGroupsForMemberRequest
     * @return A Java Future containing the result of the ListGroupsForMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroupsForMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroupsForMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupsForMemberResponse> listGroupsForMember(
            ListGroupsForMemberRequest listGroupsForMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns group information for the specified member.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListGroupsForMember.NextToken</code> member contains a token that you pass
     * in the next call to <code>ListGroupsForMember</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsForMemberRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupsForMemberRequest#builder()}
     * </p>
     *
     * @param listGroupsForMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListGroupsForMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroupsForMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroupsForMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupsForMemberResponse> listGroupsForMember(
            Consumer<ListGroupsForMemberRequest.Builder> listGroupsForMemberRequest) {
        return listGroupsForMember(ListGroupsForMemberRequest.builder().applyMutation(listGroupsForMemberRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupsForMember(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupsForMemberPublisher publisher = client.listGroupsForMemberPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupsForMemberPublisher publisher = client.listGroupsForMemberPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsForMember(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroupsForMemberRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroupsForMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroupsForMember"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupsForMemberPublisher listGroupsForMemberPaginator(ListGroupsForMemberRequest listGroupsForMemberRequest) {
        return new ListGroupsForMemberPublisher(this, listGroupsForMemberRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupsForMember(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupsForMemberPublisher publisher = client.listGroupsForMemberPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupsForMemberPublisher publisher = client.listGroupsForMemberPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsForMember(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsForMemberRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupsForMemberRequest#builder()}
     * </p>
     *
     * @param listGroupsForMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroupsForMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroupsForMember"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupsForMemberPublisher listGroupsForMemberPaginator(
            Consumer<ListGroupsForMemberRequest.Builder> listGroupsForMemberRequest) {
        return listGroupsForMemberPaginator(ListGroupsForMemberRequest.builder().applyMutation(listGroupsForMemberRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroups(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(ListGroupsRequest listGroupsRequest) {
        return new ListGroupsPublisher(this, listGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroups(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.directoryservicedata.model.ListGroupsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.ListGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Returns user information for the specified directory.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListUsers.NextToken</code> member contains a token that you pass in the
     * next call to <code>ListUsers</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns user information for the specified directory.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>ListUsers.NextToken</code> member contains a token that you pass in the
     * next call to <code>ListUsers</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.ListUsersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsers(software.amazon.awssdk.services.directoryservicedata.model.ListUsersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.directoryservicedata.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(ListUsersRequest listUsersRequest) {
        return new ListUsersPublisher(this, listUsersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsers(software.amazon.awssdk.services.directoryservicedata.model.ListUsersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.directoryservicedata.model.ListUsersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.ListUsersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/ListUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     *
     * @param removeGroupMemberRequest
     * @return A Java Future containing the result of the RemoveGroupMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.RemoveGroupMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/RemoveGroupMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveGroupMemberResponse> removeGroupMember(RemoveGroupMemberRequest removeGroupMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveGroupMemberRequest.Builder} avoiding the need
     * to create one manually via {@link RemoveGroupMemberRequest#builder()}
     * </p>
     *
     * @param removeGroupMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.RemoveGroupMemberRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RemoveGroupMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.RemoveGroupMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/RemoveGroupMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveGroupMemberResponse> removeGroupMember(
            Consumer<RemoveGroupMemberRequest.Builder> removeGroupMemberRequest) {
        return removeGroupMember(RemoveGroupMemberRequest.builder().applyMutation(removeGroupMemberRequest).build());
    }

    /**
     * <p>
     * Searches the specified directory for a group. You can find groups that match the <code>SearchString</code>
     * parameter with the value of their attributes included in the <code>SearchString</code> parameter.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>SearchGroups.NextToken</code> member contains a token that you pass in the
     * next call to <code>SearchGroups</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param searchGroupsRequest
     * @return A Java Future containing the result of the SearchGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.SearchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/SearchGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchGroupsResponse> searchGroups(SearchGroupsRequest searchGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches the specified directory for a group. You can find groups that match the <code>SearchString</code>
     * parameter with the value of their attributes included in the <code>SearchString</code> parameter.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>SearchGroups.NextToken</code> member contains a token that you pass in the
     * next call to <code>SearchGroups</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchGroupsRequest#builder()}
     * </p>
     *
     * @param searchGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.SearchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/SearchGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchGroupsResponse> searchGroups(Consumer<SearchGroupsRequest.Builder> searchGroupsRequest) {
        return searchGroups(SearchGroupsRequest.builder().applyMutation(searchGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchGroups(software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.SearchGroupsPublisher publisher = client.searchGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.SearchGroupsPublisher publisher = client.searchGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchGroups(software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.SearchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/SearchGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchGroupsPublisher searchGroupsPaginator(SearchGroupsRequest searchGroupsRequest) {
        return new SearchGroupsPublisher(this, searchGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchGroups(software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.SearchGroupsPublisher publisher = client.searchGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.SearchGroupsPublisher publisher = client.searchGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchGroups(software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchGroupsRequest#builder()}
     * </p>
     *
     * @param searchGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.SearchGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.SearchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/SearchGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchGroupsPublisher searchGroupsPaginator(Consumer<SearchGroupsRequest.Builder> searchGroupsRequest) {
        return searchGroupsPaginator(SearchGroupsRequest.builder().applyMutation(searchGroupsRequest).build());
    }

    /**
     * <p>
     * Searches the specified directory for a user. You can find users that match the <code>SearchString</code>
     * parameter with the value of their attributes included in the <code>SearchString</code> parameter.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>SearchUsers.NextToken</code> member contains a token that you pass in the
     * next call to <code>SearchUsers</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     *
     * @param searchUsersRequest
     * @return A Java Future containing the result of the SearchUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/SearchUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchUsersResponse> searchUsers(SearchUsersRequest searchUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches the specified directory for a user. You can find users that match the <code>SearchString</code>
     * parameter with the value of their attributes included in the <code>SearchString</code> parameter.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>SearchUsers.NextToken</code> member contains a token that you pass in the
     * next call to <code>SearchUsers</code>. This retrieves the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>MaxResults</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUsersRequest.Builder} avoiding the need to
     * create one manually via {@link SearchUsersRequest#builder()}
     * </p>
     *
     * @param searchUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.SearchUsersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/SearchUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchUsersResponse> searchUsers(Consumer<SearchUsersRequest.Builder> searchUsersRequest) {
        return searchUsers(SearchUsersRequest.builder().applyMutation(searchUsersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchUsers(software.amazon.awssdk.services.directoryservicedata.model.SearchUsersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.SearchUsersPublisher publisher = client.searchUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.SearchUsersPublisher publisher = client.searchUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.SearchUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.SearchUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.directoryservicedata.model.SearchUsersRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/SearchUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchUsersPublisher searchUsersPaginator(SearchUsersRequest searchUsersRequest) {
        return new SearchUsersPublisher(this, searchUsersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchUsers(software.amazon.awssdk.services.directoryservicedata.model.SearchUsersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.SearchUsersPublisher publisher = client.searchUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directoryservicedata.paginators.SearchUsersPublisher publisher = client.searchUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directoryservicedata.model.SearchUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directoryservicedata.model.SearchUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.directoryservicedata.model.SearchUsersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUsersRequest.Builder} avoiding the need to
     * create one manually via {@link SearchUsersRequest#builder()}
     * </p>
     *
     * @param searchUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.SearchUsersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/SearchUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchUsersPublisher searchUsersPaginator(Consumer<SearchUsersRequest.Builder> searchUsersRequest) {
        return searchUsersPaginator(SearchUsersRequest.builder().applyMutation(searchUsersRequest).build());
    }

    /**
     * <p>
     * Updates group information.
     * </p>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/UpdateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates group information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.UpdateGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/UpdateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest) {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Updates user information.
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/UpdateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates user information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directoryservicedata.model.UpdateUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the request or access the directory. It
     *         can also occur when the <code>DirectoryId</code> doesn't exist or the user, member, or group might be
     *         outside of your organizational unit (OU). </p>
     *         <p>
     *         Make sure that you have the authentication and authorization to perform the action. Review the directory
     *         information in the request, and make sure that the object isn't outside of your OU.</li>
     *         <li>InternalServerException The operation didn't succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ValidationException The request isn't valid. Review the details in the error message to update the
     *         invalid parameters or values in your request.</li>
     *         <li>DirectoryUnavailableException The request could not be completed due to a problem in the
     *         configuration or current state of the specified directory.</li>
     *         <li>ConflictException This error will occur when you try to create a resource that conflicts with an
     *         existing object. It can also occur when adding a member to a group that the member is already in.</p>
     *         <p>
     *         This error can be caused by a request sent within the 8-hour idempotency window with the same client
     *         token but different input parameters. Client tokens should not be re-used across different requests.
     *         After 8 hours, any request with the same client token is treated as a new request.</li>
     *         <li>ThrottlingException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryServiceDataException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample DirectoryServiceDataAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directory-service-data-2023-05-31/UpdateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    @Override
    default DirectoryServiceDataServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DirectoryServiceDataAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DirectoryServiceDataAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DirectoryServiceDataAsyncClient}.
     */
    static DirectoryServiceDataAsyncClientBuilder builder() {
        return new DefaultDirectoryServiceDataAsyncClientBuilder();
    }
}
