/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGroupRequest extends DirectoryServiceDataRequest implements
        ToCopyableBuilder<CreateGroupRequest.Builder, CreateGroupRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateGroupRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(CreateGroupRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()).build();

    private static final SdkField<String> GROUP_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupScope").getter(getter(CreateGroupRequest::groupScopeAsString)).setter(setter(Builder::groupScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupScope").build()).build();

    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupType").getter(getter(CreateGroupRequest::groupTypeAsString)).setter(setter(Builder::groupType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupType").build()).build();

    private static final SdkField<Map<String, AttributeValue>> OTHER_ATTRIBUTES_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("OtherAttributes")
            .getter(getter(CreateGroupRequest::otherAttributes))
            .setter(setter(Builder::otherAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMAccountName").getter(getter(CreateGroupRequest::samAccountName))
            .setter(setter(Builder::samAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DIRECTORY_ID_FIELD, GROUP_SCOPE_FIELD, GROUP_TYPE_FIELD, OTHER_ATTRIBUTES_FIELD, SAM_ACCOUNT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String directoryId;

    private final String groupScope;

    private final String groupType;

    private final Map<String, AttributeValue> otherAttributes;

    private final String samAccountName;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.directoryId = builder.directoryId;
        this.groupScope = builder.groupScope;
        this.groupType = builder.groupType;
        this.otherAttributes = builder.otherAttributes;
        this.samAccountName = builder.samAccountName;
    }

    /**
     * <p>
     * A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so multiple
     * identical calls have the same effect as one single call.
     * </p>
     * <p>
     * A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any request
     * with the same client token is treated as a new request. If the request succeeds, any future uses of that token
     * will be idempotent for another 8 hours.
     * </p>
     * <p>
     * If you submit a request with the same client token but change one of the other parameters within the 8-hour
     * idempotency window, Directory Service Data returns an <code>ConflictException</code>.
     * </p>
     * <note>
     * <p>
     * This parameter is optional when using the CLI or SDK.
     * </p>
     * </note>
     * 
     * @return A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so
     *         multiple identical calls have the same effect as one single call. </p>
     *         <p>
     *         A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
     *         request with the same client token is treated as a new request. If the request succeeds, any future uses
     *         of that token will be idempotent for another 8 hours.
     *         </p>
     *         <p>
     *         If you submit a request with the same client token but change one of the other parameters within the
     *         8-hour idempotency window, Directory Service Data returns an <code>ConflictException</code>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is optional when using the CLI or SDK.
     *         </p>
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier (ID) of the directory that's associated with the group.
     * </p>
     * 
     * @return The identifier (ID) of the directory that's associated with the group.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The scope of the AD group. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     * >Active Directory security group scope</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupScope} will
     * return {@link GroupScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupScopeAsString}.
     * </p>
     * 
     * @return The scope of the AD group. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     *         >Active Directory security group scope</a>.
     * @see GroupScope
     */
    public final GroupScope groupScope() {
        return GroupScope.fromValue(groupScope);
    }

    /**
     * <p>
     * The scope of the AD group. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     * >Active Directory security group scope</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupScope} will
     * return {@link GroupScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupScopeAsString}.
     * </p>
     * 
     * @return The scope of the AD group. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     *         >Active Directory security group scope</a>.
     * @see GroupScope
     */
    public final String groupScopeAsString() {
        return groupScope;
    }

    /**
     * <p>
     * The AD group type. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     * >Active Directory security group type</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupType} will
     * return {@link GroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupTypeAsString}.
     * </p>
     * 
     * @return The AD group type. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     *         >Active Directory security group type</a>.
     * @see GroupType
     */
    public final GroupType groupType() {
        return GroupType.fromValue(groupType);
    }

    /**
     * <p>
     * The AD group type. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     * >Active Directory security group type</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupType} will
     * return {@link GroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupTypeAsString}.
     * </p>
     * 
     * @return The AD group type. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     *         >Active Directory security group type</a>.
     * @see GroupType
     */
    public final String groupTypeAsString() {
        return groupType;
    }

    /**
     * For responses, this returns true if the service returned a value for the OtherAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOtherAttributes() {
        return otherAttributes != null && !(otherAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An expression that defines one or more attributes with the data type and value of each attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOtherAttributes} method.
     * </p>
     * 
     * @return An expression that defines one or more attributes with the data type and value of each attribute.
     */
    public final Map<String, AttributeValue> otherAttributes() {
        return otherAttributes;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public final String samAccountName() {
        return samAccountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(groupScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOtherAttributes() ? otherAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(samAccountName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(groupScopeAsString(), other.groupScopeAsString())
                && Objects.equals(groupTypeAsString(), other.groupTypeAsString())
                && hasOtherAttributes() == other.hasOtherAttributes()
                && Objects.equals(otherAttributes(), other.otherAttributes())
                && Objects.equals(samAccountName(), other.samAccountName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGroupRequest").add("ClientToken", clientToken()).add("DirectoryId", directoryId())
                .add("GroupScope", groupScopeAsString()).add("GroupType", groupTypeAsString())
                .add("OtherAttributes", hasOtherAttributes() ? otherAttributes() : null).add("SAMAccountName", samAccountName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "GroupScope":
            return Optional.ofNullable(clazz.cast(groupScopeAsString()));
        case "GroupType":
            return Optional.ofNullable(clazz.cast(groupTypeAsString()));
        case "OtherAttributes":
            return Optional.ofNullable(clazz.cast(otherAttributes()));
        case "SAMAccountName":
            return Optional.ofNullable(clazz.cast(samAccountName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("GroupScope", GROUP_SCOPE_FIELD);
        map.put("GroupType", GROUP_TYPE_FIELD);
        map.put("OtherAttributes", OTHER_ATTRIBUTES_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupRequest, T> g) {
        return obj -> g.apply((CreateGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryServiceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGroupRequest> {
        /**
         * <p>
         * A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so
         * multiple identical calls have the same effect as one single call.
         * </p>
         * <p>
         * A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
         * request with the same client token is treated as a new request. If the request succeeds, any future uses of
         * that token will be idempotent for another 8 hours.
         * </p>
         * <p>
         * If you submit a request with the same client token but change one of the other parameters within the 8-hour
         * idempotency window, Directory Service Data returns an <code>ConflictException</code>.
         * </p>
         * <note>
         * <p>
         * This parameter is optional when using the CLI or SDK.
         * </p>
         * </note>
         * 
         * @param clientToken
         *        A unique and case-sensitive identifier that you provide to make sure the idempotency of the request,
         *        so multiple identical calls have the same effect as one single call. </p>
         *        <p>
         *        A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
         *        request with the same client token is treated as a new request. If the request succeeds, any future
         *        uses of that token will be idempotent for another 8 hours.
         *        </p>
         *        <p>
         *        If you submit a request with the same client token but change one of the other parameters within the
         *        8-hour idempotency window, Directory Service Data returns an <code>ConflictException</code>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is optional when using the CLI or SDK.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier (ID) of the directory that's associated with the group.
         * </p>
         * 
         * @param directoryId
         *        The identifier (ID) of the directory that's associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The scope of the AD group. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         * >Active Directory security group scope</a>.
         * </p>
         * 
         * @param groupScope
         *        The scope of the AD group. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         *        >Active Directory security group scope</a>.
         * @see GroupScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupScope
         */
        Builder groupScope(String groupScope);

        /**
         * <p>
         * The scope of the AD group. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         * >Active Directory security group scope</a>.
         * </p>
         * 
         * @param groupScope
         *        The scope of the AD group. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         *        >Active Directory security group scope</a>.
         * @see GroupScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupScope
         */
        Builder groupScope(GroupScope groupScope);

        /**
         * <p>
         * The AD group type. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         * >Active Directory security group type</a>.
         * </p>
         * 
         * @param groupType
         *        The AD group type. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         *        >Active Directory security group type</a>.
         * @see GroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupType
         */
        Builder groupType(String groupType);

        /**
         * <p>
         * The AD group type. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         * >Active Directory security group type</a>.
         * </p>
         * 
         * @param groupType
         *        The AD group type. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         *        >Active Directory security group type</a>.
         * @see GroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupType
         */
        Builder groupType(GroupType groupType);

        /**
         * <p>
         * An expression that defines one or more attributes with the data type and value of each attribute.
         * </p>
         * 
         * @param otherAttributes
         *        An expression that defines one or more attributes with the data type and value of each attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherAttributes(Map<String, AttributeValue> otherAttributes);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param samAccountName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samAccountName(String samAccountName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryServiceDataRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String directoryId;

        private String groupScope;

        private String groupType;

        private Map<String, AttributeValue> otherAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String samAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            super(model);
            clientToken(model.clientToken);
            directoryId(model.directoryId);
            groupScope(model.groupScope);
            groupType(model.groupType);
            otherAttributes(model.otherAttributes);
            samAccountName(model.samAccountName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getGroupScope() {
            return groupScope;
        }

        public final void setGroupScope(String groupScope) {
            this.groupScope = groupScope;
        }

        @Override
        public final Builder groupScope(String groupScope) {
            this.groupScope = groupScope;
            return this;
        }

        @Override
        public final Builder groupScope(GroupScope groupScope) {
            this.groupScope(groupScope == null ? null : groupScope.toString());
            return this;
        }

        public final String getGroupType() {
            return groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final Map<String, AttributeValue.Builder> getOtherAttributes() {
            Map<String, AttributeValue.Builder> result = AttributesCopier.copyToBuilder(this.otherAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOtherAttributes(Map<String, AttributeValue.BuilderImpl> otherAttributes) {
            this.otherAttributes = AttributesCopier.copyFromBuilder(otherAttributes);
        }

        @Override
        public final Builder otherAttributes(Map<String, AttributeValue> otherAttributes) {
            this.otherAttributes = AttributesCopier.copy(otherAttributes);
            return this;
        }

        public final String getSamAccountName() {
            return samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
