/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteUserRequest extends DirectoryServiceDataRequest implements
        ToCopyableBuilder<DeleteUserRequest.Builder, DeleteUserRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(DeleteUserRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DeleteUserRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()).build();

    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMAccountName").getter(getter(DeleteUserRequest::samAccountName))
            .setter(setter(Builder::samAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DIRECTORY_ID_FIELD, SAM_ACCOUNT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String directoryId;

    private final String samAccountName;

    private DeleteUserRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.directoryId = builder.directoryId;
        this.samAccountName = builder.samAccountName;
    }

    /**
     * <p>
     * A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so multiple
     * identical calls have the same effect as one single call.
     * </p>
     * <p>
     * A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any request
     * with the same client token is treated as a new request. If the request succeeds, any future uses of that token
     * will be idempotent for another 8 hours.
     * </p>
     * <p>
     * If you submit a request with the same client token but change one of the other parameters within the 8-hour
     * idempotency window, Directory Service Data returns an <code>ConflictException</code>.
     * </p>
     * <note>
     * <p>
     * This parameter is optional when using the CLI or SDK.
     * </p>
     * </note>
     * 
     * @return A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so
     *         multiple identical calls have the same effect as one single call. </p>
     *         <p>
     *         A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
     *         request with the same client token is treated as a new request. If the request succeeds, any future uses
     *         of that token will be idempotent for another 8 hours.
     *         </p>
     *         <p>
     *         If you submit a request with the same client token but change one of the other parameters within the
     *         8-hour idempotency window, Directory Service Data returns an <code>ConflictException</code>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is optional when using the CLI or SDK.
     *         </p>
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier (ID) of the directory that's associated with the user.
     * </p>
     * 
     * @return The identifier (ID) of the directory that's associated with the user.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public final String samAccountName() {
        return samAccountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(samAccountName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserRequest)) {
            return false;
        }
        DeleteUserRequest other = (DeleteUserRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(samAccountName(), other.samAccountName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteUserRequest").add("ClientToken", clientToken()).add("DirectoryId", directoryId())
                .add("SAMAccountName", samAccountName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "SAMAccountName":
            return Optional.ofNullable(clazz.cast(samAccountName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteUserRequest, T> g) {
        return obj -> g.apply((DeleteUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryServiceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteUserRequest> {
        /**
         * <p>
         * A unique and case-sensitive identifier that you provide to make sure the idempotency of the request, so
         * multiple identical calls have the same effect as one single call.
         * </p>
         * <p>
         * A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
         * request with the same client token is treated as a new request. If the request succeeds, any future uses of
         * that token will be idempotent for another 8 hours.
         * </p>
         * <p>
         * If you submit a request with the same client token but change one of the other parameters within the 8-hour
         * idempotency window, Directory Service Data returns an <code>ConflictException</code>.
         * </p>
         * <note>
         * <p>
         * This parameter is optional when using the CLI or SDK.
         * </p>
         * </note>
         * 
         * @param clientToken
         *        A unique and case-sensitive identifier that you provide to make sure the idempotency of the request,
         *        so multiple identical calls have the same effect as one single call. </p>
         *        <p>
         *        A client token is valid for 8 hours after the first request that uses it completes. After 8 hours, any
         *        request with the same client token is treated as a new request. If the request succeeds, any future
         *        uses of that token will be idempotent for another 8 hours.
         *        </p>
         *        <p>
         *        If you submit a request with the same client token but change one of the other parameters within the
         *        8-hour idempotency window, Directory Service Data returns an <code>ConflictException</code>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is optional when using the CLI or SDK.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier (ID) of the directory that's associated with the user.
         * </p>
         * 
         * @param directoryId
         *        The identifier (ID) of the directory that's associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param samAccountName
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samAccountName(String samAccountName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryServiceDataRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String directoryId;

        private String samAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserRequest model) {
            super(model);
            clientToken(model.clientToken);
            directoryId(model.directoryId);
            samAccountName(model.samAccountName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getSamAccountName() {
            return samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteUserRequest build() {
            return new DeleteUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
