/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A member object that contains identifying information for a specified member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Member implements SdkPojo, Serializable, ToCopyableBuilder<Member.Builder, Member> {
    private static final SdkField<String> MEMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberType").getter(getter(Member::memberTypeAsString)).setter(setter(Builder::memberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberType").build()).build();

    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMAccountName").getter(getter(Member::samAccountName)).setter(setter(Builder::samAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()).build();

    private static final SdkField<String> SID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SID")
            .getter(getter(Member::sid)).setter(setter(Builder::sid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_TYPE_FIELD,
            SAM_ACCOUNT_NAME_FIELD, SID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String memberType;

    private final String samAccountName;

    private final String sid;

    private Member(BuilderImpl builder) {
        this.memberType = builder.memberType;
        this.samAccountName = builder.samAccountName;
        this.sid = builder.sid;
    }

    /**
     * <p>
     * The AD type of the member object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberType} will
     * return {@link MemberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberTypeAsString}.
     * </p>
     * 
     * @return The AD type of the member object.
     * @see MemberType
     */
    public final MemberType memberType() {
        return MemberType.fromValue(memberType);
    }

    /**
     * <p>
     * The AD type of the member object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberType} will
     * return {@link MemberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberTypeAsString}.
     * </p>
     * 
     * @return The AD type of the member object.
     * @see MemberType
     */
    public final String memberTypeAsString() {
        return memberType;
    }

    /**
     * <p>
     * The name of the group member.
     * </p>
     * 
     * @return The name of the group member.
     */
    public final String samAccountName() {
        return samAccountName;
    }

    /**
     * <p>
     * The unique security identifier (SID) of the group member.
     * </p>
     * 
     * @return The unique security identifier (SID) of the group member.
     */
    public final String sid() {
        return sid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(sid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member) obj;
        return Objects.equals(memberTypeAsString(), other.memberTypeAsString())
                && Objects.equals(samAccountName(), other.samAccountName()) && Objects.equals(sid(), other.sid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Member").add("MemberType", memberTypeAsString()).add("SAMAccountName", samAccountName())
                .add("SID", sid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberType":
            return Optional.ofNullable(clazz.cast(memberTypeAsString()));
        case "SAMAccountName":
            return Optional.ofNullable(clazz.cast(samAccountName()));
        case "SID":
            return Optional.ofNullable(clazz.cast(sid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MemberType", MEMBER_TYPE_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        map.put("SID", SID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Member> {
        /**
         * <p>
         * The AD type of the member object.
         * </p>
         * 
         * @param memberType
         *        The AD type of the member object.
         * @see MemberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberType
         */
        Builder memberType(String memberType);

        /**
         * <p>
         * The AD type of the member object.
         * </p>
         * 
         * @param memberType
         *        The AD type of the member object.
         * @see MemberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberType
         */
        Builder memberType(MemberType memberType);

        /**
         * <p>
         * The name of the group member.
         * </p>
         * 
         * @param samAccountName
         *        The name of the group member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samAccountName(String samAccountName);

        /**
         * <p>
         * The unique security identifier (SID) of the group member.
         * </p>
         * 
         * @param sid
         *        The unique security identifier (SID) of the group member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sid(String sid);
    }

    static final class BuilderImpl implements Builder {
        private String memberType;

        private String samAccountName;

        private String sid;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            memberType(model.memberType);
            samAccountName(model.samAccountName);
            sid(model.sid);
        }

        public final String getMemberType() {
            return memberType;
        }

        public final void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        @Override
        public final Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        @Override
        public final Builder memberType(MemberType memberType) {
            this.memberType(memberType == null ? null : memberType.toString());
            return this;
        }

        public final String getSamAccountName() {
            return samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSid() {
            return sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        @Override
        public Member build() {
            return new Member(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
