/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchGroupsRequest extends DirectoryServiceDataRequest implements
        ToCopyableBuilder<SearchGroupsRequest.Builder, SearchGroupsRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(SearchGroupsRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchGroupsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchGroupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Realm")
            .getter(getter(SearchGroupsRequest::realm)).setter(setter(Builder::realm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()).build();

    private static final SdkField<List<String>> SEARCH_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SearchAttributes")
            .getter(getter(SearchGroupsRequest::searchAttributes))
            .setter(setter(Builder::searchAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SEARCH_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchString").getter(getter(SearchGroupsRequest::searchString)).setter(setter(Builder::searchString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REALM_FIELD, SEARCH_ATTRIBUTES_FIELD, SEARCH_STRING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final Integer maxResults;

    private final String nextToken;

    private final String realm;

    private final List<String> searchAttributes;

    private final String searchString;

    private SearchGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.realm = builder.realm;
        this.searchAttributes = builder.searchAttributes;
        this.searchString = builder.searchString;
    }

    /**
     * <p>
     * The identifier (ID) of the directory that's associated with the group.
     * </p>
     * 
     * @return The identifier (ID) of the directory that's associated with the group.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request.
     * </p>
     * 
     * @return The maximum number of results to be returned per request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An encoded paging token for paginated calls that can be passed back to retrieve the next page.
     * </p>
     * 
     * @return An encoded paging token for paginated calls that can be passed back to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The domain name that's associated with the group.
     * </p>
     * <note>
     * <p>
     * This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When no value
     * is defined, only your Managed Microsoft AD groups are returned.
     * </p>
     * <p>
     * This value is case insensitive.
     * </p>
     * </note>
     * 
     * @return The domain name that's associated with the group. </p> <note>
     *         <p>
     *         This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When no
     *         value is defined, only your Managed Microsoft AD groups are returned.
     *         </p>
     *         <p>
     *         This value is case insensitive.
     *         </p>
     */
    public final String realm() {
        return realm;
    }

    /**
     * For responses, this returns true if the service returned a value for the SearchAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSearchAttributes() {
        return searchAttributes != null && !(searchAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more data attributes that are used to search for a group. For a list of supported attributes, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory Service
     * Data Attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSearchAttributes} method.
     * </p>
     * 
     * @return One or more data attributes that are used to search for a group. For a list of supported attributes, see
     *         <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">
     *         Directory Service Data Attributes</a>.
     */
    public final List<String> searchAttributes() {
        return searchAttributes;
    }

    /**
     * <p>
     * The attribute value that you want to search for.
     * </p>
     * <note>
     * <p>
     * Wildcard <code>(*)</code> searches aren't supported. For a list of supported attributes, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory Service
     * Data Attributes</a>.
     * </p>
     * </note>
     * 
     * @return The attribute value that you want to search for. </p> <note>
     *         <p>
     *         Wildcard <code>(*)</code> searches aren't supported. For a list of supported attributes, see <a
     *         href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory
     *         Service Data Attributes</a>.
     *         </p>
     */
    public final String searchString() {
        return searchString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(realm());
        hashCode = 31 * hashCode + Objects.hashCode(hasSearchAttributes() ? searchAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(searchString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGroupsRequest)) {
            return false;
        }
        SearchGroupsRequest other = (SearchGroupsRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(realm(), other.realm())
                && hasSearchAttributes() == other.hasSearchAttributes()
                && Objects.equals(searchAttributes(), other.searchAttributes())
                && Objects.equals(searchString(), other.searchString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchGroupsRequest").add("DirectoryId", directoryId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").add("Realm", realm())
                .add("SearchAttributes", hasSearchAttributes() ? searchAttributes() : null)
                .add("SearchString", searchString() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Realm":
            return Optional.ofNullable(clazz.cast(realm()));
        case "SearchAttributes":
            return Optional.ofNullable(clazz.cast(searchAttributes()));
        case "SearchString":
            return Optional.ofNullable(clazz.cast(searchString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Realm", REALM_FIELD);
        map.put("SearchAttributes", SEARCH_ATTRIBUTES_FIELD);
        map.put("SearchString", SEARCH_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchGroupsRequest, T> g) {
        return obj -> g.apply((SearchGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryServiceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchGroupsRequest> {
        /**
         * <p>
         * The identifier (ID) of the directory that's associated with the group.
         * </p>
         * 
         * @param directoryId
         *        The identifier (ID) of the directory that's associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The maximum number of results to be returned per request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An encoded paging token for paginated calls that can be passed back to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        An encoded paging token for paginated calls that can be passed back to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The domain name that's associated with the group.
         * </p>
         * <note>
         * <p>
         * This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When no
         * value is defined, only your Managed Microsoft AD groups are returned.
         * </p>
         * <p>
         * This value is case insensitive.
         * </p>
         * </note>
         * 
         * @param realm
         *        The domain name that's associated with the group. </p> <note>
         *        <p>
         *        This parameter is optional, so you can return groups outside of your Managed Microsoft AD domain. When
         *        no value is defined, only your Managed Microsoft AD groups are returned.
         *        </p>
         *        <p>
         *        This value is case insensitive.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realm(String realm);

        /**
         * <p>
         * One or more data attributes that are used to search for a group. For a list of supported attributes, see <a
         * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory
         * Service Data Attributes</a>.
         * </p>
         * 
         * @param searchAttributes
         *        One or more data attributes that are used to search for a group. For a list of supported attributes,
         *        see <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">
         *        Directory Service Data Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchAttributes(Collection<String> searchAttributes);

        /**
         * <p>
         * One or more data attributes that are used to search for a group. For a list of supported attributes, see <a
         * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory
         * Service Data Attributes</a>.
         * </p>
         * 
         * @param searchAttributes
         *        One or more data attributes that are used to search for a group. For a list of supported attributes,
         *        see <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">
         *        Directory Service Data Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchAttributes(String... searchAttributes);

        /**
         * <p>
         * The attribute value that you want to search for.
         * </p>
         * <note>
         * <p>
         * Wildcard <code>(*)</code> searches aren't supported. For a list of supported attributes, see <a
         * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html">Directory
         * Service Data Attributes</a>.
         * </p>
         * </note>
         * 
         * @param searchString
         *        The attribute value that you want to search for. </p> <note>
         *        <p>
         *        Wildcard <code>(*)</code> searches aren't supported. For a list of supported attributes, see <a
         *        href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html"
         *        >Directory Service Data Attributes</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchString(String searchString);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryServiceDataRequest.BuilderImpl implements Builder {
        private String directoryId;

        private Integer maxResults;

        private String nextToken;

        private String realm;

        private List<String> searchAttributes = DefaultSdkAutoConstructList.getInstance();

        private String searchString;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGroupsRequest model) {
            super(model);
            directoryId(model.directoryId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            realm(model.realm);
            searchAttributes(model.searchAttributes);
            searchString(model.searchString);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRealm() {
            return realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final Collection<String> getSearchAttributes() {
            if (searchAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return searchAttributes;
        }

        public final void setSearchAttributes(Collection<String> searchAttributes) {
            this.searchAttributes = LdapDisplayNameListCopier.copy(searchAttributes);
        }

        @Override
        public final Builder searchAttributes(Collection<String> searchAttributes) {
            this.searchAttributes = LdapDisplayNameListCopier.copy(searchAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchAttributes(String... searchAttributes) {
            searchAttributes(Arrays.asList(searchAttributes));
            return this;
        }

        public final String getSearchString() {
            return searchString;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchGroupsRequest build() {
            return new SearchGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
