/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ValidationExceptionReason {
    INVALID_REALM("INVALID_REALM"),

    INVALID_DIRECTORY_TYPE("INVALID_DIRECTORY_TYPE"),

    INVALID_SECONDARY_REGION("INVALID_SECONDARY_REGION"),

    INVALID_NEXT_TOKEN("INVALID_NEXT_TOKEN"),

    INVALID_ATTRIBUTE_VALUE("INVALID_ATTRIBUTE_VALUE"),

    INVALID_ATTRIBUTE_NAME("INVALID_ATTRIBUTE_NAME"),

    INVALID_ATTRIBUTE_FOR_USER("INVALID_ATTRIBUTE_FOR_USER"),

    INVALID_ATTRIBUTE_FOR_GROUP("INVALID_ATTRIBUTE_FOR_GROUP"),

    INVALID_ATTRIBUTE_FOR_SEARCH("INVALID_ATTRIBUTE_FOR_SEARCH"),

    INVALID_ATTRIBUTE_FOR_MODIFY("INVALID_ATTRIBUTE_FOR_MODIFY"),

    DUPLICATE_ATTRIBUTE("DUPLICATE_ATTRIBUTE"),

    MISSING_ATTRIBUTE("MISSING_ATTRIBUTE"),

    ATTRIBUTE_EXISTS("ATTRIBUTE_EXISTS"),

    LDAP_SIZE_LIMIT_EXCEEDED("LDAP_SIZE_LIMIT_EXCEEDED"),

    LDAP_UNSUPPORTED_OPERATION("LDAP_UNSUPPORTED_OPERATION"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionReason> VALUE_MAP = EnumUtils.uniqueIndex(
            ValidationExceptionReason.class, ValidationExceptionReason::toString);

    private final String value;

    private ValidationExceptionReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ValidationExceptionReason corresponding to the value
     */
    public static ValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ValidationExceptionReason}s
     */
    public static Set<ValidationExceptionReason> knownValues() {
        Set<ValidationExceptionReason> knownValues = EnumSet.allOf(ValidationExceptionReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
