/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directoryservicedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing a subset of fields of a group object from a directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupSummary implements SdkPojo, Serializable, ToCopyableBuilder<GroupSummary.Builder, GroupSummary> {
    private static final SdkField<String> GROUP_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupScope").getter(getter(GroupSummary::groupScopeAsString)).setter(setter(Builder::groupScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupScope").build()).build();

    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupType").getter(getter(GroupSummary::groupTypeAsString)).setter(setter(Builder::groupType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupType").build()).build();

    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMAccountName").getter(getter(GroupSummary::samAccountName)).setter(setter(Builder::samAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()).build();

    private static final SdkField<String> SID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SID")
            .getter(getter(GroupSummary::sid)).setter(setter(Builder::sid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_SCOPE_FIELD,
            GROUP_TYPE_FIELD, SAM_ACCOUNT_NAME_FIELD, SID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupScope;

    private final String groupType;

    private final String samAccountName;

    private final String sid;

    private GroupSummary(BuilderImpl builder) {
        this.groupScope = builder.groupScope;
        this.groupType = builder.groupType;
        this.samAccountName = builder.samAccountName;
        this.sid = builder.sid;
    }

    /**
     * <p>
     * The scope of the AD group. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     * >Active Directory security groups</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupScope} will
     * return {@link GroupScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupScopeAsString}.
     * </p>
     * 
     * @return The scope of the AD group. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     *         >Active Directory security groups</a>.
     * @see GroupScope
     */
    public final GroupScope groupScope() {
        return GroupScope.fromValue(groupScope);
    }

    /**
     * <p>
     * The scope of the AD group. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     * >Active Directory security groups</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupScope} will
     * return {@link GroupScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupScopeAsString}.
     * </p>
     * 
     * @return The scope of the AD group. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
     *         >Active Directory security groups</a>.
     * @see GroupScope
     */
    public final String groupScopeAsString() {
        return groupScope;
    }

    /**
     * <p>
     * The AD group type. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     * >Active Directory security group type</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupType} will
     * return {@link GroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupTypeAsString}.
     * </p>
     * 
     * @return The AD group type. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     *         >Active Directory security group type</a>.
     * @see GroupType
     */
    public final GroupType groupType() {
        return GroupType.fromValue(groupType);
    }

    /**
     * <p>
     * The AD group type. For details, see <a href=
     * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     * >Active Directory security group type</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupType} will
     * return {@link GroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupTypeAsString}.
     * </p>
     * 
     * @return The AD group type. For details, see <a href=
     *         "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
     *         >Active Directory security group type</a>.
     * @see GroupType
     */
    public final String groupTypeAsString() {
        return groupType;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public final String samAccountName() {
        return samAccountName;
    }

    /**
     * <p>
     * The unique security identifier (SID) of the group.
     * </p>
     * 
     * @return The unique security identifier (SID) of the group.
     */
    public final String sid() {
        return sid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(sid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupSummary)) {
            return false;
        }
        GroupSummary other = (GroupSummary) obj;
        return Objects.equals(groupScopeAsString(), other.groupScopeAsString())
                && Objects.equals(groupTypeAsString(), other.groupTypeAsString())
                && Objects.equals(samAccountName(), other.samAccountName()) && Objects.equals(sid(), other.sid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupSummary").add("GroupScope", groupScopeAsString()).add("GroupType", groupTypeAsString())
                .add("SAMAccountName", samAccountName()).add("SID", sid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupScope":
            return Optional.ofNullable(clazz.cast(groupScopeAsString()));
        case "GroupType":
            return Optional.ofNullable(clazz.cast(groupTypeAsString()));
        case "SAMAccountName":
            return Optional.ofNullable(clazz.cast(samAccountName()));
        case "SID":
            return Optional.ofNullable(clazz.cast(sid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupScope", GROUP_SCOPE_FIELD);
        map.put("GroupType", GROUP_TYPE_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        map.put("SID", SID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupSummary, T> g) {
        return obj -> g.apply((GroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupSummary> {
        /**
         * <p>
         * The scope of the AD group. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         * >Active Directory security groups</a>.
         * </p>
         * 
         * @param groupScope
         *        The scope of the AD group. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         *        >Active Directory security groups</a>.
         * @see GroupScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupScope
         */
        Builder groupScope(String groupScope);

        /**
         * <p>
         * The scope of the AD group. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         * >Active Directory security groups</a>.
         * </p>
         * 
         * @param groupScope
         *        The scope of the AD group. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope"
         *        >Active Directory security groups</a>.
         * @see GroupScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupScope
         */
        Builder groupScope(GroupScope groupScope);

        /**
         * <p>
         * The AD group type. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         * >Active Directory security group type</a>.
         * </p>
         * 
         * @param groupType
         *        The AD group type. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         *        >Active Directory security group type</a>.
         * @see GroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupType
         */
        Builder groupType(String groupType);

        /**
         * <p>
         * The AD group type. For details, see <a href=
         * "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         * >Active Directory security group type</a>.
         * </p>
         * 
         * @param groupType
         *        The AD group type. For details, see <a href=
         *        "https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work"
         *        >Active Directory security group type</a>.
         * @see GroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupType
         */
        Builder groupType(GroupType groupType);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param samAccountName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samAccountName(String samAccountName);

        /**
         * <p>
         * The unique security identifier (SID) of the group.
         * </p>
         * 
         * @param sid
         *        The unique security identifier (SID) of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sid(String sid);
    }

    static final class BuilderImpl implements Builder {
        private String groupScope;

        private String groupType;

        private String samAccountName;

        private String sid;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupSummary model) {
            groupScope(model.groupScope);
            groupType(model.groupType);
            samAccountName(model.samAccountName);
            sid(model.sid);
        }

        public final String getGroupScope() {
            return groupScope;
        }

        public final void setGroupScope(String groupScope) {
            this.groupScope = groupScope;
        }

        @Override
        public final Builder groupScope(String groupScope) {
            this.groupScope = groupScope;
            return this;
        }

        @Override
        public final Builder groupScope(GroupScope groupScope) {
            this.groupScope(groupScope == null ? null : groupScope.toString());
            return this;
        }

        public final String getGroupType() {
            return groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final String getSamAccountName() {
            return samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSid() {
            return sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        @Override
        public GroupSummary build() {
            return new GroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
