/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the retention rule for a lifecycle policy. You can retain snapshots based on either a count or a time
 * interval.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetainRule implements SdkPojo, Serializable, ToCopyableBuilder<RetainRule.Builder, RetainRule> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RetainRule::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RetainRule::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<String> INTERVAL_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RetainRule::intervalUnitAsString)).setter(setter(Builder::intervalUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, INTERVAL_FIELD,
            INTERVAL_UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final Integer interval;

    private final String intervalUnit;

    private RetainRule(BuilderImpl builder) {
        this.count = builder.count;
        this.interval = builder.interval;
        this.intervalUnit = builder.intervalUnit;
    }

    /**
     * <p>
     * The number of snapshots to retain for each volume, up to a maximum of 1000.
     * </p>
     * 
     * @return The number of snapshots to retain for each volume, up to a maximum of 1000.
     */
    public Integer count() {
        return count;
    }

    /**
     * <p>
     * The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200 months, 5200
     * weeks, or 36500 days.
     * </p>
     * 
     * @return The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200 months,
     *         5200 weeks, or 36500 days.
     */
    public Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The unit of time for time-based retention.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalUnit} will
     * return {@link RetentionIntervalUnitValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #intervalUnitAsString}.
     * </p>
     * 
     * @return The unit of time for time-based retention.
     * @see RetentionIntervalUnitValues
     */
    public RetentionIntervalUnitValues intervalUnit() {
        return RetentionIntervalUnitValues.fromValue(intervalUnit);
    }

    /**
     * <p>
     * The unit of time for time-based retention.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalUnit} will
     * return {@link RetentionIntervalUnitValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #intervalUnitAsString}.
     * </p>
     * 
     * @return The unit of time for time-based retention.
     * @see RetentionIntervalUnitValues
     */
    public String intervalUnitAsString() {
        return intervalUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(intervalUnitAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetainRule)) {
            return false;
        }
        RetainRule other = (RetainRule) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(interval(), other.interval())
                && Objects.equals(intervalUnitAsString(), other.intervalUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RetainRule").add("Count", count()).add("Interval", interval())
                .add("IntervalUnit", intervalUnitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "IntervalUnit":
            return Optional.ofNullable(clazz.cast(intervalUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetainRule, T> g) {
        return obj -> g.apply((RetainRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetainRule> {
        /**
         * <p>
         * The number of snapshots to retain for each volume, up to a maximum of 1000.
         * </p>
         * 
         * @param count
         *        The number of snapshots to retain for each volume, up to a maximum of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200 months, 5200
         * weeks, or 36500 days.
         * </p>
         * 
         * @param interval
         *        The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200
         *        months, 5200 weeks, or 36500 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The unit of time for time-based retention.
         * </p>
         * 
         * @param intervalUnit
         *        The unit of time for time-based retention.
         * @see RetentionIntervalUnitValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionIntervalUnitValues
         */
        Builder intervalUnit(String intervalUnit);

        /**
         * <p>
         * The unit of time for time-based retention.
         * </p>
         * 
         * @param intervalUnit
         *        The unit of time for time-based retention.
         * @see RetentionIntervalUnitValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionIntervalUnitValues
         */
        Builder intervalUnit(RetentionIntervalUnitValues intervalUnit);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private Integer interval;

        private String intervalUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(RetainRule model) {
            count(model.count);
            interval(model.interval);
            intervalUnit(model.intervalUnit);
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Integer getInterval() {
            return interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final String getIntervalUnitAsString() {
            return intervalUnit;
        }

        @Override
        public final Builder intervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
            return this;
        }

        @Override
        public final Builder intervalUnit(RetentionIntervalUnitValues intervalUnit) {
            this.intervalUnit(intervalUnit == null ? null : intervalUnit.toString());
            return this;
        }

        public final void setIntervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
        }

        @Override
        public RetainRule build() {
            return new RetainRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
