/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a lifecycle policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicy implements SdkPojo, Serializable, ToCopyableBuilder<LifecyclePolicy.Builder, LifecyclePolicy> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::executionRoleArn)).setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LifecyclePolicy::dateCreated))
            .setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LifecyclePolicy::dateModified))
            .setter(setter(Builder::dateModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField
            .<PolicyDetails> builder(MarshallingType.SDK_POJO).getter(getter(LifecyclePolicy::policyDetails))
            .setter(setter(Builder::policyDetails)).constructor(PolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDetails").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(LifecyclePolicy::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            DESCRIPTION_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, EXECUTION_ROLE_ARN_FIELD, DATE_CREATED_FIELD,
            DATE_MODIFIED_FIELD, POLICY_DETAILS_FIELD, TAGS_FIELD, POLICY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyId;

    private final String description;

    private final String state;

    private final String statusMessage;

    private final String executionRoleArn;

    private final Instant dateCreated;

    private final Instant dateModified;

    private final PolicyDetails policyDetails;

    private final Map<String, String> tags;

    private final String policyArn;

    private LifecyclePolicy(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.description = builder.description;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.executionRoleArn = builder.executionRoleArn;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
        this.policyDetails = builder.policyDetails;
        this.tags = builder.tags;
        this.policyArn = builder.policyArn;
    }

    /**
     * <p>
     * The identifier of the lifecycle policy.
     * </p>
     * 
     * @return The identifier of the lifecycle policy.
     */
    public String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The description of the lifecycle policy.
     * </p>
     * 
     * @return The description of the lifecycle policy.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The activation state of the lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link GettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The activation state of the lifecycle policy.
     * @see GettablePolicyStateValues
     */
    public GettablePolicyStateValues state() {
        return GettablePolicyStateValues.fromValue(state);
    }

    /**
     * <p>
     * The activation state of the lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link GettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The activation state of the lifecycle policy.
     * @see GettablePolicyStateValues
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The description of the status.
     * </p>
     * 
     * @return The description of the status.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle
     *         policy.
     */
    public String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The local date and time when the lifecycle policy was created.
     * </p>
     * 
     * @return The local date and time when the lifecycle policy was created.
     */
    public Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The local date and time when the lifecycle policy was last modified.
     * </p>
     * 
     * @return The local date and time when the lifecycle policy was last modified.
     */
    public Instant dateModified() {
        return dateModified;
    }

    /**
     * <p>
     * The configuration of the lifecycle policy
     * </p>
     * 
     * @return The configuration of the lifecycle policy
     */
    public PolicyDetails policyDetails() {
        return policyDetails;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the policy.
     */
    public String policyArn() {
        return policyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateModified());
        hashCode = 31 * hashCode + Objects.hashCode(policyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicy)) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(description(), other.description())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateModified(), other.dateModified())
                && Objects.equals(policyDetails(), other.policyDetails()) && Objects.equals(tags(), other.tags())
                && Objects.equals(policyArn(), other.policyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LifecyclePolicy").add("PolicyId", policyId()).add("Description", description())
                .add("State", stateAsString()).add("StatusMessage", statusMessage()).add("ExecutionRoleArn", executionRoleArn())
                .add("DateCreated", dateCreated()).add("DateModified", dateModified()).add("PolicyDetails", policyDetails())
                .add("Tags", tags()).add("PolicyArn", policyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateModified":
            return Optional.ofNullable(clazz.cast(dateModified()));
        case "PolicyDetails":
            return Optional.ofNullable(clazz.cast(policyDetails()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicy, T> g) {
        return obj -> g.apply((LifecyclePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicy> {
        /**
         * <p>
         * The identifier of the lifecycle policy.
         * </p>
         * 
         * @param policyId
         *        The identifier of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The description of the lifecycle policy.
         * </p>
         * 
         * @param description
         *        The description of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The activation state of the lifecycle policy.
         * </p>
         * 
         * @param state
         *        The activation state of the lifecycle policy.
         * @see GettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GettablePolicyStateValues
         */
        Builder state(String state);

        /**
         * <p>
         * The activation state of the lifecycle policy.
         * </p>
         * 
         * @param state
         *        The activation state of the lifecycle policy.
         * @see GettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GettablePolicyStateValues
         */
        Builder state(GettablePolicyStateValues state);

        /**
         * <p>
         * The description of the status.
         * </p>
         * 
         * @param statusMessage
         *        The description of the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle
         *        policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The local date and time when the lifecycle policy was created.
         * </p>
         * 
         * @param dateCreated
         *        The local date and time when the lifecycle policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The local date and time when the lifecycle policy was last modified.
         * </p>
         * 
         * @param dateModified
         *        The local date and time when the lifecycle policy was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateModified(Instant dateModified);

        /**
         * <p>
         * The configuration of the lifecycle policy
         * </p>
         * 
         * @param policyDetails
         *        The configuration of the lifecycle policy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(PolicyDetails policyDetails);

        /**
         * <p>
         * The configuration of the lifecycle policy
         * </p>
         * This is a convenience that creates an instance of the {@link PolicyDetails.Builder} avoiding the need to
         * create one manually via {@link PolicyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link PolicyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #policyDetails(PolicyDetails)}.
         * 
         * @param policyDetails
         *        a consumer that will call methods on {@link PolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDetails(PolicyDetails)
         */
        default Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return policyDetails(PolicyDetails.builder().applyMutation(policyDetails).build());
        }

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the policy.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);
    }

    static final class BuilderImpl implements Builder {
        private String policyId;

        private String description;

        private String state;

        private String statusMessage;

        private String executionRoleArn;

        private Instant dateCreated;

        private Instant dateModified;

        private PolicyDetails policyDetails;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String policyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicy model) {
            policyId(model.policyId);
            description(model.description);
            state(model.state);
            statusMessage(model.statusMessage);
            executionRoleArn(model.executionRoleArn);
            dateCreated(model.dateCreated);
            dateModified(model.dateModified);
            policyDetails(model.policyDetails);
            tags(model.tags);
            policyArn(model.policyArn);
        }

        public final String getPolicyId() {
            return policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(GettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateModified() {
            return dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return policyDetails != null ? policyDetails.toBuilder() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public LifecyclePolicy build() {
            return new LifecyclePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
