/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a rule for cross-Region snapshot copies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrossRegionCopyRule implements SdkPojo, Serializable,
        ToCopyableBuilder<CrossRegionCopyRule.Builder, CrossRegionCopyRule> {
    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CrossRegionCopyRule::targetRegion)).setter(setter(Builder::targetRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRegion").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CrossRegionCopyRule::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> CMK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CrossRegionCopyRule::cmkArn)).setter(setter(Builder::cmkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CmkArn").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CrossRegionCopyRule::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()).build();

    private static final SdkField<CrossRegionCopyRetainRule> RETAIN_RULE_FIELD = SdkField
            .<CrossRegionCopyRetainRule> builder(MarshallingType.SDK_POJO).getter(getter(CrossRegionCopyRule::retainRule))
            .setter(setter(Builder::retainRule)).constructor(CrossRegionCopyRetainRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_REGION_FIELD,
            ENCRYPTED_FIELD, CMK_ARN_FIELD, COPY_TAGS_FIELD, RETAIN_RULE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetRegion;

    private final Boolean encrypted;

    private final String cmkArn;

    private final Boolean copyTags;

    private final CrossRegionCopyRetainRule retainRule;

    private CrossRegionCopyRule(BuilderImpl builder) {
        this.targetRegion = builder.targetRegion;
        this.encrypted = builder.encrypted;
        this.cmkArn = builder.cmkArn;
        this.copyTags = builder.copyTags;
        this.retainRule = builder.retainRule;
    }

    /**
     * <p>
     * The target Region.
     * </p>
     * 
     * @return The target Region.
     */
    public String targetRegion() {
        return targetRegion;
    }

    /**
     * <p>
     * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using
     * this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by
     * default is not enabled.
     * </p>
     * 
     * @return To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption
     *         using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if
     *         encryption by default is not enabled.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS KMS customer master key (CMK) to use for EBS encryption. If this
     * parameter is not specified, your AWS managed CMK for EBS is used.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS KMS customer master key (CMK) to use for EBS encryption. If
     *         this parameter is not specified, your AWS managed CMK for EBS is used.
     */
    public String cmkArn() {
        return cmkArn;
    }

    /**
     * <p>
     * Copy all user-defined tags from the source snapshot to the copied snapshot.
     * </p>
     * 
     * @return Copy all user-defined tags from the source snapshot to the copied snapshot.
     */
    public Boolean copyTags() {
        return copyTags;
    }

    /**
     * <p>
     * The retention rule.
     * </p>
     * 
     * @return The retention rule.
     */
    public CrossRegionCopyRetainRule retainRule() {
        return retainRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(cmkArn());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(retainRule());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossRegionCopyRule)) {
            return false;
        }
        CrossRegionCopyRule other = (CrossRegionCopyRule) obj;
        return Objects.equals(targetRegion(), other.targetRegion()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(cmkArn(), other.cmkArn()) && Objects.equals(copyTags(), other.copyTags())
                && Objects.equals(retainRule(), other.retainRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CrossRegionCopyRule").add("TargetRegion", targetRegion()).add("Encrypted", encrypted())
                .add("CmkArn", cmkArn()).add("CopyTags", copyTags()).add("RetainRule", retainRule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetRegion":
            return Optional.ofNullable(clazz.cast(targetRegion()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "CmkArn":
            return Optional.ofNullable(clazz.cast(cmkArn()));
        case "CopyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "RetainRule":
            return Optional.ofNullable(clazz.cast(retainRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrossRegionCopyRule, T> g) {
        return obj -> g.apply((CrossRegionCopyRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrossRegionCopyRule> {
        /**
         * <p>
         * The target Region.
         * </p>
         * 
         * @param targetRegion
         *        The target Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRegion(String targetRegion);

        /**
         * <p>
         * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using
         * this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption
         * by default is not enabled.
         * </p>
         * 
         * @param encrypted
         *        To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable
         *        encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter
         *        is false or if encryption by default is not enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS KMS customer master key (CMK) to use for EBS encryption. If this
         * parameter is not specified, your AWS managed CMK for EBS is used.
         * </p>
         * 
         * @param cmkArn
         *        The Amazon Resource Name (ARN) of the AWS KMS customer master key (CMK) to use for EBS encryption. If
         *        this parameter is not specified, your AWS managed CMK for EBS is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cmkArn(String cmkArn);

        /**
         * <p>
         * Copy all user-defined tags from the source snapshot to the copied snapshot.
         * </p>
         * 
         * @param copyTags
         *        Copy all user-defined tags from the source snapshot to the copied snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * The retention rule.
         * </p>
         * 
         * @param retainRule
         *        The retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainRule(CrossRegionCopyRetainRule retainRule);

        /**
         * <p>
         * The retention rule.
         * </p>
         * This is a convenience that creates an instance of the {@link CrossRegionCopyRetainRule.Builder} avoiding the
         * need to create one manually via {@link CrossRegionCopyRetainRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link CrossRegionCopyRetainRule.Builder#build()} is called immediately
         * and its result is passed to {@link #retainRule(CrossRegionCopyRetainRule)}.
         * 
         * @param retainRule
         *        a consumer that will call methods on {@link CrossRegionCopyRetainRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retainRule(CrossRegionCopyRetainRule)
         */
        default Builder retainRule(Consumer<CrossRegionCopyRetainRule.Builder> retainRule) {
            return retainRule(CrossRegionCopyRetainRule.builder().applyMutation(retainRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String targetRegion;

        private Boolean encrypted;

        private String cmkArn;

        private Boolean copyTags;

        private CrossRegionCopyRetainRule retainRule;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossRegionCopyRule model) {
            targetRegion(model.targetRegion);
            encrypted(model.encrypted);
            cmkArn(model.cmkArn);
            copyTags(model.copyTags);
            retainRule(model.retainRule);
        }

        public final String getTargetRegion() {
            return targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getCmkArn() {
            return cmkArn;
        }

        @Override
        public final Builder cmkArn(String cmkArn) {
            this.cmkArn = cmkArn;
            return this;
        }

        public final void setCmkArn(String cmkArn) {
            this.cmkArn = cmkArn;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        public final CrossRegionCopyRetainRule.Builder getRetainRule() {
            return retainRule != null ? retainRule.toBuilder() : null;
        }

        @Override
        public final Builder retainRule(CrossRegionCopyRetainRule retainRule) {
            this.retainRule = retainRule;
            return this;
        }

        public final void setRetainRule(CrossRegionCopyRetainRule.BuilderImpl retainRule) {
            this.retainRule = retainRule != null ? retainRule.build() : null;
        }

        @Override
        public CrossRegionCopyRule build() {
            return new CrossRegionCopyRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
