/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the retention rule for cross-Region snapshot copies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrossRegionCopyRetainRule implements SdkPojo, Serializable,
        ToCopyableBuilder<CrossRegionCopyRetainRule.Builder, CrossRegionCopyRetainRule> {
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CrossRegionCopyRetainRule::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<String> INTERVAL_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CrossRegionCopyRetainRule::intervalUnitAsString)).setter(setter(Builder::intervalUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD,
            INTERVAL_UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer interval;

    private final String intervalUnit;

    private CrossRegionCopyRetainRule(BuilderImpl builder) {
        this.interval = builder.interval;
        this.intervalUnit = builder.intervalUnit;
    }

    /**
     * <p>
     * The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200 months, 5200
     * weeks, or 36500 days.
     * </p>
     * 
     * @return The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200 months,
     *         5200 weeks, or 36500 days.
     */
    public Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The unit of time for time-based retention.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalUnit} will
     * return {@link RetentionIntervalUnitValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #intervalUnitAsString}.
     * </p>
     * 
     * @return The unit of time for time-based retention.
     * @see RetentionIntervalUnitValues
     */
    public RetentionIntervalUnitValues intervalUnit() {
        return RetentionIntervalUnitValues.fromValue(intervalUnit);
    }

    /**
     * <p>
     * The unit of time for time-based retention.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalUnit} will
     * return {@link RetentionIntervalUnitValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #intervalUnitAsString}.
     * </p>
     * 
     * @return The unit of time for time-based retention.
     * @see RetentionIntervalUnitValues
     */
    public String intervalUnitAsString() {
        return intervalUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(intervalUnitAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossRegionCopyRetainRule)) {
            return false;
        }
        CrossRegionCopyRetainRule other = (CrossRegionCopyRetainRule) obj;
        return Objects.equals(interval(), other.interval())
                && Objects.equals(intervalUnitAsString(), other.intervalUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CrossRegionCopyRetainRule").add("Interval", interval())
                .add("IntervalUnit", intervalUnitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "IntervalUnit":
            return Optional.ofNullable(clazz.cast(intervalUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrossRegionCopyRetainRule, T> g) {
        return obj -> g.apply((CrossRegionCopyRetainRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrossRegionCopyRetainRule> {
        /**
         * <p>
         * The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200 months, 5200
         * weeks, or 36500 days.
         * </p>
         * 
         * @param interval
         *        The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200
         *        months, 5200 weeks, or 36500 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The unit of time for time-based retention.
         * </p>
         * 
         * @param intervalUnit
         *        The unit of time for time-based retention.
         * @see RetentionIntervalUnitValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionIntervalUnitValues
         */
        Builder intervalUnit(String intervalUnit);

        /**
         * <p>
         * The unit of time for time-based retention.
         * </p>
         * 
         * @param intervalUnit
         *        The unit of time for time-based retention.
         * @see RetentionIntervalUnitValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionIntervalUnitValues
         */
        Builder intervalUnit(RetentionIntervalUnitValues intervalUnit);
    }

    static final class BuilderImpl implements Builder {
        private Integer interval;

        private String intervalUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossRegionCopyRetainRule model) {
            interval(model.interval);
            intervalUnit(model.intervalUnit);
        }

        public final Integer getInterval() {
            return interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final String getIntervalUnitAsString() {
            return intervalUnit;
        }

        @Override
        public final Builder intervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
            return this;
        }

        @Override
        public final Builder intervalUnit(RetentionIntervalUnitValues intervalUnit) {
            this.intervalUnit(intervalUnit == null ? null : intervalUnit.toString());
            return this;
        }

        public final void setIntervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
        }

        @Override
        public CrossRegionCopyRetainRule build() {
            return new CrossRegionCopyRetainRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
