/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLifecyclePoliciesResponse extends DlmResponse implements
        ToCopyableBuilder<GetLifecyclePoliciesResponse.Builder, GetLifecyclePoliciesResponse> {
    private static final SdkField<List<LifecyclePolicySummary>> POLICIES_FIELD = SdkField
            .<List<LifecyclePolicySummary>> builder(MarshallingType.LIST)
            .memberName("Policies")
            .getter(getter(GetLifecyclePoliciesResponse::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD));

    private final List<LifecyclePolicySummary> policies;

    private GetLifecyclePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policies = builder.policies;
    }

    /**
     * Returns true if the Policies property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the lifecycle policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information about the lifecycle policies.
     */
    public final List<LifecyclePolicySummary> policies() {
        return policies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePoliciesResponse)) {
            return false;
        }
        GetLifecyclePoliciesResponse other = (GetLifecyclePoliciesResponse) obj;
        return hasPolicies() == other.hasPolicies() && Objects.equals(policies(), other.policies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLifecyclePoliciesResponse").add("Policies", hasPolicies() ? policies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePoliciesResponse, T> g) {
        return obj -> g.apply((GetLifecyclePoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DlmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLifecyclePoliciesResponse> {
        /**
         * <p>
         * Summary information about the lifecycle policies.
         * </p>
         * 
         * @param policies
         *        Summary information about the lifecycle policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<LifecyclePolicySummary> policies);

        /**
         * <p>
         * Summary information about the lifecycle policies.
         * </p>
         * 
         * @param policies
         *        Summary information about the lifecycle policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(LifecyclePolicySummary... policies);

        /**
         * <p>
         * Summary information about the lifecycle policies.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LifecyclePolicySummary>.Builder} avoiding
         * the need to create one manually via {@link List<LifecyclePolicySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LifecyclePolicySummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #policies(List<LifecyclePolicySummary>)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link List<LifecyclePolicySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(List<LifecyclePolicySummary>)
         */
        Builder policies(Consumer<LifecyclePolicySummary.Builder>... policies);
    }

    static final class BuilderImpl extends DlmResponse.BuilderImpl implements Builder {
        private List<LifecyclePolicySummary> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePoliciesResponse model) {
            super(model);
            policies(model.policies);
        }

        public final Collection<LifecyclePolicySummary.Builder> getPolicies() {
            if (policies instanceof SdkAutoConstructList) {
                return null;
            }
            return policies != null ? policies.stream().map(LifecyclePolicySummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder policies(Collection<LifecyclePolicySummary> policies) {
            this.policies = LifecyclePolicySummaryListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(LifecyclePolicySummary... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<LifecyclePolicySummary.Builder>... policies) {
            policies(Stream.of(policies).map(c -> LifecyclePolicySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPolicies(Collection<LifecyclePolicySummary.BuilderImpl> policies) {
            this.policies = LifecyclePolicySummaryListCopier.copyFromBuilder(policies);
        }

        @Override
        public GetLifecyclePoliciesResponse build() {
            return new GetLifecyclePoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
