/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies when to create snapshots of EBS volumes.
 * </p>
 * <p>
 * You must specify either a Cron expression or an interval, interval unit, and start time. You cannot specify both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRule implements SdkPojo, Serializable, ToCopyableBuilder<CreateRule.Builder, CreateRule> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(CreateRule::locationAsString)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Interval").getter(getter(CreateRule::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<String> INTERVAL_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntervalUnit").getter(getter(CreateRule::intervalUnitAsString)).setter(setter(Builder::intervalUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalUnit").build()).build();

    private static final SdkField<List<String>> TIMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Times")
            .getter(getter(CreateRule::times))
            .setter(setter(Builder::times))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Times").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CronExpression").getter(getter(CreateRule::cronExpression)).setter(setter(Builder::cronExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD,
            INTERVAL_FIELD, INTERVAL_UNIT_FIELD, TIMES_FIELD, CRON_EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String location;

    private final Integer interval;

    private final String intervalUnit;

    private final List<String> times;

    private final String cronExpression;

    private CreateRule(BuilderImpl builder) {
        this.location = builder.location;
        this.interval = builder.interval;
        this.intervalUnit = builder.intervalUnit;
        this.times = builder.times;
        this.cronExpression = builder.cronExpression;
    }

    /**
     * <p>
     * Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the
     * source resource, specify <code>CLOUD</code>. To create snapshots on the same Outpost as the source resource,
     * specify <code>OUTPOST_LOCAL</code>. If you omit this parameter, <code>CLOUD</code> is used by default.
     * </p>
     * <p>
     * If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as the source
     * resource.
     * </p>
     * <p>
     * If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source
     * resource, or in the Region of that Outpost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #location} will
     * return {@link LocationValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #locationAsString}.
     * </p>
     * 
     * @return Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as
     *         the source resource, specify <code>CLOUD</code>. To create snapshots on the same Outpost as the source
     *         resource, specify <code>OUTPOST_LOCAL</code>. If you omit this parameter, <code>CLOUD</code> is used by
     *         default.</p>
     *         <p>
     *         If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as
     *         the source resource.
     *         </p>
     *         <p>
     *         If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the
     *         source resource, or in the Region of that Outpost.
     * @see LocationValues
     */
    public final LocationValues location() {
        return LocationValues.fromValue(location);
    }

    /**
     * <p>
     * Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the
     * source resource, specify <code>CLOUD</code>. To create snapshots on the same Outpost as the source resource,
     * specify <code>OUTPOST_LOCAL</code>. If you omit this parameter, <code>CLOUD</code> is used by default.
     * </p>
     * <p>
     * If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as the source
     * resource.
     * </p>
     * <p>
     * If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source
     * resource, or in the Region of that Outpost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #location} will
     * return {@link LocationValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #locationAsString}.
     * </p>
     * 
     * @return Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as
     *         the source resource, specify <code>CLOUD</code>. To create snapshots on the same Outpost as the source
     *         resource, specify <code>OUTPOST_LOCAL</code>. If you omit this parameter, <code>CLOUD</code> is used by
     *         default.</p>
     *         <p>
     *         If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as
     *         the source resource.
     *         </p>
     *         <p>
     *         If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the
     *         source resource, or in the Region of that Outpost.
     * @see LocationValues
     */
    public final String locationAsString() {
        return location;
    }

    /**
     * <p>
     * The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.
     * </p>
     * 
     * @return The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.
     */
    public final Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The interval unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalUnit} will
     * return {@link IntervalUnitValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intervalUnitAsString}.
     * </p>
     * 
     * @return The interval unit.
     * @see IntervalUnitValues
     */
    public final IntervalUnitValues intervalUnit() {
        return IntervalUnitValues.fromValue(intervalUnit);
    }

    /**
     * <p>
     * The interval unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalUnit} will
     * return {@link IntervalUnitValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intervalUnitAsString}.
     * </p>
     * 
     * @return The interval unit.
     * @see IntervalUnitValues
     */
    public final String intervalUnitAsString() {
        return intervalUnit;
    }

    /**
     * Returns true if the Times property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTimes() {
        return times != null && !(times instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The time, in UTC, to start the operation. The supported format is hh:mm.
     * </p>
     * <p>
     * The operation occurs within a one-hour window following the specified time. If you do not specify a time, Amazon
     * DLM selects a time within the next 24 hours.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTimes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The time, in UTC, to start the operation. The supported format is hh:mm.</p>
     *         <p>
     *         The operation occurs within a one-hour window following the specified time. If you do not specify a time,
     *         Amazon DLM selects a time within the next 24 hours.
     */
    public final List<String> times() {
        return times;
    }

    /**
     * <p>
     * The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
     * expressions</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * 
     * @return The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions"
     *         >Cron expressions</a> in the <i>Amazon CloudWatch User Guide</i>.
     */
    public final String cronExpression() {
        return cronExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(locationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(intervalUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimes() ? times() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cronExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRule)) {
            return false;
        }
        CreateRule other = (CreateRule) obj;
        return Objects.equals(locationAsString(), other.locationAsString()) && Objects.equals(interval(), other.interval())
                && Objects.equals(intervalUnitAsString(), other.intervalUnitAsString()) && hasTimes() == other.hasTimes()
                && Objects.equals(times(), other.times()) && Objects.equals(cronExpression(), other.cronExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRule").add("Location", locationAsString()).add("Interval", interval())
                .add("IntervalUnit", intervalUnitAsString()).add("Times", hasTimes() ? times() : null)
                .add("CronExpression", cronExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Location":
            return Optional.ofNullable(clazz.cast(locationAsString()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "IntervalUnit":
            return Optional.ofNullable(clazz.cast(intervalUnitAsString()));
        case "Times":
            return Optional.ofNullable(clazz.cast(times()));
        case "CronExpression":
            return Optional.ofNullable(clazz.cast(cronExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRule, T> g) {
        return obj -> g.apply((CreateRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateRule> {
        /**
         * <p>
         * Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the
         * source resource, specify <code>CLOUD</code>. To create snapshots on the same Outpost as the source resource,
         * specify <code>OUTPOST_LOCAL</code>. If you omit this parameter, <code>CLOUD</code> is used by default.
         * </p>
         * <p>
         * If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as the
         * source resource.
         * </p>
         * <p>
         * If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the
         * source resource, or in the Region of that Outpost.
         * </p>
         * 
         * @param location
         *        Specifies the destination for snapshots created by the policy. To create snapshots in the same Region
         *        as the source resource, specify <code>CLOUD</code>. To create snapshots on the same Outpost as the
         *        source resource, specify <code>OUTPOST_LOCAL</code>. If you omit this parameter, <code>CLOUD</code> is
         *        used by default.</p>
         *        <p>
         *        If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as
         *        the source resource.
         *        </p>
         *        <p>
         *        If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as
         *        the source resource, or in the Region of that Outpost.
         * @see LocationValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationValues
         */
        Builder location(String location);

        /**
         * <p>
         * Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the
         * source resource, specify <code>CLOUD</code>. To create snapshots on the same Outpost as the source resource,
         * specify <code>OUTPOST_LOCAL</code>. If you omit this parameter, <code>CLOUD</code> is used by default.
         * </p>
         * <p>
         * If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as the
         * source resource.
         * </p>
         * <p>
         * If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the
         * source resource, or in the Region of that Outpost.
         * </p>
         * 
         * @param location
         *        Specifies the destination for snapshots created by the policy. To create snapshots in the same Region
         *        as the source resource, specify <code>CLOUD</code>. To create snapshots on the same Outpost as the
         *        source resource, specify <code>OUTPOST_LOCAL</code>. If you omit this parameter, <code>CLOUD</code> is
         *        used by default.</p>
         *        <p>
         *        If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as
         *        the source resource.
         *        </p>
         *        <p>
         *        If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as
         *        the source resource, or in the Region of that Outpost.
         * @see LocationValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationValues
         */
        Builder location(LocationValues location);

        /**
         * <p>
         * The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.
         * </p>
         * 
         * @param interval
         *        The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The interval unit.
         * </p>
         * 
         * @param intervalUnit
         *        The interval unit.
         * @see IntervalUnitValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntervalUnitValues
         */
        Builder intervalUnit(String intervalUnit);

        /**
         * <p>
         * The interval unit.
         * </p>
         * 
         * @param intervalUnit
         *        The interval unit.
         * @see IntervalUnitValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntervalUnitValues
         */
        Builder intervalUnit(IntervalUnitValues intervalUnit);

        /**
         * <p>
         * The time, in UTC, to start the operation. The supported format is hh:mm.
         * </p>
         * <p>
         * The operation occurs within a one-hour window following the specified time. If you do not specify a time,
         * Amazon DLM selects a time within the next 24 hours.
         * </p>
         * 
         * @param times
         *        The time, in UTC, to start the operation. The supported format is hh:mm.</p>
         *        <p>
         *        The operation occurs within a one-hour window following the specified time. If you do not specify a
         *        time, Amazon DLM selects a time within the next 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder times(Collection<String> times);

        /**
         * <p>
         * The time, in UTC, to start the operation. The supported format is hh:mm.
         * </p>
         * <p>
         * The operation occurs within a one-hour window following the specified time. If you do not specify a time,
         * Amazon DLM selects a time within the next 24 hours.
         * </p>
         * 
         * @param times
         *        The time, in UTC, to start the operation. The supported format is hh:mm.</p>
         *        <p>
         *        The operation occurs within a one-hour window following the specified time. If you do not specify a
         *        time, Amazon DLM selects a time within the next 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder times(String... times);

        /**
         * <p>
         * The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
         * expressions</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * 
         * @param cronExpression
         *        The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
         *        expressions</a> in the <i>Amazon CloudWatch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cronExpression(String cronExpression);
    }

    static final class BuilderImpl implements Builder {
        private String location;

        private Integer interval;

        private String intervalUnit;

        private List<String> times = DefaultSdkAutoConstructList.getInstance();

        private String cronExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRule model) {
            location(model.location);
            interval(model.interval);
            intervalUnit(model.intervalUnit);
            times(model.times);
            cronExpression(model.cronExpression);
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public final Builder location(LocationValues location) {
            this.location(location == null ? null : location.toString());
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final Integer getInterval() {
            return interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final String getIntervalUnit() {
            return intervalUnit;
        }

        @Override
        public final Builder intervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
            return this;
        }

        @Override
        public final Builder intervalUnit(IntervalUnitValues intervalUnit) {
            this.intervalUnit(intervalUnit == null ? null : intervalUnit.toString());
            return this;
        }

        public final void setIntervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
        }

        public final Collection<String> getTimes() {
            if (times instanceof SdkAutoConstructList) {
                return null;
            }
            return times;
        }

        @Override
        public final Builder times(Collection<String> times) {
            this.times = TimesListCopier.copy(times);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder times(String... times) {
            times(Arrays.asList(times));
            return this;
        }

        public final void setTimes(Collection<String> times) {
            this.times = TimesListCopier.copy(times);
        }

        public final String getCronExpression() {
            return cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @Override
        public CreateRule build() {
            return new CreateRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
