/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a backup schedule for a snapshot or AMI lifecycle policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Schedule implements SdkPojo, Serializable, ToCopyableBuilder<Schedule.Builder, Schedule> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Schedule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTags").getter(getter(Schedule::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()).build();

    private static final SdkField<List<Tag>> TAGS_TO_ADD_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagsToAdd")
            .getter(getter(Schedule::tagsToAdd))
            .setter(setter(Builder::tagsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> VARIABLE_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("VariableTags")
            .getter(getter(Schedule::variableTags))
            .setter(setter(Builder::variableTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariableTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CreateRule> CREATE_RULE_FIELD = SdkField.<CreateRule> builder(MarshallingType.SDK_POJO)
            .memberName("CreateRule").getter(getter(Schedule::createRule)).setter(setter(Builder::createRule))
            .constructor(CreateRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateRule").build()).build();

    private static final SdkField<RetainRule> RETAIN_RULE_FIELD = SdkField.<RetainRule> builder(MarshallingType.SDK_POJO)
            .memberName("RetainRule").getter(getter(Schedule::retainRule)).setter(setter(Builder::retainRule))
            .constructor(RetainRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRule").build()).build();

    private static final SdkField<FastRestoreRule> FAST_RESTORE_RULE_FIELD = SdkField
            .<FastRestoreRule> builder(MarshallingType.SDK_POJO).memberName("FastRestoreRule")
            .getter(getter(Schedule::fastRestoreRule)).setter(setter(Builder::fastRestoreRule))
            .constructor(FastRestoreRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FastRestoreRule").build()).build();

    private static final SdkField<List<CrossRegionCopyRule>> CROSS_REGION_COPY_RULES_FIELD = SdkField
            .<List<CrossRegionCopyRule>> builder(MarshallingType.LIST)
            .memberName("CrossRegionCopyRules")
            .getter(getter(Schedule::crossRegionCopyRules))
            .setter(setter(Builder::crossRegionCopyRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRegionCopyRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CrossRegionCopyRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CrossRegionCopyRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ShareRule>> SHARE_RULES_FIELD = SdkField
            .<List<ShareRule>> builder(MarshallingType.LIST)
            .memberName("ShareRules")
            .getter(getter(Schedule::shareRules))
            .setter(setter(Builder::shareRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ShareRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ShareRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COPY_TAGS_FIELD,
            TAGS_TO_ADD_FIELD, VARIABLE_TAGS_FIELD, CREATE_RULE_FIELD, RETAIN_RULE_FIELD, FAST_RESTORE_RULE_FIELD,
            CROSS_REGION_COPY_RULES_FIELD, SHARE_RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Boolean copyTags;

    private final List<Tag> tagsToAdd;

    private final List<Tag> variableTags;

    private final CreateRule createRule;

    private final RetainRule retainRule;

    private final FastRestoreRule fastRestoreRule;

    private final List<CrossRegionCopyRule> crossRegionCopyRules;

    private final List<ShareRule> shareRules;

    private Schedule(BuilderImpl builder) {
        this.name = builder.name;
        this.copyTags = builder.copyTags;
        this.tagsToAdd = builder.tagsToAdd;
        this.variableTags = builder.variableTags;
        this.createRule = builder.createRule;
        this.retainRule = builder.retainRule;
        this.fastRestoreRule = builder.fastRestoreRule;
        this.crossRegionCopyRules = builder.crossRegionCopyRules;
        this.shareRules = builder.shareRules;
    }

    /**
     * <p>
     * The name of the schedule.
     * </p>
     * 
     * @return The name of the schedule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
     * </p>
     * 
     * @return Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * Returns true if the TagsToAdd property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTagsToAdd() {
        return tagsToAdd != null && !(tagsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to policy-created resources. These user-defined tags are in addition to the AWS-added lifecycle
     * tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagsToAdd()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to apply to policy-created resources. These user-defined tags are in addition to the AWS-added
     *         lifecycle tags.
     */
    public final List<Tag> tagsToAdd() {
        return tagsToAdd;
    }

    /**
     * Returns true if the VariableTags property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVariableTags() {
        return variableTags != null && !(variableTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of key/value pairs with values determined dynamically when the policy is executed. Keys may be any
     * valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code> or
     * <code>$(timestamp)</code>. Variable tags are only valid for EBS Snapshot Management – Instance policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVariableTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of key/value pairs with values determined dynamically when the policy is executed. Keys may
     *         be any valid Amazon EC2 tag key. Values must be in one of the two following formats:
     *         <code>$(instance-id)</code> or <code>$(timestamp)</code>. Variable tags are only valid for EBS Snapshot
     *         Management – Instance policies.
     */
    public final List<Tag> variableTags() {
        return variableTags;
    }

    /**
     * <p>
     * The creation rule.
     * </p>
     * 
     * @return The creation rule.
     */
    public final CreateRule createRule() {
        return createRule;
    }

    /**
     * <p>
     * The retention rule.
     * </p>
     * 
     * @return The retention rule.
     */
    public final RetainRule retainRule() {
        return retainRule;
    }

    /**
     * <p>
     * The rule for enabling fast snapshot restore.
     * </p>
     * 
     * @return The rule for enabling fast snapshot restore.
     */
    public final FastRestoreRule fastRestoreRule() {
        return fastRestoreRule;
    }

    /**
     * Returns true if the CrossRegionCopyRules property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCrossRegionCopyRules() {
        return crossRegionCopyRules != null && !(crossRegionCopyRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule for cross-Region snapshot copies.
     * </p>
     * <p>
     * You can only specify cross-Region copy rules for policies that create snapshots in a Region. If the policy
     * creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or to an Outpost. If the policy
     * creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCrossRegionCopyRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rule for cross-Region snapshot copies.</p>
     *         <p>
     *         You can only specify cross-Region copy rules for policies that create snapshots in a Region. If the
     *         policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or to an Outpost.
     *         If the policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or
     *         Outposts.
     */
    public final List<CrossRegionCopyRule> crossRegionCopyRules() {
        return crossRegionCopyRules;
    }

    /**
     * Returns true if the ShareRules property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasShareRules() {
        return shareRules != null && !(shareRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule for sharing snapshots with other AWS accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasShareRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rule for sharing snapshots with other AWS accounts.
     */
    public final List<ShareRule> shareRules() {
        return shareRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagsToAdd() ? tagsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVariableTags() ? variableTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createRule());
        hashCode = 31 * hashCode + Objects.hashCode(retainRule());
        hashCode = 31 * hashCode + Objects.hashCode(fastRestoreRule());
        hashCode = 31 * hashCode + Objects.hashCode(hasCrossRegionCopyRules() ? crossRegionCopyRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasShareRules() ? shareRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(copyTags(), other.copyTags())
                && hasTagsToAdd() == other.hasTagsToAdd() && Objects.equals(tagsToAdd(), other.tagsToAdd())
                && hasVariableTags() == other.hasVariableTags() && Objects.equals(variableTags(), other.variableTags())
                && Objects.equals(createRule(), other.createRule()) && Objects.equals(retainRule(), other.retainRule())
                && Objects.equals(fastRestoreRule(), other.fastRestoreRule())
                && hasCrossRegionCopyRules() == other.hasCrossRegionCopyRules()
                && Objects.equals(crossRegionCopyRules(), other.crossRegionCopyRules())
                && hasShareRules() == other.hasShareRules() && Objects.equals(shareRules(), other.shareRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Schedule").add("Name", name()).add("CopyTags", copyTags())
                .add("TagsToAdd", hasTagsToAdd() ? tagsToAdd() : null)
                .add("VariableTags", hasVariableTags() ? variableTags() : null).add("CreateRule", createRule())
                .add("RetainRule", retainRule()).add("FastRestoreRule", fastRestoreRule())
                .add("CrossRegionCopyRules", hasCrossRegionCopyRules() ? crossRegionCopyRules() : null)
                .add("ShareRules", hasShareRules() ? shareRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CopyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "TagsToAdd":
            return Optional.ofNullable(clazz.cast(tagsToAdd()));
        case "VariableTags":
            return Optional.ofNullable(clazz.cast(variableTags()));
        case "CreateRule":
            return Optional.ofNullable(clazz.cast(createRule()));
        case "RetainRule":
            return Optional.ofNullable(clazz.cast(retainRule()));
        case "FastRestoreRule":
            return Optional.ofNullable(clazz.cast(fastRestoreRule()));
        case "CrossRegionCopyRules":
            return Optional.ofNullable(clazz.cast(crossRegionCopyRules()));
        case "ShareRules":
            return Optional.ofNullable(clazz.cast(shareRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Schedule> {
        /**
         * <p>
         * The name of the schedule.
         * </p>
         * 
         * @param name
         *        The name of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
         * </p>
         * 
         * @param copyTags
         *        Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * The tags to apply to policy-created resources. These user-defined tags are in addition to the AWS-added
         * lifecycle tags.
         * </p>
         * 
         * @param tagsToAdd
         *        The tags to apply to policy-created resources. These user-defined tags are in addition to the
         *        AWS-added lifecycle tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToAdd(Collection<Tag> tagsToAdd);

        /**
         * <p>
         * The tags to apply to policy-created resources. These user-defined tags are in addition to the AWS-added
         * lifecycle tags.
         * </p>
         * 
         * @param tagsToAdd
         *        The tags to apply to policy-created resources. These user-defined tags are in addition to the
         *        AWS-added lifecycle tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToAdd(Tag... tagsToAdd);

        /**
         * <p>
         * The tags to apply to policy-created resources. These user-defined tags are in addition to the AWS-added
         * lifecycle tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tagsToAdd(List<Tag>)}.
         * 
         * @param tagsToAdd
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagsToAdd(List<Tag>)
         */
        Builder tagsToAdd(Consumer<Tag.Builder>... tagsToAdd);

        /**
         * <p>
         * A collection of key/value pairs with values determined dynamically when the policy is executed. Keys may be
         * any valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code>
         * or <code>$(timestamp)</code>. Variable tags are only valid for EBS Snapshot Management – Instance policies.
         * </p>
         * 
         * @param variableTags
         *        A collection of key/value pairs with values determined dynamically when the policy is executed. Keys
         *        may be any valid Amazon EC2 tag key. Values must be in one of the two following formats:
         *        <code>$(instance-id)</code> or <code>$(timestamp)</code>. Variable tags are only valid for EBS
         *        Snapshot Management – Instance policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableTags(Collection<Tag> variableTags);

        /**
         * <p>
         * A collection of key/value pairs with values determined dynamically when the policy is executed. Keys may be
         * any valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code>
         * or <code>$(timestamp)</code>. Variable tags are only valid for EBS Snapshot Management – Instance policies.
         * </p>
         * 
         * @param variableTags
         *        A collection of key/value pairs with values determined dynamically when the policy is executed. Keys
         *        may be any valid Amazon EC2 tag key. Values must be in one of the two following formats:
         *        <code>$(instance-id)</code> or <code>$(timestamp)</code>. Variable tags are only valid for EBS
         *        Snapshot Management – Instance policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableTags(Tag... variableTags);

        /**
         * <p>
         * A collection of key/value pairs with values determined dynamically when the policy is executed. Keys may be
         * any valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code>
         * or <code>$(timestamp)</code>. Variable tags are only valid for EBS Snapshot Management – Instance policies.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #variableTags(List<Tag>)}.
         * 
         * @param variableTags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variableTags(List<Tag>)
         */
        Builder variableTags(Consumer<Tag.Builder>... variableTags);

        /**
         * <p>
         * The creation rule.
         * </p>
         * 
         * @param createRule
         *        The creation rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createRule(CreateRule createRule);

        /**
         * <p>
         * The creation rule.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateRule.Builder} avoiding the need to create
         * one manually via {@link CreateRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateRule.Builder#build()} is called immediately and its result
         * is passed to {@link #createRule(CreateRule)}.
         * 
         * @param createRule
         *        a consumer that will call methods on {@link CreateRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createRule(CreateRule)
         */
        default Builder createRule(Consumer<CreateRule.Builder> createRule) {
            return createRule(CreateRule.builder().applyMutation(createRule).build());
        }

        /**
         * <p>
         * The retention rule.
         * </p>
         * 
         * @param retainRule
         *        The retention rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainRule(RetainRule retainRule);

        /**
         * <p>
         * The retention rule.
         * </p>
         * This is a convenience that creates an instance of the {@link RetainRule.Builder} avoiding the need to create
         * one manually via {@link RetainRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetainRule.Builder#build()} is called immediately and its result
         * is passed to {@link #retainRule(RetainRule)}.
         * 
         * @param retainRule
         *        a consumer that will call methods on {@link RetainRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retainRule(RetainRule)
         */
        default Builder retainRule(Consumer<RetainRule.Builder> retainRule) {
            return retainRule(RetainRule.builder().applyMutation(retainRule).build());
        }

        /**
         * <p>
         * The rule for enabling fast snapshot restore.
         * </p>
         * 
         * @param fastRestoreRule
         *        The rule for enabling fast snapshot restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fastRestoreRule(FastRestoreRule fastRestoreRule);

        /**
         * <p>
         * The rule for enabling fast snapshot restore.
         * </p>
         * This is a convenience that creates an instance of the {@link FastRestoreRule.Builder} avoiding the need to
         * create one manually via {@link FastRestoreRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link FastRestoreRule.Builder#build()} is called immediately and its
         * result is passed to {@link #fastRestoreRule(FastRestoreRule)}.
         * 
         * @param fastRestoreRule
         *        a consumer that will call methods on {@link FastRestoreRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fastRestoreRule(FastRestoreRule)
         */
        default Builder fastRestoreRule(Consumer<FastRestoreRule.Builder> fastRestoreRule) {
            return fastRestoreRule(FastRestoreRule.builder().applyMutation(fastRestoreRule).build());
        }

        /**
         * <p>
         * The rule for cross-Region snapshot copies.
         * </p>
         * <p>
         * You can only specify cross-Region copy rules for policies that create snapshots in a Region. If the policy
         * creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or to an Outpost. If the
         * policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
         * </p>
         * 
         * @param crossRegionCopyRules
         *        The rule for cross-Region snapshot copies.</p>
         *        <p>
         *        You can only specify cross-Region copy rules for policies that create snapshots in a Region. If the
         *        policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or to an
         *        Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three
         *        Regions or Outposts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionCopyRules(Collection<CrossRegionCopyRule> crossRegionCopyRules);

        /**
         * <p>
         * The rule for cross-Region snapshot copies.
         * </p>
         * <p>
         * You can only specify cross-Region copy rules for policies that create snapshots in a Region. If the policy
         * creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or to an Outpost. If the
         * policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
         * </p>
         * 
         * @param crossRegionCopyRules
         *        The rule for cross-Region snapshot copies.</p>
         *        <p>
         *        You can only specify cross-Region copy rules for policies that create snapshots in a Region. If the
         *        policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or to an
         *        Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three
         *        Regions or Outposts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionCopyRules(CrossRegionCopyRule... crossRegionCopyRules);

        /**
         * <p>
         * The rule for cross-Region snapshot copies.
         * </p>
         * <p>
         * You can only specify cross-Region copy rules for policies that create snapshots in a Region. If the policy
         * creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or to an Outpost. If the
         * policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CrossRegionCopyRule>.Builder} avoiding the
         * need to create one manually via {@link List<CrossRegionCopyRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CrossRegionCopyRule>.Builder#build()} is called immediately
         * and its result is passed to {@link #crossRegionCopyRules(List<CrossRegionCopyRule>)}.
         * 
         * @param crossRegionCopyRules
         *        a consumer that will call methods on {@link List<CrossRegionCopyRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossRegionCopyRules(List<CrossRegionCopyRule>)
         */
        Builder crossRegionCopyRules(Consumer<CrossRegionCopyRule.Builder>... crossRegionCopyRules);

        /**
         * <p>
         * The rule for sharing snapshots with other AWS accounts.
         * </p>
         * 
         * @param shareRules
         *        The rule for sharing snapshots with other AWS accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareRules(Collection<ShareRule> shareRules);

        /**
         * <p>
         * The rule for sharing snapshots with other AWS accounts.
         * </p>
         * 
         * @param shareRules
         *        The rule for sharing snapshots with other AWS accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareRules(ShareRule... shareRules);

        /**
         * <p>
         * The rule for sharing snapshots with other AWS accounts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ShareRule>.Builder} avoiding the need to
         * create one manually via {@link List<ShareRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ShareRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #shareRules(List<ShareRule>)}.
         * 
         * @param shareRules
         *        a consumer that will call methods on {@link List<ShareRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shareRules(List<ShareRule>)
         */
        Builder shareRules(Consumer<ShareRule.Builder>... shareRules);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Boolean copyTags;

        private List<Tag> tagsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> variableTags = DefaultSdkAutoConstructList.getInstance();

        private CreateRule createRule;

        private RetainRule retainRule;

        private FastRestoreRule fastRestoreRule;

        private List<CrossRegionCopyRule> crossRegionCopyRules = DefaultSdkAutoConstructList.getInstance();

        private List<ShareRule> shareRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            name(model.name);
            copyTags(model.copyTags);
            tagsToAdd(model.tagsToAdd);
            variableTags(model.variableTags);
            createRule(model.createRule);
            retainRule(model.retainRule);
            fastRestoreRule(model.fastRestoreRule);
            crossRegionCopyRules(model.crossRegionCopyRules);
            shareRules(model.shareRules);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        public final List<Tag.Builder> getTagsToAdd() {
            List<Tag.Builder> result = TagsToAddListCopier.copyToBuilder(this.tagsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagsToAdd(Collection<Tag> tagsToAdd) {
            this.tagsToAdd = TagsToAddListCopier.copy(tagsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(Tag... tagsToAdd) {
            tagsToAdd(Arrays.asList(tagsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(Consumer<Tag.Builder>... tagsToAdd) {
            tagsToAdd(Stream.of(tagsToAdd).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagsToAdd(Collection<Tag.BuilderImpl> tagsToAdd) {
            this.tagsToAdd = TagsToAddListCopier.copyFromBuilder(tagsToAdd);
        }

        public final List<Tag.Builder> getVariableTags() {
            List<Tag.Builder> result = VariableTagsListCopier.copyToBuilder(this.variableTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder variableTags(Collection<Tag> variableTags) {
            this.variableTags = VariableTagsListCopier.copy(variableTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableTags(Tag... variableTags) {
            variableTags(Arrays.asList(variableTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableTags(Consumer<Tag.Builder>... variableTags) {
            variableTags(Stream.of(variableTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVariableTags(Collection<Tag.BuilderImpl> variableTags) {
            this.variableTags = VariableTagsListCopier.copyFromBuilder(variableTags);
        }

        public final CreateRule.Builder getCreateRule() {
            return createRule != null ? createRule.toBuilder() : null;
        }

        @Override
        public final Builder createRule(CreateRule createRule) {
            this.createRule = createRule;
            return this;
        }

        public final void setCreateRule(CreateRule.BuilderImpl createRule) {
            this.createRule = createRule != null ? createRule.build() : null;
        }

        public final RetainRule.Builder getRetainRule() {
            return retainRule != null ? retainRule.toBuilder() : null;
        }

        @Override
        public final Builder retainRule(RetainRule retainRule) {
            this.retainRule = retainRule;
            return this;
        }

        public final void setRetainRule(RetainRule.BuilderImpl retainRule) {
            this.retainRule = retainRule != null ? retainRule.build() : null;
        }

        public final FastRestoreRule.Builder getFastRestoreRule() {
            return fastRestoreRule != null ? fastRestoreRule.toBuilder() : null;
        }

        @Override
        public final Builder fastRestoreRule(FastRestoreRule fastRestoreRule) {
            this.fastRestoreRule = fastRestoreRule;
            return this;
        }

        public final void setFastRestoreRule(FastRestoreRule.BuilderImpl fastRestoreRule) {
            this.fastRestoreRule = fastRestoreRule != null ? fastRestoreRule.build() : null;
        }

        public final List<CrossRegionCopyRule.Builder> getCrossRegionCopyRules() {
            List<CrossRegionCopyRule.Builder> result = CrossRegionCopyRulesCopier.copyToBuilder(this.crossRegionCopyRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder crossRegionCopyRules(Collection<CrossRegionCopyRule> crossRegionCopyRules) {
            this.crossRegionCopyRules = CrossRegionCopyRulesCopier.copy(crossRegionCopyRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyRules(CrossRegionCopyRule... crossRegionCopyRules) {
            crossRegionCopyRules(Arrays.asList(crossRegionCopyRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyRules(Consumer<CrossRegionCopyRule.Builder>... crossRegionCopyRules) {
            crossRegionCopyRules(Stream.of(crossRegionCopyRules).map(c -> CrossRegionCopyRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCrossRegionCopyRules(Collection<CrossRegionCopyRule.BuilderImpl> crossRegionCopyRules) {
            this.crossRegionCopyRules = CrossRegionCopyRulesCopier.copyFromBuilder(crossRegionCopyRules);
        }

        public final List<ShareRule.Builder> getShareRules() {
            List<ShareRule.Builder> result = ShareRulesCopier.copyToBuilder(this.shareRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder shareRules(Collection<ShareRule> shareRules) {
            this.shareRules = ShareRulesCopier.copy(shareRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareRules(ShareRule... shareRules) {
            shareRules(Arrays.asList(shareRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareRules(Consumer<ShareRule.Builder>... shareRules) {
            shareRules(Stream.of(shareRules).map(c -> ShareRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setShareRules(Collection<ShareRule.BuilderImpl> shareRules) {
            this.shareRules = ShareRulesCopier.copyFromBuilder(shareRules);
        }

        @Override
        public Schedule build() {
            return new Schedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
