/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a rule for copying shared snapshots across Regions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrossRegionCopyAction implements SdkPojo, Serializable,
        ToCopyableBuilder<CrossRegionCopyAction.Builder, CrossRegionCopyAction> {
    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(CrossRegionCopyAction::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(CrossRegionCopyAction::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<CrossRegionCopyRetainRule> RETAIN_RULE_FIELD = SdkField
            .<CrossRegionCopyRetainRule> builder(MarshallingType.SDK_POJO).memberName("RetainRule")
            .getter(getter(CrossRegionCopyAction::retainRule)).setter(setter(Builder::retainRule))
            .constructor(CrossRegionCopyRetainRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, RETAIN_RULE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String target;

    private final EncryptionConfiguration encryptionConfiguration;

    private final CrossRegionCopyRetainRule retainRule;

    private CrossRegionCopyAction(BuilderImpl builder) {
        this.target = builder.target;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.retainRule = builder.retainRule;
    }

    /**
     * <p>
     * The target Region.
     * </p>
     * 
     * @return The target Region.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The encryption settings for the copied snapshot.
     * </p>
     * 
     * @return The encryption settings for the copied snapshot.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * Returns the value of the RetainRule property for this object.
     * 
     * @return The value of the RetainRule property for this object.
     */
    public final CrossRegionCopyRetainRule retainRule() {
        return retainRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(retainRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossRegionCopyAction)) {
            return false;
        }
        CrossRegionCopyAction other = (CrossRegionCopyAction) obj;
        return Objects.equals(target(), other.target())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(retainRule(), other.retainRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrossRegionCopyAction").add("Target", target())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("RetainRule", retainRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "RetainRule":
            return Optional.ofNullable(clazz.cast(retainRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrossRegionCopyAction, T> g) {
        return obj -> g.apply((CrossRegionCopyAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrossRegionCopyAction> {
        /**
         * <p>
         * The target Region.
         * </p>
         * 
         * @param target
         *        The target Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The encryption settings for the copied snapshot.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption settings for the copied snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption settings for the copied snapshot.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * Sets the value of the RetainRule property for this object.
         *
         * @param retainRule
         *        The new value for the RetainRule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainRule(CrossRegionCopyRetainRule retainRule);

        /**
         * Sets the value of the RetainRule property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CrossRegionCopyRetainRule.Builder}
         * avoiding the need to create one manually via {@link CrossRegionCopyRetainRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link CrossRegionCopyRetainRule.Builder#build()} is called immediately
         * and its result is passed to {@link #retainRule(CrossRegionCopyRetainRule)}.
         * 
         * @param retainRule
         *        a consumer that will call methods on {@link CrossRegionCopyRetainRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retainRule(CrossRegionCopyRetainRule)
         */
        default Builder retainRule(Consumer<CrossRegionCopyRetainRule.Builder> retainRule) {
            return retainRule(CrossRegionCopyRetainRule.builder().applyMutation(retainRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String target;

        private EncryptionConfiguration encryptionConfiguration;

        private CrossRegionCopyRetainRule retainRule;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossRegionCopyAction model) {
            target(model.target);
            encryptionConfiguration(model.encryptionConfiguration);
            retainRule(model.retainRule);
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final CrossRegionCopyRetainRule.Builder getRetainRule() {
            return retainRule != null ? retainRule.toBuilder() : null;
        }

        public final void setRetainRule(CrossRegionCopyRetainRule.BuilderImpl retainRule) {
            this.retainRule = retainRule != null ? retainRule.build() : null;
        }

        @Override
        public final Builder retainRule(CrossRegionCopyRetainRule retainRule) {
            this.retainRule = retainRule;
            return this;
        }

        @Override
        public CrossRegionCopyAction build() {
            return new CrossRegionCopyAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
