/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the encryption settings for shared snapshots that are copied across Regions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionConfiguration.Builder, EncryptionConfiguration> {
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(EncryptionConfiguration::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> CMK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CmkArn")
            .getter(getter(EncryptionConfiguration::cmkArn)).setter(setter(Builder::cmkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CmkArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENCRYPTED_FIELD, CMK_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean encrypted;

    private final String cmkArn;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.encrypted = builder.encrypted;
        this.cmkArn = builder.cmkArn;
    }

    /**
     * <p>
     * To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using
     * this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption
     * by default is not enabled.
     * </p>
     * 
     * @return To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption
     *         using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or
     *         when encryption by default is not enabled.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not specified, the
     * default KMS key for the account is used.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not
     *         specified, the default KMS key for the account is used.
     */
    public final String cmkArn() {
        return cmkArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(cmkArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration) obj;
        return Objects.equals(encrypted(), other.encrypted()) && Objects.equals(cmkArn(), other.cmkArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionConfiguration").add("Encrypted", encrypted()).add("CmkArn", cmkArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "CmkArn":
            return Optional.ofNullable(clazz.cast(cmkArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfiguration, T> g) {
        return obj -> g.apply((EncryptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionConfiguration> {
        /**
         * <p>
         * To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption
         * using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or when
         * encryption by default is not enabled.
         * </p>
         * 
         * @param encrypted
         *        To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable
         *        encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter
         *        is false or when encryption by default is not enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not specified,
         * the default KMS key for the account is used.
         * </p>
         * 
         * @param cmkArn
         *        The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not
         *        specified, the default KMS key for the account is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cmkArn(String cmkArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean encrypted;

        private String cmkArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            encrypted(model.encrypted);
            cmkArn(model.cmkArn);
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getCmkArn() {
            return cmkArn;
        }

        public final void setCmkArn(String cmkArn) {
            this.cmkArn = cmkArn;
        }

        @Override
        public final Builder cmkArn(String cmkArn) {
            this.cmkArn = cmkArn;
            return this;
        }

        @Override
        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
