/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>[Event-based policies only]</b> Specifies an action for an event-based policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Action::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<CrossRegionCopyAction>> CROSS_REGION_COPY_FIELD = SdkField
            .<List<CrossRegionCopyAction>> builder(MarshallingType.LIST)
            .memberName("CrossRegionCopy")
            .getter(getter(Action::crossRegionCopy))
            .setter(setter(Builder::crossRegionCopy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRegionCopy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CrossRegionCopyAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(CrossRegionCopyAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CROSS_REGION_COPY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<CrossRegionCopyAction> crossRegionCopy;

    private Action(BuilderImpl builder) {
        this.name = builder.name;
        this.crossRegionCopy = builder.crossRegionCopy;
    }

    /**
     * <p>
     * A descriptive name for the action.
     * </p>
     * 
     * @return A descriptive name for the action.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossRegionCopy property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCrossRegionCopy() {
        return crossRegionCopy != null && !(crossRegionCopy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule for copying shared snapshots across Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossRegionCopy} method.
     * </p>
     * 
     * @return The rule for copying shared snapshots across Regions.
     */
    public final List<CrossRegionCopyAction> crossRegionCopy() {
        return crossRegionCopy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasCrossRegionCopy() ? crossRegionCopy() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(name(), other.name()) && hasCrossRegionCopy() == other.hasCrossRegionCopy()
                && Objects.equals(crossRegionCopy(), other.crossRegionCopy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("Name", name())
                .add("CrossRegionCopy", hasCrossRegionCopy() ? crossRegionCopy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CrossRegionCopy":
            return Optional.ofNullable(clazz.cast(crossRegionCopy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * A descriptive name for the action.
         * </p>
         * 
         * @param name
         *        A descriptive name for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The rule for copying shared snapshots across Regions.
         * </p>
         * 
         * @param crossRegionCopy
         *        The rule for copying shared snapshots across Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionCopy(Collection<CrossRegionCopyAction> crossRegionCopy);

        /**
         * <p>
         * The rule for copying shared snapshots across Regions.
         * </p>
         * 
         * @param crossRegionCopy
         *        The rule for copying shared snapshots across Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionCopy(CrossRegionCopyAction... crossRegionCopy);

        /**
         * <p>
         * The rule for copying shared snapshots across Regions.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CrossRegionCopyAction>.Builder}
         * avoiding the need to create one manually via {@link List<CrossRegionCopyAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CrossRegionCopyAction>.Builder#build()} is called
         * immediately and its result is passed to {@link #crossRegionCopy(List<CrossRegionCopyAction>)}.
         * 
         * @param crossRegionCopy
         *        a consumer that will call methods on {@link List<CrossRegionCopyAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossRegionCopy(List<CrossRegionCopyAction>)
         */
        Builder crossRegionCopy(Consumer<CrossRegionCopyAction.Builder>... crossRegionCopy);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<CrossRegionCopyAction> crossRegionCopy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            name(model.name);
            crossRegionCopy(model.crossRegionCopy);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<CrossRegionCopyAction.Builder> getCrossRegionCopy() {
            List<CrossRegionCopyAction.Builder> result = CrossRegionCopyActionListCopier.copyToBuilder(this.crossRegionCopy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossRegionCopy(Collection<CrossRegionCopyAction.BuilderImpl> crossRegionCopy) {
            this.crossRegionCopy = CrossRegionCopyActionListCopier.copyFromBuilder(crossRegionCopy);
        }

        @Override
        public final Builder crossRegionCopy(Collection<CrossRegionCopyAction> crossRegionCopy) {
            this.crossRegionCopy = CrossRegionCopyActionListCopier.copy(crossRegionCopy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopy(CrossRegionCopyAction... crossRegionCopy) {
            crossRegionCopy(Arrays.asList(crossRegionCopy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopy(Consumer<CrossRegionCopyAction.Builder>... crossRegionCopy) {
            crossRegionCopy(Stream.of(crossRegionCopy).map(c -> CrossRegionCopyAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
