/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLifecyclePolicyRequest extends DlmRequest implements
        ToCopyableBuilder<CreateLifecyclePolicyRequest.Builder, CreateLifecyclePolicyRequest> {
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(CreateLifecyclePolicyRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateLifecyclePolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CreateLifecyclePolicyRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField
            .<PolicyDetails> builder(MarshallingType.SDK_POJO).memberName("PolicyDetails")
            .getter(getter(CreateLifecyclePolicyRequest::policyDetails)).setter(setter(Builder::policyDetails))
            .constructor(PolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDetails").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateLifecyclePolicyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_ARN_FIELD,
            DESCRIPTION_FIELD, STATE_FIELD, POLICY_DETAILS_FIELD, TAGS_FIELD));

    private final String executionRoleArn;

    private final String description;

    private final String state;

    private final PolicyDetails policyDetails;

    private final Map<String, String> tags;

    private CreateLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.executionRoleArn = builder.executionRoleArn;
        this.description = builder.description;
        this.state = builder.state;
        this.policyDetails = builder.policyDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle
     *         policy.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * A description of the lifecycle policy. The characters ^[0-9A-Za-z _-]+$ are supported.
     * </p>
     * 
     * @return A description of the lifecycle policy. The characters ^[0-9A-Za-z _-]+$ are supported.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The desired activation state of the lifecycle policy after creation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The desired activation state of the lifecycle policy after creation.
     * @see SettablePolicyStateValues
     */
    public final SettablePolicyStateValues state() {
        return SettablePolicyStateValues.fromValue(state);
    }

    /**
     * <p>
     * The desired activation state of the lifecycle policy after creation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The desired activation state of the lifecycle policy after creation.
     * @see SettablePolicyStateValues
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The configuration details of the lifecycle policy.
     * </p>
     * 
     * @return The configuration details of the lifecycle policy.
     */
    public final PolicyDetails policyDetails() {
        return policyDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to apply to the lifecycle policy during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to the lifecycle policy during creation.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLifecyclePolicyRequest)) {
            return false;
        }
        CreateLifecyclePolicyRequest other = (CreateLifecyclePolicyRequest) obj;
        return Objects.equals(executionRoleArn(), other.executionRoleArn()) && Objects.equals(description(), other.description())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(policyDetails(), other.policyDetails()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLifecyclePolicyRequest").add("ExecutionRoleArn", executionRoleArn())
                .add("Description", description()).add("State", stateAsString()).add("PolicyDetails", policyDetails())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "PolicyDetails":
            return Optional.ofNullable(clazz.cast(policyDetails()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((CreateLifecyclePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DlmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLifecyclePolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle
         *        policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * A description of the lifecycle policy. The characters ^[0-9A-Za-z _-]+$ are supported.
         * </p>
         * 
         * @param description
         *        A description of the lifecycle policy. The characters ^[0-9A-Za-z _-]+$ are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The desired activation state of the lifecycle policy after creation.
         * </p>
         * 
         * @param state
         *        The desired activation state of the lifecycle policy after creation.
         * @see SettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettablePolicyStateValues
         */
        Builder state(String state);

        /**
         * <p>
         * The desired activation state of the lifecycle policy after creation.
         * </p>
         * 
         * @param state
         *        The desired activation state of the lifecycle policy after creation.
         * @see SettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettablePolicyStateValues
         */
        Builder state(SettablePolicyStateValues state);

        /**
         * <p>
         * The configuration details of the lifecycle policy.
         * </p>
         * 
         * @param policyDetails
         *        The configuration details of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(PolicyDetails policyDetails);

        /**
         * <p>
         * The configuration details of the lifecycle policy.
         * </p>
         * This is a convenience that creates an instance of the {@link PolicyDetails.Builder} avoiding the need to
         * create one manually via {@link PolicyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link PolicyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #policyDetails(PolicyDetails)}.
         * 
         * @param policyDetails
         *        a consumer that will call methods on {@link PolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDetails(PolicyDetails)
         */
        default Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return policyDetails(PolicyDetails.builder().applyMutation(policyDetails).build());
        }

        /**
         * <p>
         * The tags to apply to the lifecycle policy during creation.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the lifecycle policy during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DlmRequest.BuilderImpl implements Builder {
        private String executionRoleArn;

        private String description;

        private String state;

        private PolicyDetails policyDetails;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLifecyclePolicyRequest model) {
            super(model);
            executionRoleArn(model.executionRoleArn);
            description(model.description);
            state(model.state);
            policyDetails(model.policyDetails);
            tags(model.tags);
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        @Transient
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(SettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return policyDetails != null ? policyDetails.toBuilder() : null;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLifecyclePolicyRequest build() {
            return new CreateLifecyclePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
