/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies optional parameters to add to a policy. The set of valid parameters depends on the combination of policy
 * type and resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameters implements SdkPojo, Serializable, ToCopyableBuilder<Parameters.Builder, Parameters> {
    private static final SdkField<Boolean> EXCLUDE_BOOT_VOLUME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeBootVolume").getter(getter(Parameters::excludeBootVolume))
            .setter(setter(Builder::excludeBootVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeBootVolume").build()).build();

    private static final SdkField<Boolean> NO_REBOOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoReboot").getter(getter(Parameters::noReboot)).setter(setter(Builder::noReboot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoReboot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDE_BOOT_VOLUME_FIELD,
            NO_REBOOT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean excludeBootVolume;

    private final Boolean noReboot;

    private Parameters(BuilderImpl builder) {
        this.excludeBootVolume = builder.excludeBootVolume;
        this.noReboot = builder.noReboot;
    }

    /**
     * <p>
     * [EBS Snapshot Management – Instance policies only] Indicates whether to exclude the root volume from snapshots
     * created using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html">CreateSnapshots</a>. The
     * default is false.
     * </p>
     * 
     * @return [EBS Snapshot Management – Instance policies only] Indicates whether to exclude the root volume from
     *         snapshots created using <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html"
     *         >CreateSnapshots</a>. The default is false.
     */
    public final Boolean excludeBootVolume() {
        return excludeBootVolume;
    }

    /**
     * <p>
     * Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle
     * policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy runs.
     * <code>false</code> indicates that target instances are rebooted when the policy runs. The default is
     * <code>true</code> (instances are not rebooted).
     * </p>
     * 
     * @return Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the
     *         lifecycle policy runs. <code>true</code> indicates that targeted instances are not rebooted when the
     *         policy runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The
     *         default is <code>true</code> (instances are not rebooted).
     */
    public final Boolean noReboot() {
        return noReboot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excludeBootVolume());
        hashCode = 31 * hashCode + Objects.hashCode(noReboot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters) obj;
        return Objects.equals(excludeBootVolume(), other.excludeBootVolume()) && Objects.equals(noReboot(), other.noReboot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Parameters").add("ExcludeBootVolume", excludeBootVolume()).add("NoReboot", noReboot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExcludeBootVolume":
            return Optional.ofNullable(clazz.cast(excludeBootVolume()));
        case "NoReboot":
            return Optional.ofNullable(clazz.cast(noReboot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parameters, T> g) {
        return obj -> g.apply((Parameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameters> {
        /**
         * <p>
         * [EBS Snapshot Management – Instance policies only] Indicates whether to exclude the root volume from
         * snapshots created using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html">CreateSnapshots</a>.
         * The default is false.
         * </p>
         * 
         * @param excludeBootVolume
         *        [EBS Snapshot Management – Instance policies only] Indicates whether to exclude the root volume from
         *        snapshots created using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html"
         *        >CreateSnapshots</a>. The default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeBootVolume(Boolean excludeBootVolume);

        /**
         * <p>
         * Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle
         * policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy runs.
         * <code>false</code> indicates that target instances are rebooted when the policy runs. The default is
         * <code>true</code> (instances are not rebooted).
         * </p>
         * 
         * @param noReboot
         *        Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the
         *        lifecycle policy runs. <code>true</code> indicates that targeted instances are not rebooted when the
         *        policy runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The
         *        default is <code>true</code> (instances are not rebooted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noReboot(Boolean noReboot);
    }

    static final class BuilderImpl implements Builder {
        private Boolean excludeBootVolume;

        private Boolean noReboot;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameters model) {
            excludeBootVolume(model.excludeBootVolume);
            noReboot(model.noReboot);
        }

        public final Boolean getExcludeBootVolume() {
            return excludeBootVolume;
        }

        public final void setExcludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
        }

        @Override
        @Transient
        public final Builder excludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
            return this;
        }

        public final Boolean getNoReboot() {
            return noReboot;
        }

        public final void setNoReboot(Boolean noReboot) {
            this.noReboot = noReboot;
        }

        @Override
        @Transient
        public final Builder noReboot(Boolean noReboot) {
            this.noReboot = noReboot;
            return this;
        }

        @Override
        public Parameters build() {
            return new Parameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
