/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a lifecycle policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicy implements SdkPojo, Serializable, ToCopyableBuilder<LifecyclePolicy.Builder, LifecyclePolicy> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::executionRoleArn)).setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LifecyclePolicy::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LifecyclePolicy::dateModified)).setter(setter(Builder::dateModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build()).build();

    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField
            .<PolicyDetails> builder(MarshallingType.SDK_POJO).getter(getter(LifecyclePolicy::policyDetails))
            .setter(setter(Builder::policyDetails)).constructor(PolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            DESCRIPTION_FIELD, STATE_FIELD, EXECUTION_ROLE_ARN_FIELD, DATE_CREATED_FIELD, DATE_MODIFIED_FIELD,
            POLICY_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyId;

    private final String description;

    private final String state;

    private final String executionRoleArn;

    private final Instant dateCreated;

    private final Instant dateModified;

    private final PolicyDetails policyDetails;

    private LifecyclePolicy(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.description = builder.description;
        this.state = builder.state;
        this.executionRoleArn = builder.executionRoleArn;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
        this.policyDetails = builder.policyDetails;
    }

    /**
     * <p>
     * The identifier of the lifecycle policy.
     * </p>
     * 
     * @return The identifier of the lifecycle policy.
     */
    public String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The description of the lifecycle policy.
     * </p>
     * 
     * @return The description of the lifecycle policy.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The activation state of the lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link GettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The activation state of the lifecycle policy.
     * @see GettablePolicyStateValues
     */
    public GettablePolicyStateValues state() {
        return GettablePolicyStateValues.fromValue(state);
    }

    /**
     * <p>
     * The activation state of the lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link GettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The activation state of the lifecycle policy.
     * @see GettablePolicyStateValues
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle
     *         policy.
     */
    public String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The local date and time when the lifecycle policy was created.
     * </p>
     * 
     * @return The local date and time when the lifecycle policy was created.
     */
    public Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The local date and time when the lifecycle policy was last modified.
     * </p>
     * 
     * @return The local date and time when the lifecycle policy was last modified.
     */
    public Instant dateModified() {
        return dateModified;
    }

    /**
     * <p>
     * The configuration of the lifecycle policy
     * </p>
     * 
     * @return The configuration of the lifecycle policy
     */
    public PolicyDetails policyDetails() {
        return policyDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateModified());
        hashCode = 31 * hashCode + Objects.hashCode(policyDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicy)) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(description(), other.description())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateModified(), other.dateModified())
                && Objects.equals(policyDetails(), other.policyDetails());
    }

    @Override
    public String toString() {
        return ToString.builder("LifecyclePolicy").add("PolicyId", policyId()).add("Description", description())
                .add("State", stateAsString()).add("ExecutionRoleArn", executionRoleArn()).add("DateCreated", dateCreated())
                .add("DateModified", dateModified()).add("PolicyDetails", policyDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateModified":
            return Optional.ofNullable(clazz.cast(dateModified()));
        case "PolicyDetails":
            return Optional.ofNullable(clazz.cast(policyDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicy, T> g) {
        return obj -> g.apply((LifecyclePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicy> {
        /**
         * <p>
         * The identifier of the lifecycle policy.
         * </p>
         * 
         * @param policyId
         *        The identifier of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The description of the lifecycle policy.
         * </p>
         * 
         * @param description
         *        The description of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The activation state of the lifecycle policy.
         * </p>
         * 
         * @param state
         *        The activation state of the lifecycle policy.
         * @see GettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GettablePolicyStateValues
         */
        Builder state(String state);

        /**
         * <p>
         * The activation state of the lifecycle policy.
         * </p>
         * 
         * @param state
         *        The activation state of the lifecycle policy.
         * @see GettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GettablePolicyStateValues
         */
        Builder state(GettablePolicyStateValues state);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle
         *        policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The local date and time when the lifecycle policy was created.
         * </p>
         * 
         * @param dateCreated
         *        The local date and time when the lifecycle policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The local date and time when the lifecycle policy was last modified.
         * </p>
         * 
         * @param dateModified
         *        The local date and time when the lifecycle policy was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateModified(Instant dateModified);

        /**
         * <p>
         * The configuration of the lifecycle policy
         * </p>
         * 
         * @param policyDetails
         *        The configuration of the lifecycle policy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(PolicyDetails policyDetails);

        /**
         * <p>
         * The configuration of the lifecycle policy
         * </p>
         * This is a convenience that creates an instance of the {@link PolicyDetails.Builder} avoiding the need to
         * create one manually via {@link PolicyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link PolicyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #policyDetails(PolicyDetails)}.
         * 
         * @param policyDetails
         *        a consumer that will call methods on {@link PolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDetails(PolicyDetails)
         */
        default Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return policyDetails(PolicyDetails.builder().applyMutation(policyDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String policyId;

        private String description;

        private String state;

        private String executionRoleArn;

        private Instant dateCreated;

        private Instant dateModified;

        private PolicyDetails policyDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicy model) {
            policyId(model.policyId);
            description(model.description);
            state(model.state);
            executionRoleArn(model.executionRoleArn);
            dateCreated(model.dateCreated);
            dateModified(model.dateModified);
            policyDetails(model.policyDetails);
        }

        public final String getPolicyId() {
            return policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(GettablePolicyStateValues state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateModified() {
            return dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return policyDetails != null ? policyDetails.toBuilder() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        @Override
        public LifecyclePolicy build() {
            return new LifecyclePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
