/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>[Snapshot policies only]</b> Specifies a rule for sharing snapshots across Amazon Web Services accounts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShareRule implements SdkPojo, Serializable, ToCopyableBuilder<ShareRule.Builder, ShareRule> {
    private static final SdkField<List<String>> TARGET_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetAccounts")
            .getter(getter(ShareRule::targetAccounts))
            .setter(setter(Builder::targetAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> UNSHARE_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UnshareInterval").getter(getter(ShareRule::unshareInterval)).setter(setter(Builder::unshareInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnshareInterval").build()).build();

    private static final SdkField<String> UNSHARE_INTERVAL_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnshareIntervalUnit").getter(getter(ShareRule::unshareIntervalUnitAsString))
            .setter(setter(Builder::unshareIntervalUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnshareIntervalUnit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ACCOUNTS_FIELD,
            UNSHARE_INTERVAL_FIELD, UNSHARE_INTERVAL_UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> targetAccounts;

    private final Integer unshareInterval;

    private final String unshareIntervalUnit;

    private ShareRule(BuilderImpl builder) {
        this.targetAccounts = builder.targetAccounts;
        this.unshareInterval = builder.unshareInterval;
        this.unshareIntervalUnit = builder.unshareIntervalUnit;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetAccounts() {
        return targetAccounts != null && !(targetAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Amazon Web Services accounts with which to share the snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetAccounts} method.
     * </p>
     * 
     * @return The IDs of the Amazon Web Services accounts with which to share the snapshots.
     */
    public final List<String> targetAccounts() {
        return targetAccounts;
    }

    /**
     * <p>
     * The period after which snapshots that are shared with other Amazon Web Services accounts are automatically
     * unshared.
     * </p>
     * 
     * @return The period after which snapshots that are shared with other Amazon Web Services accounts are
     *         automatically unshared.
     */
    public final Integer unshareInterval() {
        return unshareInterval;
    }

    /**
     * <p>
     * The unit of time for the automatic unsharing interval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unshareIntervalUnit} will return {@link RetentionIntervalUnitValues#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #unshareIntervalUnitAsString}.
     * </p>
     * 
     * @return The unit of time for the automatic unsharing interval.
     * @see RetentionIntervalUnitValues
     */
    public final RetentionIntervalUnitValues unshareIntervalUnit() {
        return RetentionIntervalUnitValues.fromValue(unshareIntervalUnit);
    }

    /**
     * <p>
     * The unit of time for the automatic unsharing interval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unshareIntervalUnit} will return {@link RetentionIntervalUnitValues#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #unshareIntervalUnitAsString}.
     * </p>
     * 
     * @return The unit of time for the automatic unsharing interval.
     * @see RetentionIntervalUnitValues
     */
    public final String unshareIntervalUnitAsString() {
        return unshareIntervalUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetAccounts() ? targetAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(unshareInterval());
        hashCode = 31 * hashCode + Objects.hashCode(unshareIntervalUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareRule)) {
            return false;
        }
        ShareRule other = (ShareRule) obj;
        return hasTargetAccounts() == other.hasTargetAccounts() && Objects.equals(targetAccounts(), other.targetAccounts())
                && Objects.equals(unshareInterval(), other.unshareInterval())
                && Objects.equals(unshareIntervalUnitAsString(), other.unshareIntervalUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShareRule").add("TargetAccounts", hasTargetAccounts() ? targetAccounts() : null)
                .add("UnshareInterval", unshareInterval()).add("UnshareIntervalUnit", unshareIntervalUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetAccounts":
            return Optional.ofNullable(clazz.cast(targetAccounts()));
        case "UnshareInterval":
            return Optional.ofNullable(clazz.cast(unshareInterval()));
        case "UnshareIntervalUnit":
            return Optional.ofNullable(clazz.cast(unshareIntervalUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShareRule, T> g) {
        return obj -> g.apply((ShareRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShareRule> {
        /**
         * <p>
         * The IDs of the Amazon Web Services accounts with which to share the snapshots.
         * </p>
         * 
         * @param targetAccounts
         *        The IDs of the Amazon Web Services accounts with which to share the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccounts(Collection<String> targetAccounts);

        /**
         * <p>
         * The IDs of the Amazon Web Services accounts with which to share the snapshots.
         * </p>
         * 
         * @param targetAccounts
         *        The IDs of the Amazon Web Services accounts with which to share the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccounts(String... targetAccounts);

        /**
         * <p>
         * The period after which snapshots that are shared with other Amazon Web Services accounts are automatically
         * unshared.
         * </p>
         * 
         * @param unshareInterval
         *        The period after which snapshots that are shared with other Amazon Web Services accounts are
         *        automatically unshared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unshareInterval(Integer unshareInterval);

        /**
         * <p>
         * The unit of time for the automatic unsharing interval.
         * </p>
         * 
         * @param unshareIntervalUnit
         *        The unit of time for the automatic unsharing interval.
         * @see RetentionIntervalUnitValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionIntervalUnitValues
         */
        Builder unshareIntervalUnit(String unshareIntervalUnit);

        /**
         * <p>
         * The unit of time for the automatic unsharing interval.
         * </p>
         * 
         * @param unshareIntervalUnit
         *        The unit of time for the automatic unsharing interval.
         * @see RetentionIntervalUnitValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionIntervalUnitValues
         */
        Builder unshareIntervalUnit(RetentionIntervalUnitValues unshareIntervalUnit);
    }

    static final class BuilderImpl implements Builder {
        private List<String> targetAccounts = DefaultSdkAutoConstructList.getInstance();

        private Integer unshareInterval;

        private String unshareIntervalUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareRule model) {
            targetAccounts(model.targetAccounts);
            unshareInterval(model.unshareInterval);
            unshareIntervalUnit(model.unshareIntervalUnit);
        }

        public final Collection<String> getTargetAccounts() {
            if (targetAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return targetAccounts;
        }

        public final void setTargetAccounts(Collection<String> targetAccounts) {
            this.targetAccounts = ShareTargetAccountListCopier.copy(targetAccounts);
        }

        @Override
        public final Builder targetAccounts(Collection<String> targetAccounts) {
            this.targetAccounts = ShareTargetAccountListCopier.copy(targetAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccounts(String... targetAccounts) {
            targetAccounts(Arrays.asList(targetAccounts));
            return this;
        }

        public final Integer getUnshareInterval() {
            return unshareInterval;
        }

        public final void setUnshareInterval(Integer unshareInterval) {
            this.unshareInterval = unshareInterval;
        }

        @Override
        public final Builder unshareInterval(Integer unshareInterval) {
            this.unshareInterval = unshareInterval;
            return this;
        }

        public final String getUnshareIntervalUnit() {
            return unshareIntervalUnit;
        }

        public final void setUnshareIntervalUnit(String unshareIntervalUnit) {
            this.unshareIntervalUnit = unshareIntervalUnit;
        }

        @Override
        public final Builder unshareIntervalUnit(String unshareIntervalUnit) {
            this.unshareIntervalUnit = unshareIntervalUnit;
            return this;
        }

        @Override
        public final Builder unshareIntervalUnit(RetentionIntervalUnitValues unshareIntervalUnit) {
            this.unshareIntervalUnit(unshareIntervalUnit == null ? null : unshareIntervalUnit.toString());
            return this;
        }

        @Override
        public ShareRule build() {
            return new ShareRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
