/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>[Custom snapshot and AMI policies only]</b> Specifies optional parameters for snapshot and AMI policies. The set
 * of valid parameters depends on the combination of policy type and target resource type.
 * </p>
 * <p>
 * If you choose to exclude boot volumes and you specify tags that consequently exclude all of the additional data
 * volumes attached to an instance, then Amazon Data Lifecycle Manager will not create any snapshots for the affected
 * instance, and it will emit a <code>SnapshotsCreateFailed</code> Amazon CloudWatch metric. For more information, see
 * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitor-dlm-cw-metrics.html">Monitor your policies using
 * Amazon CloudWatch</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameters implements SdkPojo, Serializable, ToCopyableBuilder<Parameters.Builder, Parameters> {
    private static final SdkField<Boolean> EXCLUDE_BOOT_VOLUME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeBootVolume").getter(getter(Parameters::excludeBootVolume))
            .setter(setter(Builder::excludeBootVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeBootVolume").build()).build();

    private static final SdkField<Boolean> NO_REBOOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoReboot").getter(getter(Parameters::noReboot)).setter(setter(Builder::noReboot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoReboot").build()).build();

    private static final SdkField<List<Tag>> EXCLUDE_DATA_VOLUME_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("ExcludeDataVolumeTags")
            .getter(getter(Parameters::excludeDataVolumeTags))
            .setter(setter(Builder::excludeDataVolumeTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeDataVolumeTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDE_BOOT_VOLUME_FIELD,
            NO_REBOOT_FIELD, EXCLUDE_DATA_VOLUME_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean excludeBootVolume;

    private final Boolean noReboot;

    private final List<Tag> excludeDataVolumeTags;

    private Parameters(BuilderImpl builder) {
        this.excludeBootVolume = builder.excludeBootVolume;
        this.noReboot = builder.noReboot;
        this.excludeDataVolumeTags = builder.excludeDataVolumeTags;
    }

    /**
     * <p>
     * <b>[Custom snapshot policies that target instances only]</b> Indicates whether to exclude the root volume from
     * multi-volume snapshot sets. The default is <code>false</code>. If you specify <code>true</code>, then the root
     * volumes attached to targeted instances will be excluded from the multi-volume snapshot sets created by the
     * policy.
     * </p>
     * 
     * @return <b>[Custom snapshot policies that target instances only]</b> Indicates whether to exclude the root volume
     *         from multi-volume snapshot sets. The default is <code>false</code>. If you specify <code>true</code>,
     *         then the root volumes attached to targeted instances will be excluded from the multi-volume snapshot sets
     *         created by the policy.
     */
    public final Boolean excludeBootVolume() {
        return excludeBootVolume;
    }

    /**
     * <p>
     * <b>[Custom AMI policies only]</b> Indicates whether targeted instances are rebooted when the lifecycle policy
     * runs. <code>true</code> indicates that targeted instances are not rebooted when the policy runs.
     * <code>false</code> indicates that target instances are rebooted when the policy runs. The default is
     * <code>true</code> (instances are not rebooted).
     * </p>
     * 
     * @return <b>[Custom AMI policies only]</b> Indicates whether targeted instances are rebooted when the lifecycle
     *         policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy runs.
     *         <code>false</code> indicates that target instances are rebooted when the policy runs. The default is
     *         <code>true</code> (instances are not rebooted).
     */
    public final Boolean noReboot() {
        return noReboot;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeDataVolumeTags property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExcludeDataVolumeTags() {
        return excludeDataVolumeTags != null && !(excludeDataVolumeTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <b>[Custom snapshot policies that target instances only]</b> The tags used to identify data (non-root) volumes to
     * exclude from multi-volume snapshot sets.
     * </p>
     * <p>
     * If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter, then
     * data volumes with the specified tags that are attached to targeted instances will be excluded from the
     * multi-volume snapshot sets created by the policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeDataVolumeTags} method.
     * </p>
     * 
     * @return <b>[Custom snapshot policies that target instances only]</b> The tags used to identify data (non-root)
     *         volumes to exclude from multi-volume snapshot sets.</p>
     *         <p>
     *         If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter,
     *         then data volumes with the specified tags that are attached to targeted instances will be excluded from
     *         the multi-volume snapshot sets created by the policy.
     */
    public final List<Tag> excludeDataVolumeTags() {
        return excludeDataVolumeTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excludeBootVolume());
        hashCode = 31 * hashCode + Objects.hashCode(noReboot());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeDataVolumeTags() ? excludeDataVolumeTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters) obj;
        return Objects.equals(excludeBootVolume(), other.excludeBootVolume()) && Objects.equals(noReboot(), other.noReboot())
                && hasExcludeDataVolumeTags() == other.hasExcludeDataVolumeTags()
                && Objects.equals(excludeDataVolumeTags(), other.excludeDataVolumeTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Parameters").add("ExcludeBootVolume", excludeBootVolume()).add("NoReboot", noReboot())
                .add("ExcludeDataVolumeTags", hasExcludeDataVolumeTags() ? excludeDataVolumeTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExcludeBootVolume":
            return Optional.ofNullable(clazz.cast(excludeBootVolume()));
        case "NoReboot":
            return Optional.ofNullable(clazz.cast(noReboot()));
        case "ExcludeDataVolumeTags":
            return Optional.ofNullable(clazz.cast(excludeDataVolumeTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parameters, T> g) {
        return obj -> g.apply((Parameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameters> {
        /**
         * <p>
         * <b>[Custom snapshot policies that target instances only]</b> Indicates whether to exclude the root volume
         * from multi-volume snapshot sets. The default is <code>false</code>. If you specify <code>true</code>, then
         * the root volumes attached to targeted instances will be excluded from the multi-volume snapshot sets created
         * by the policy.
         * </p>
         * 
         * @param excludeBootVolume
         *        <b>[Custom snapshot policies that target instances only]</b> Indicates whether to exclude the root
         *        volume from multi-volume snapshot sets. The default is <code>false</code>. If you specify
         *        <code>true</code>, then the root volumes attached to targeted instances will be excluded from the
         *        multi-volume snapshot sets created by the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeBootVolume(Boolean excludeBootVolume);

        /**
         * <p>
         * <b>[Custom AMI policies only]</b> Indicates whether targeted instances are rebooted when the lifecycle policy
         * runs. <code>true</code> indicates that targeted instances are not rebooted when the policy runs.
         * <code>false</code> indicates that target instances are rebooted when the policy runs. The default is
         * <code>true</code> (instances are not rebooted).
         * </p>
         * 
         * @param noReboot
         *        <b>[Custom AMI policies only]</b> Indicates whether targeted instances are rebooted when the lifecycle
         *        policy runs. <code>true</code> indicates that targeted instances are not rebooted when the policy
         *        runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The
         *        default is <code>true</code> (instances are not rebooted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noReboot(Boolean noReboot);

        /**
         * <p>
         * <b>[Custom snapshot policies that target instances only]</b> The tags used to identify data (non-root)
         * volumes to exclude from multi-volume snapshot sets.
         * </p>
         * <p>
         * If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter,
         * then data volumes with the specified tags that are attached to targeted instances will be excluded from the
         * multi-volume snapshot sets created by the policy.
         * </p>
         * 
         * @param excludeDataVolumeTags
         *        <b>[Custom snapshot policies that target instances only]</b> The tags used to identify data (non-root)
         *        volumes to exclude from multi-volume snapshot sets.</p>
         *        <p>
         *        If you create a snapshot lifecycle policy that targets instances and you specify tags for this
         *        parameter, then data volumes with the specified tags that are attached to targeted instances will be
         *        excluded from the multi-volume snapshot sets created by the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeDataVolumeTags(Collection<Tag> excludeDataVolumeTags);

        /**
         * <p>
         * <b>[Custom snapshot policies that target instances only]</b> The tags used to identify data (non-root)
         * volumes to exclude from multi-volume snapshot sets.
         * </p>
         * <p>
         * If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter,
         * then data volumes with the specified tags that are attached to targeted instances will be excluded from the
         * multi-volume snapshot sets created by the policy.
         * </p>
         * 
         * @param excludeDataVolumeTags
         *        <b>[Custom snapshot policies that target instances only]</b> The tags used to identify data (non-root)
         *        volumes to exclude from multi-volume snapshot sets.</p>
         *        <p>
         *        If you create a snapshot lifecycle policy that targets instances and you specify tags for this
         *        parameter, then data volumes with the specified tags that are attached to targeted instances will be
         *        excluded from the multi-volume snapshot sets created by the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeDataVolumeTags(Tag... excludeDataVolumeTags);

        /**
         * <p>
         * <b>[Custom snapshot policies that target instances only]</b> The tags used to identify data (non-root)
         * volumes to exclude from multi-volume snapshot sets.
         * </p>
         * <p>
         * If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter,
         * then data volumes with the specified tags that are attached to targeted instances will be excluded from the
         * multi-volume snapshot sets created by the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dlm.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.dlm.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.dlm.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #excludeDataVolumeTags(List<Tag>)}.
         * 
         * @param excludeDataVolumeTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.dlm.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludeDataVolumeTags(java.util.Collection<Tag>)
         */
        Builder excludeDataVolumeTags(Consumer<Tag.Builder>... excludeDataVolumeTags);
    }

    static final class BuilderImpl implements Builder {
        private Boolean excludeBootVolume;

        private Boolean noReboot;

        private List<Tag> excludeDataVolumeTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Parameters model) {
            excludeBootVolume(model.excludeBootVolume);
            noReboot(model.noReboot);
            excludeDataVolumeTags(model.excludeDataVolumeTags);
        }

        public final Boolean getExcludeBootVolume() {
            return excludeBootVolume;
        }

        public final void setExcludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
        }

        @Override
        public final Builder excludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
            return this;
        }

        public final Boolean getNoReboot() {
            return noReboot;
        }

        public final void setNoReboot(Boolean noReboot) {
            this.noReboot = noReboot;
        }

        @Override
        public final Builder noReboot(Boolean noReboot) {
            this.noReboot = noReboot;
            return this;
        }

        public final List<Tag.Builder> getExcludeDataVolumeTags() {
            List<Tag.Builder> result = ExcludeDataVolumeTagListCopier.copyToBuilder(this.excludeDataVolumeTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeDataVolumeTags(Collection<Tag.BuilderImpl> excludeDataVolumeTags) {
            this.excludeDataVolumeTags = ExcludeDataVolumeTagListCopier.copyFromBuilder(excludeDataVolumeTags);
        }

        @Override
        public final Builder excludeDataVolumeTags(Collection<Tag> excludeDataVolumeTags) {
            this.excludeDataVolumeTags = ExcludeDataVolumeTagListCopier.copy(excludeDataVolumeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeDataVolumeTags(Tag... excludeDataVolumeTags) {
            excludeDataVolumeTags(Arrays.asList(excludeDataVolumeTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeDataVolumeTags(Consumer<Tag.Builder>... excludeDataVolumeTags) {
            excludeDataVolumeTags(Stream.of(excludeDataVolumeTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Parameters build() {
            return new Parameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
