/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyRetainRule;
import software.amazon.awssdk.services.dlm.model.EncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrossRegionCopyAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrossRegionCopyAction> {
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(CrossRegionCopyAction.getter(CrossRegionCopyAction::target)).setter(CrossRegionCopyAction.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(CrossRegionCopyAction.getter(CrossRegionCopyAction::encryptionConfiguration)).setter(CrossRegionCopyAction.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<CrossRegionCopyRetainRule> RETAIN_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetainRule").getter(CrossRegionCopyAction.getter(CrossRegionCopyAction::retainRule)).setter(CrossRegionCopyAction.setter(Builder::retainRule)).constructor(CrossRegionCopyRetainRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, ENCRYPTION_CONFIGURATION_FIELD, RETAIN_RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Target", TARGET_FIELD);
            this.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
            this.put("RetainRule", RETAIN_RULE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String target;
    private final EncryptionConfiguration encryptionConfiguration;
    private final CrossRegionCopyRetainRule retainRule;

    private CrossRegionCopyAction(BuilderImpl builder) {
        this.target = builder.target;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.retainRule = builder.retainRule;
    }

    public final String target() {
        return this.target;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final CrossRegionCopyRetainRule retainRule() {
        return this.retainRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossRegionCopyAction)) {
            return false;
        }
        CrossRegionCopyAction other = (CrossRegionCopyAction)obj;
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.retainRule(), other.retainRule());
    }

    public final String toString() {
        return ToString.builder((String)"CrossRegionCopyAction").add("Target", (Object)this.target()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("RetainRule", (Object)this.retainRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "RetainRule": {
                return Optional.ofNullable(clazz.cast(this.retainRule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CrossRegionCopyAction, T> g) {
        return obj -> g.apply((CrossRegionCopyAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String target;
        private EncryptionConfiguration encryptionConfiguration;
        private CrossRegionCopyRetainRule retainRule;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossRegionCopyAction model) {
            this.target(model.target);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.retainRule(model.retainRule);
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final CrossRegionCopyRetainRule.Builder getRetainRule() {
            return this.retainRule != null ? this.retainRule.toBuilder() : null;
        }

        public final void setRetainRule(CrossRegionCopyRetainRule.BuilderImpl retainRule) {
            this.retainRule = retainRule != null ? retainRule.build() : null;
        }

        @Override
        public final Builder retainRule(CrossRegionCopyRetainRule retainRule) {
            this.retainRule = retainRule;
            return this;
        }

        public CrossRegionCopyAction build() {
            return new CrossRegionCopyAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrossRegionCopyAction> {
        public Builder target(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder retainRule(CrossRegionCopyRetainRule var1);

        default public Builder retainRule(Consumer<CrossRegionCopyRetainRule.Builder> retainRule) {
            return this.retainRule((CrossRegionCopyRetainRule)((CrossRegionCopyRetainRule.Builder)CrossRegionCopyRetainRule.builder().applyMutation(retainRule)).build());
        }
    }
}

