/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>[Custom snapshot policies only]</b> Specifies a snapshot archiving rule for a schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveRule implements SdkPojo, Serializable, ToCopyableBuilder<ArchiveRule.Builder, ArchiveRule> {
    private static final SdkField<ArchiveRetainRule> RETAIN_RULE_FIELD = SdkField
            .<ArchiveRetainRule> builder(MarshallingType.SDK_POJO).memberName("RetainRule")
            .getter(getter(ArchiveRule::retainRule)).setter(setter(Builder::retainRule)).constructor(ArchiveRetainRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETAIN_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ArchiveRetainRule retainRule;

    private ArchiveRule(BuilderImpl builder) {
        this.retainRule = builder.retainRule;
    }

    /**
     * <p>
     * Information about the retention period for the snapshot archiving rule.
     * </p>
     * 
     * @return Information about the retention period for the snapshot archiving rule.
     */
    public final ArchiveRetainRule retainRule() {
        return retainRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retainRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveRule)) {
            return false;
        }
        ArchiveRule other = (ArchiveRule) obj;
        return Objects.equals(retainRule(), other.retainRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveRule").add("RetainRule", retainRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetainRule":
            return Optional.ofNullable(clazz.cast(retainRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RetainRule", RETAIN_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArchiveRule, T> g) {
        return obj -> g.apply((ArchiveRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveRule> {
        /**
         * <p>
         * Information about the retention period for the snapshot archiving rule.
         * </p>
         * 
         * @param retainRule
         *        Information about the retention period for the snapshot archiving rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainRule(ArchiveRetainRule retainRule);

        /**
         * <p>
         * Information about the retention period for the snapshot archiving rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArchiveRetainRule.Builder} avoiding the
         * need to create one manually via {@link ArchiveRetainRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveRetainRule.Builder#build()} is called immediately and its
         * result is passed to {@link #retainRule(ArchiveRetainRule)}.
         * 
         * @param retainRule
         *        a consumer that will call methods on {@link ArchiveRetainRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retainRule(ArchiveRetainRule)
         */
        default Builder retainRule(Consumer<ArchiveRetainRule.Builder> retainRule) {
            return retainRule(ArchiveRetainRule.builder().applyMutation(retainRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ArchiveRetainRule retainRule;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveRule model) {
            retainRule(model.retainRule);
        }

        public final ArchiveRetainRule.Builder getRetainRule() {
            return retainRule != null ? retainRule.toBuilder() : null;
        }

        public final void setRetainRule(ArchiveRetainRule.BuilderImpl retainRule) {
            this.retainRule = retainRule != null ? retainRule.build() : null;
        }

        @Override
        public final Builder retainRule(ArchiveRetainRule retainRule) {
            this.retainRule = retainRule;
            return this;
        }

        @Override
        public ArchiveRule build() {
            return new ArchiveRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
