/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a lifecycle policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicy implements SdkPojo, Serializable, ToCopyableBuilder<LifecyclePolicy.Builder, LifecyclePolicy> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(LifecyclePolicy::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(LifecyclePolicy::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(LifecyclePolicy::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(LifecyclePolicy::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(LifecyclePolicy::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateCreated")
            .getter(getter(LifecyclePolicy::dateCreated))
            .setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateModified")
            .getter(getter(LifecyclePolicy::dateModified))
            .setter(setter(Builder::dateModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField
            .<PolicyDetails> builder(MarshallingType.SDK_POJO).memberName("PolicyDetails")
            .getter(getter(LifecyclePolicy::policyDetails)).setter(setter(Builder::policyDetails))
            .constructor(PolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDetails").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(LifecyclePolicy::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyArn").getter(getter(LifecyclePolicy::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final SdkField<Boolean> DEFAULT_POLICY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultPolicy").getter(getter(LifecyclePolicy::defaultPolicy)).setter(setter(Builder::defaultPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            DESCRIPTION_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, EXECUTION_ROLE_ARN_FIELD, DATE_CREATED_FIELD,
            DATE_MODIFIED_FIELD, POLICY_DETAILS_FIELD, TAGS_FIELD, POLICY_ARN_FIELD, DEFAULT_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyId;

    private final String description;

    private final String state;

    private final String statusMessage;

    private final String executionRoleArn;

    private final Instant dateCreated;

    private final Instant dateModified;

    private final PolicyDetails policyDetails;

    private final Map<String, String> tags;

    private final String policyArn;

    private final Boolean defaultPolicy;

    private LifecyclePolicy(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.description = builder.description;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.executionRoleArn = builder.executionRoleArn;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
        this.policyDetails = builder.policyDetails;
        this.tags = builder.tags;
        this.policyArn = builder.policyArn;
        this.defaultPolicy = builder.defaultPolicy;
    }

    /**
     * <p>
     * The identifier of the lifecycle policy.
     * </p>
     * 
     * @return The identifier of the lifecycle policy.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The description of the lifecycle policy.
     * </p>
     * 
     * @return The description of the lifecycle policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The activation state of the lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link GettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The activation state of the lifecycle policy.
     * @see GettablePolicyStateValues
     */
    public final GettablePolicyStateValues state() {
        return GettablePolicyStateValues.fromValue(state);
    }

    /**
     * <p>
     * The activation state of the lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link GettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The activation state of the lifecycle policy.
     * @see GettablePolicyStateValues
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The description of the status.
     * </p>
     * 
     * @return The description of the status.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle
     *         policy.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The local date and time when the lifecycle policy was created.
     * </p>
     * 
     * @return The local date and time when the lifecycle policy was created.
     */
    public final Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The local date and time when the lifecycle policy was last modified.
     * </p>
     * 
     * @return The local date and time when the lifecycle policy was last modified.
     */
    public final Instant dateModified() {
        return dateModified;
    }

    /**
     * <p>
     * The configuration of the lifecycle policy
     * </p>
     * 
     * @return The configuration of the lifecycle policy
     */
    public final PolicyDetails policyDetails() {
        return policyDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the policy.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * Indicates whether the policy is a default lifecycle policy or a custom lifecycle policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code> - the policy is a default policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code> - the policy is a custom policy.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether the policy is a default lifecycle policy or a custom lifecycle policy.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code> - the policy is a default policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code> - the policy is a custom policy.
     *         </p>
     *         </li>
     */
    public final Boolean defaultPolicy() {
        return defaultPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateModified());
        hashCode = 31 * hashCode + Objects.hashCode(policyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicy)) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(description(), other.description())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateModified(), other.dateModified())
                && Objects.equals(policyDetails(), other.policyDetails()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(policyArn(), other.policyArn())
                && Objects.equals(defaultPolicy(), other.defaultPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicy").add("PolicyId", policyId()).add("Description", description())
                .add("State", stateAsString()).add("StatusMessage", statusMessage()).add("ExecutionRoleArn", executionRoleArn())
                .add("DateCreated", dateCreated()).add("DateModified", dateModified()).add("PolicyDetails", policyDetails())
                .add("Tags", hasTags() ? tags() : null).add("PolicyArn", policyArn()).add("DefaultPolicy", defaultPolicy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateModified":
            return Optional.ofNullable(clazz.cast(dateModified()));
        case "PolicyDetails":
            return Optional.ofNullable(clazz.cast(policyDetails()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "DefaultPolicy":
            return Optional.ofNullable(clazz.cast(defaultPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyId", POLICY_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("DateCreated", DATE_CREATED_FIELD);
        map.put("DateModified", DATE_MODIFIED_FIELD);
        map.put("PolicyDetails", POLICY_DETAILS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("PolicyArn", POLICY_ARN_FIELD);
        map.put("DefaultPolicy", DEFAULT_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicy, T> g) {
        return obj -> g.apply((LifecyclePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicy> {
        /**
         * <p>
         * The identifier of the lifecycle policy.
         * </p>
         * 
         * @param policyId
         *        The identifier of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The description of the lifecycle policy.
         * </p>
         * 
         * @param description
         *        The description of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The activation state of the lifecycle policy.
         * </p>
         * 
         * @param state
         *        The activation state of the lifecycle policy.
         * @see GettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GettablePolicyStateValues
         */
        Builder state(String state);

        /**
         * <p>
         * The activation state of the lifecycle policy.
         * </p>
         * 
         * @param state
         *        The activation state of the lifecycle policy.
         * @see GettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GettablePolicyStateValues
         */
        Builder state(GettablePolicyStateValues state);

        /**
         * <p>
         * The description of the status.
         * </p>
         * 
         * @param statusMessage
         *        The description of the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle
         *        policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The local date and time when the lifecycle policy was created.
         * </p>
         * 
         * @param dateCreated
         *        The local date and time when the lifecycle policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The local date and time when the lifecycle policy was last modified.
         * </p>
         * 
         * @param dateModified
         *        The local date and time when the lifecycle policy was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateModified(Instant dateModified);

        /**
         * <p>
         * The configuration of the lifecycle policy
         * </p>
         * 
         * @param policyDetails
         *        The configuration of the lifecycle policy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(PolicyDetails policyDetails);

        /**
         * <p>
         * The configuration of the lifecycle policy
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyDetails.Builder} avoiding the need
         * to create one manually via {@link PolicyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #policyDetails(PolicyDetails)}.
         * 
         * @param policyDetails
         *        a consumer that will call methods on {@link PolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDetails(PolicyDetails)
         */
        default Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return policyDetails(PolicyDetails.builder().applyMutation(policyDetails).build());
        }

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the policy.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * Indicates whether the policy is a default lifecycle policy or a custom lifecycle policy.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code> - the policy is a default policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code> - the policy is a custom policy.
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultPolicy
         *        Indicates whether the policy is a default lifecycle policy or a custom lifecycle policy.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code> - the policy is a default policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code> - the policy is a custom policy.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPolicy(Boolean defaultPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String policyId;

        private String description;

        private String state;

        private String statusMessage;

        private String executionRoleArn;

        private Instant dateCreated;

        private Instant dateModified;

        private PolicyDetails policyDetails;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String policyArn;

        private Boolean defaultPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicy model) {
            policyId(model.policyId);
            description(model.description);
            state(model.state);
            statusMessage(model.statusMessage);
            executionRoleArn(model.executionRoleArn);
            dateCreated(model.dateCreated);
            dateModified(model.dateModified);
            policyDetails(model.policyDetails);
            tags(model.tags);
            policyArn(model.policyArn);
            defaultPolicy(model.defaultPolicy);
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(GettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateModified() {
            return dateModified;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return policyDetails != null ? policyDetails.toBuilder() : null;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Boolean getDefaultPolicy() {
            return defaultPolicy;
        }

        public final void setDefaultPolicy(Boolean defaultPolicy) {
            this.defaultPolicy = defaultPolicy;
        }

        @Override
        public final Builder defaultPolicy(Boolean defaultPolicy) {
            this.defaultPolicy = defaultPolicy;
            return this;
        }

        @Override
        public LifecyclePolicy build() {
            return new LifecyclePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
