/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLifecyclePolicyRequest extends DlmRequest implements
        ToCopyableBuilder<UpdateLifecyclePolicyRequest.Builder, UpdateLifecyclePolicyRequest> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(UpdateLifecyclePolicyRequest::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyId").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(UpdateLifecyclePolicyRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateLifecyclePolicyRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateLifecyclePolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField
            .<PolicyDetails> builder(MarshallingType.SDK_POJO).memberName("PolicyDetails")
            .getter(getter(UpdateLifecyclePolicyRequest::policyDetails)).setter(setter(Builder::policyDetails))
            .constructor(PolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDetails").build()).build();

    private static final SdkField<Integer> CREATE_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CreateInterval").getter(getter(UpdateLifecyclePolicyRequest::createInterval))
            .setter(setter(Builder::createInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateInterval").build()).build();

    private static final SdkField<Integer> RETAIN_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetainInterval").getter(getter(UpdateLifecyclePolicyRequest::retainInterval))
            .setter(setter(Builder::retainInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainInterval").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTags").getter(getter(UpdateLifecyclePolicyRequest::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()).build();

    private static final SdkField<Boolean> EXTEND_DELETION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExtendDeletion").getter(getter(UpdateLifecyclePolicyRequest::extendDeletion))
            .setter(setter(Builder::extendDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendDeletion").build()).build();

    private static final SdkField<List<CrossRegionCopyTarget>> CROSS_REGION_COPY_TARGETS_FIELD = SdkField
            .<List<CrossRegionCopyTarget>> builder(MarshallingType.LIST)
            .memberName("CrossRegionCopyTargets")
            .getter(getter(UpdateLifecyclePolicyRequest::crossRegionCopyTargets))
            .setter(setter(Builder::crossRegionCopyTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRegionCopyTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CrossRegionCopyTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(CrossRegionCopyTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Exclusions> EXCLUSIONS_FIELD = SdkField.<Exclusions> builder(MarshallingType.SDK_POJO)
            .memberName("Exclusions").getter(getter(UpdateLifecyclePolicyRequest::exclusions))
            .setter(setter(Builder::exclusions)).constructor(Exclusions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclusions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            EXECUTION_ROLE_ARN_FIELD, STATE_FIELD, DESCRIPTION_FIELD, POLICY_DETAILS_FIELD, CREATE_INTERVAL_FIELD,
            RETAIN_INTERVAL_FIELD, COPY_TAGS_FIELD, EXTEND_DELETION_FIELD, CROSS_REGION_COPY_TARGETS_FIELD, EXCLUSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyId;

    private final String executionRoleArn;

    private final String state;

    private final String description;

    private final PolicyDetails policyDetails;

    private final Integer createInterval;

    private final Integer retainInterval;

    private final Boolean copyTags;

    private final Boolean extendDeletion;

    private final List<CrossRegionCopyTarget> crossRegionCopyTargets;

    private final Exclusions exclusions;

    private UpdateLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyId = builder.policyId;
        this.executionRoleArn = builder.executionRoleArn;
        this.state = builder.state;
        this.description = builder.description;
        this.policyDetails = builder.policyDetails;
        this.createInterval = builder.createInterval;
        this.retainInterval = builder.retainInterval;
        this.copyTags = builder.copyTags;
        this.extendDeletion = builder.extendDeletion;
        this.crossRegionCopyTargets = builder.crossRegionCopyTargets;
        this.exclusions = builder.exclusions;
    }

    /**
     * <p>
     * The identifier of the lifecycle policy.
     * </p>
     * 
     * @return The identifier of the lifecycle policy.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle
     *         policy.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The desired activation state of the lifecycle policy after creation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The desired activation state of the lifecycle policy after creation.
     * @see SettablePolicyStateValues
     */
    public final SettablePolicyStateValues state() {
        return SettablePolicyStateValues.fromValue(state);
    }

    /**
     * <p>
     * The desired activation state of the lifecycle policy after creation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The desired activation state of the lifecycle policy after creation.
     * @see SettablePolicyStateValues
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * A description of the lifecycle policy.
     * </p>
     * 
     * @return A description of the lifecycle policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration of the lifecycle policy. You cannot update the policy type or the resource type.
     * </p>
     * 
     * @return The configuration of the lifecycle policy. You cannot update the policy type or the resource type.
     */
    public final PolicyDetails policyDetails() {
        return policyDetails;
    }

    /**
     * <p>
     * <b>[Default policies only]</b> Specifies how often the policy should run and create snapshots or AMIs. The
     * creation frequency can range from 1 to 7 days.
     * </p>
     * 
     * @return <b>[Default policies only]</b> Specifies how often the policy should run and create snapshots or AMIs.
     *         The creation frequency can range from 1 to 7 days.
     */
    public final Integer createInterval() {
        return createInterval;
    }

    /**
     * <p>
     * <b>[Default policies only]</b> Specifies how long the policy should retain snapshots or AMIs before deleting
     * them. The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to
     * ensure that the policy retains at least 1 snapshot or AMI at any given time.
     * </p>
     * 
     * @return <b>[Default policies only]</b> Specifies how long the policy should retain snapshots or AMIs before
     *         deleting them. The retention period can range from 2 to 14 days, but it must be greater than the creation
     *         frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time.
     */
    public final Integer retainInterval() {
        return retainInterval;
    }

    /**
     * <p>
     * <b>[Default policies only]</b> Indicates whether the policy should copy tags from the source resource to the
     * snapshot or AMI.
     * </p>
     * 
     * @return <b>[Default policies only]</b> Indicates whether the policy should copy tags from the source resource to
     *         the snapshot or AMI.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * <p>
     * <b>[Default policies only]</b> Defines the snapshot or AMI retention behavior for the policy if the source volume
     * or instance is deleted, or if the policy enters the error, disabled, or deleted state.
     * </p>
     * <p>
     * By default (<b>ExtendDeletion=false</b>):
     * </p>
     * <ul>
     * <li>
     * <p>
     * If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created
     * snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want
     * Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots
     * and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last
     * one, if the policy enters one of these states, specify <code>true</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you enable extended deletion (<b>ExtendDeletion=true</b>), you override both default behaviors simultaneously.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return <b>[Default policies only]</b> Defines the snapshot or AMI retention behavior for the policy if the
     *         source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.</p>
     *         <p>
     *         By default (<b>ExtendDeletion=false</b>):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created
     *         snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you
     *         want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify
     *         <code>true</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting
     *         snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs,
     *         including the last one, if the policy enters one of these states, specify <code>true</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you enable extended deletion (<b>ExtendDeletion=true</b>), you override both default behaviors
     *         simultaneously.
     *         </p>
     *         <p>
     *         Default: false
     */
    public final Boolean extendDeletion() {
        return extendDeletion;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossRegionCopyTargets property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCrossRegionCopyTargets() {
        return crossRegionCopyTargets != null && !(crossRegionCopyTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <b>[Default policies only]</b> Specifies destination Regions for snapshot or AMI copies. You can specify up to 3
     * destination Regions. If you do not want to create cross-Region copies, omit this parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossRegionCopyTargets} method.
     * </p>
     * 
     * @return <b>[Default policies only]</b> Specifies destination Regions for snapshot or AMI copies. You can specify
     *         up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
     */
    public final List<CrossRegionCopyTarget> crossRegionCopyTargets() {
        return crossRegionCopyTargets;
    }

    /**
     * <p>
     * <b>[Default policies only]</b> Specifies exclusion parameters for volumes or instances for which you do not want
     * to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that match any of
     * the specified exclusion parameters.
     * </p>
     * 
     * @return <b>[Default policies only]</b> Specifies exclusion parameters for volumes or instances for which you do
     *         not want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources
     *         that match any of the specified exclusion parameters.
     */
    public final Exclusions exclusions() {
        return exclusions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(policyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(createInterval());
        hashCode = 31 * hashCode + Objects.hashCode(retainInterval());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(extendDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(hasCrossRegionCopyTargets() ? crossRegionCopyTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(exclusions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLifecyclePolicyRequest)) {
            return false;
        }
        UpdateLifecyclePolicyRequest other = (UpdateLifecyclePolicyRequest) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(policyDetails(), other.policyDetails())
                && Objects.equals(createInterval(), other.createInterval())
                && Objects.equals(retainInterval(), other.retainInterval()) && Objects.equals(copyTags(), other.copyTags())
                && Objects.equals(extendDeletion(), other.extendDeletion())
                && hasCrossRegionCopyTargets() == other.hasCrossRegionCopyTargets()
                && Objects.equals(crossRegionCopyTargets(), other.crossRegionCopyTargets())
                && Objects.equals(exclusions(), other.exclusions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLifecyclePolicyRequest").add("PolicyId", policyId())
                .add("ExecutionRoleArn", executionRoleArn()).add("State", stateAsString()).add("Description", description())
                .add("PolicyDetails", policyDetails()).add("CreateInterval", createInterval())
                .add("RetainInterval", retainInterval()).add("CopyTags", copyTags()).add("ExtendDeletion", extendDeletion())
                .add("CrossRegionCopyTargets", hasCrossRegionCopyTargets() ? crossRegionCopyTargets() : null)
                .add("Exclusions", exclusions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PolicyDetails":
            return Optional.ofNullable(clazz.cast(policyDetails()));
        case "CreateInterval":
            return Optional.ofNullable(clazz.cast(createInterval()));
        case "RetainInterval":
            return Optional.ofNullable(clazz.cast(retainInterval()));
        case "CopyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "ExtendDeletion":
            return Optional.ofNullable(clazz.cast(extendDeletion()));
        case "CrossRegionCopyTargets":
            return Optional.ofNullable(clazz.cast(crossRegionCopyTargets()));
        case "Exclusions":
            return Optional.ofNullable(clazz.cast(exclusions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyId", POLICY_ID_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PolicyDetails", POLICY_DETAILS_FIELD);
        map.put("CreateInterval", CREATE_INTERVAL_FIELD);
        map.put("RetainInterval", RETAIN_INTERVAL_FIELD);
        map.put("CopyTags", COPY_TAGS_FIELD);
        map.put("ExtendDeletion", EXTEND_DELETION_FIELD);
        map.put("CrossRegionCopyTargets", CROSS_REGION_COPY_TARGETS_FIELD);
        map.put("Exclusions", EXCLUSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((UpdateLifecyclePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DlmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLifecyclePolicyRequest> {
        /**
         * <p>
         * The identifier of the lifecycle policy.
         * </p>
         * 
         * @param policyId
         *        The identifier of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle
         *        policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The desired activation state of the lifecycle policy after creation.
         * </p>
         * 
         * @param state
         *        The desired activation state of the lifecycle policy after creation.
         * @see SettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettablePolicyStateValues
         */
        Builder state(String state);

        /**
         * <p>
         * The desired activation state of the lifecycle policy after creation.
         * </p>
         * 
         * @param state
         *        The desired activation state of the lifecycle policy after creation.
         * @see SettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettablePolicyStateValues
         */
        Builder state(SettablePolicyStateValues state);

        /**
         * <p>
         * A description of the lifecycle policy.
         * </p>
         * 
         * @param description
         *        A description of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration of the lifecycle policy. You cannot update the policy type or the resource type.
         * </p>
         * 
         * @param policyDetails
         *        The configuration of the lifecycle policy. You cannot update the policy type or the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(PolicyDetails policyDetails);

        /**
         * <p>
         * The configuration of the lifecycle policy. You cannot update the policy type or the resource type.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyDetails.Builder} avoiding the need
         * to create one manually via {@link PolicyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #policyDetails(PolicyDetails)}.
         * 
         * @param policyDetails
         *        a consumer that will call methods on {@link PolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDetails(PolicyDetails)
         */
        default Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return policyDetails(PolicyDetails.builder().applyMutation(policyDetails).build());
        }

        /**
         * <p>
         * <b>[Default policies only]</b> Specifies how often the policy should run and create snapshots or AMIs. The
         * creation frequency can range from 1 to 7 days.
         * </p>
         * 
         * @param createInterval
         *        <b>[Default policies only]</b> Specifies how often the policy should run and create snapshots or AMIs.
         *        The creation frequency can range from 1 to 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createInterval(Integer createInterval);

        /**
         * <p>
         * <b>[Default policies only]</b> Specifies how long the policy should retain snapshots or AMIs before deleting
         * them. The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to
         * ensure that the policy retains at least 1 snapshot or AMI at any given time.
         * </p>
         * 
         * @param retainInterval
         *        <b>[Default policies only]</b> Specifies how long the policy should retain snapshots or AMIs before
         *        deleting them. The retention period can range from 2 to 14 days, but it must be greater than the
         *        creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainInterval(Integer retainInterval);

        /**
         * <p>
         * <b>[Default policies only]</b> Indicates whether the policy should copy tags from the source resource to the
         * snapshot or AMI.
         * </p>
         * 
         * @param copyTags
         *        <b>[Default policies only]</b> Indicates whether the policy should copy tags from the source resource
         *        to the snapshot or AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * <b>[Default policies only]</b> Defines the snapshot or AMI retention behavior for the policy if the source
         * volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
         * </p>
         * <p>
         * By default (<b>ExtendDeletion=false</b>):
         * </p>
         * <ul>
         * <li>
         * <p>
         * If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created
         * snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want
         * Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify
         * <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting
         * snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs,
         * including the last one, if the policy enters one of these states, specify <code>true</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you enable extended deletion (<b>ExtendDeletion=true</b>), you override both default behaviors
         * simultaneously.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param extendDeletion
         *        <b>[Default policies only]</b> Defines the snapshot or AMI retention behavior for the policy if the
         *        source volume or instance is deleted, or if the policy enters the error, disabled, or deleted
         *        state.</p>
         *        <p>
         *        By default (<b>ExtendDeletion=false</b>):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously
         *        created snapshots or AMIs, up to but not including the last one, based on the specified retention
         *        period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last
         *        one, specify <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting
         *        snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs,
         *        including the last one, if the policy enters one of these states, specify <code>true</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you enable extended deletion (<b>ExtendDeletion=true</b>), you override both default behaviors
         *        simultaneously.
         *        </p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendDeletion(Boolean extendDeletion);

        /**
         * <p>
         * <b>[Default policies only]</b> Specifies destination Regions for snapshot or AMI copies. You can specify up
         * to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
         * </p>
         * 
         * @param crossRegionCopyTargets
         *        <b>[Default policies only]</b> Specifies destination Regions for snapshot or AMI copies. You can
         *        specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionCopyTargets(Collection<CrossRegionCopyTarget> crossRegionCopyTargets);

        /**
         * <p>
         * <b>[Default policies only]</b> Specifies destination Regions for snapshot or AMI copies. You can specify up
         * to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
         * </p>
         * 
         * @param crossRegionCopyTargets
         *        <b>[Default policies only]</b> Specifies destination Regions for snapshot or AMI copies. You can
         *        specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionCopyTargets(CrossRegionCopyTarget... crossRegionCopyTargets);

        /**
         * <p>
         * <b>[Default policies only]</b> Specifies destination Regions for snapshot or AMI copies. You can specify up
         * to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dlm.model.CrossRegionCopyTarget.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.dlm.model.CrossRegionCopyTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dlm.model.CrossRegionCopyTarget.Builder#build()} is called immediately
         * and its result is passed to {@link #crossRegionCopyTargets(List<CrossRegionCopyTarget>)}.
         * 
         * @param crossRegionCopyTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dlm.model.CrossRegionCopyTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossRegionCopyTargets(java.util.Collection<CrossRegionCopyTarget>)
         */
        Builder crossRegionCopyTargets(Consumer<CrossRegionCopyTarget.Builder>... crossRegionCopyTargets);

        /**
         * <p>
         * <b>[Default policies only]</b> Specifies exclusion parameters for volumes or instances for which you do not
         * want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that
         * match any of the specified exclusion parameters.
         * </p>
         * 
         * @param exclusions
         *        <b>[Default policies only]</b> Specifies exclusion parameters for volumes or instances for which you
         *        do not want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target
         *        resources that match any of the specified exclusion parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusions(Exclusions exclusions);

        /**
         * <p>
         * <b>[Default policies only]</b> Specifies exclusion parameters for volumes or instances for which you do not
         * want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that
         * match any of the specified exclusion parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link Exclusions.Builder} avoiding the need to
         * create one manually via {@link Exclusions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Exclusions.Builder#build()} is called immediately and its result
         * is passed to {@link #exclusions(Exclusions)}.
         * 
         * @param exclusions
         *        a consumer that will call methods on {@link Exclusions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclusions(Exclusions)
         */
        default Builder exclusions(Consumer<Exclusions.Builder> exclusions) {
            return exclusions(Exclusions.builder().applyMutation(exclusions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DlmRequest.BuilderImpl implements Builder {
        private String policyId;

        private String executionRoleArn;

        private String state;

        private String description;

        private PolicyDetails policyDetails;

        private Integer createInterval;

        private Integer retainInterval;

        private Boolean copyTags;

        private Boolean extendDeletion;

        private List<CrossRegionCopyTarget> crossRegionCopyTargets = DefaultSdkAutoConstructList.getInstance();

        private Exclusions exclusions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLifecyclePolicyRequest model) {
            super(model);
            policyId(model.policyId);
            executionRoleArn(model.executionRoleArn);
            state(model.state);
            description(model.description);
            policyDetails(model.policyDetails);
            createInterval(model.createInterval);
            retainInterval(model.retainInterval);
            copyTags(model.copyTags);
            extendDeletion(model.extendDeletion);
            crossRegionCopyTargets(model.crossRegionCopyTargets);
            exclusions(model.exclusions);
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return policyDetails != null ? policyDetails.toBuilder() : null;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final Integer getCreateInterval() {
            return createInterval;
        }

        public final void setCreateInterval(Integer createInterval) {
            this.createInterval = createInterval;
        }

        @Override
        public final Builder createInterval(Integer createInterval) {
            this.createInterval = createInterval;
            return this;
        }

        public final Integer getRetainInterval() {
            return retainInterval;
        }

        public final void setRetainInterval(Integer retainInterval) {
            this.retainInterval = retainInterval;
        }

        @Override
        public final Builder retainInterval(Integer retainInterval) {
            this.retainInterval = retainInterval;
            return this;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final Boolean getExtendDeletion() {
            return extendDeletion;
        }

        public final void setExtendDeletion(Boolean extendDeletion) {
            this.extendDeletion = extendDeletion;
        }

        @Override
        public final Builder extendDeletion(Boolean extendDeletion) {
            this.extendDeletion = extendDeletion;
            return this;
        }

        public final List<CrossRegionCopyTarget.Builder> getCrossRegionCopyTargets() {
            List<CrossRegionCopyTarget.Builder> result = CrossRegionCopyTargetListCopier
                    .copyToBuilder(this.crossRegionCopyTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossRegionCopyTargets(Collection<CrossRegionCopyTarget.BuilderImpl> crossRegionCopyTargets) {
            this.crossRegionCopyTargets = CrossRegionCopyTargetListCopier.copyFromBuilder(crossRegionCopyTargets);
        }

        @Override
        public final Builder crossRegionCopyTargets(Collection<CrossRegionCopyTarget> crossRegionCopyTargets) {
            this.crossRegionCopyTargets = CrossRegionCopyTargetListCopier.copy(crossRegionCopyTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyTargets(CrossRegionCopyTarget... crossRegionCopyTargets) {
            crossRegionCopyTargets(Arrays.asList(crossRegionCopyTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyTargets(Consumer<CrossRegionCopyTarget.Builder>... crossRegionCopyTargets) {
            crossRegionCopyTargets(Stream.of(crossRegionCopyTargets)
                    .map(c -> CrossRegionCopyTarget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Exclusions.Builder getExclusions() {
            return exclusions != null ? exclusions.toBuilder() : null;
        }

        public final void setExclusions(Exclusions.BuilderImpl exclusions) {
            this.exclusions = exclusions != null ? exclusions.build() : null;
        }

        @Override
        public final Builder exclusions(Exclusions exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLifecyclePolicyRequest build() {
            return new UpdateLifecyclePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
