/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies when to create snapshots of EBS volumes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRule implements SdkPojo, Serializable, ToCopyableBuilder<CreateRule.Builder, CreateRule> {
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateRule::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<String> INTERVAL_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRule::intervalUnitAsString)).setter(setter(Builder::intervalUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalUnit").build()).build();

    private static final SdkField<List<String>> TIMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateRule::times))
            .setter(setter(Builder::times))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Times").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD,
            INTERVAL_UNIT_FIELD, TIMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer interval;

    private final String intervalUnit;

    private final List<String> times;

    private CreateRule(BuilderImpl builder) {
        this.interval = builder.interval;
        this.intervalUnit = builder.intervalUnit;
        this.times = builder.times;
    }

    /**
     * <p>
     * The interval. The supported values are 12 and 24.
     * </p>
     * 
     * @return The interval. The supported values are 12 and 24.
     */
    public Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The interval unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalUnit} will
     * return {@link IntervalUnitValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intervalUnitAsString}.
     * </p>
     * 
     * @return The interval unit.
     * @see IntervalUnitValues
     */
    public IntervalUnitValues intervalUnit() {
        return IntervalUnitValues.fromValue(intervalUnit);
    }

    /**
     * <p>
     * The interval unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalUnit} will
     * return {@link IntervalUnitValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intervalUnitAsString}.
     * </p>
     * 
     * @return The interval unit.
     * @see IntervalUnitValues
     */
    public String intervalUnitAsString() {
        return intervalUnit;
    }

    /**
     * <p>
     * The time, in UTC, to start the operation.
     * </p>
     * <p>
     * The operation occurs within a one-hour window following the specified time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The time, in UTC, to start the operation.</p>
     *         <p>
     *         The operation occurs within a one-hour window following the specified time.
     */
    public List<String> times() {
        return times;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(intervalUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(times());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRule)) {
            return false;
        }
        CreateRule other = (CreateRule) obj;
        return Objects.equals(interval(), other.interval())
                && Objects.equals(intervalUnitAsString(), other.intervalUnitAsString()) && Objects.equals(times(), other.times());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateRule").add("Interval", interval()).add("IntervalUnit", intervalUnitAsString())
                .add("Times", times()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "IntervalUnit":
            return Optional.ofNullable(clazz.cast(intervalUnitAsString()));
        case "Times":
            return Optional.ofNullable(clazz.cast(times()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRule, T> g) {
        return obj -> g.apply((CreateRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateRule> {
        /**
         * <p>
         * The interval. The supported values are 12 and 24.
         * </p>
         * 
         * @param interval
         *        The interval. The supported values are 12 and 24.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The interval unit.
         * </p>
         * 
         * @param intervalUnit
         *        The interval unit.
         * @see IntervalUnitValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntervalUnitValues
         */
        Builder intervalUnit(String intervalUnit);

        /**
         * <p>
         * The interval unit.
         * </p>
         * 
         * @param intervalUnit
         *        The interval unit.
         * @see IntervalUnitValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntervalUnitValues
         */
        Builder intervalUnit(IntervalUnitValues intervalUnit);

        /**
         * <p>
         * The time, in UTC, to start the operation.
         * </p>
         * <p>
         * The operation occurs within a one-hour window following the specified time.
         * </p>
         * 
         * @param times
         *        The time, in UTC, to start the operation.</p>
         *        <p>
         *        The operation occurs within a one-hour window following the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder times(Collection<String> times);

        /**
         * <p>
         * The time, in UTC, to start the operation.
         * </p>
         * <p>
         * The operation occurs within a one-hour window following the specified time.
         * </p>
         * 
         * @param times
         *        The time, in UTC, to start the operation.</p>
         *        <p>
         *        The operation occurs within a one-hour window following the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder times(String... times);
    }

    static final class BuilderImpl implements Builder {
        private Integer interval;

        private String intervalUnit;

        private List<String> times = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRule model) {
            interval(model.interval);
            intervalUnit(model.intervalUnit);
            times(model.times);
        }

        public final Integer getInterval() {
            return interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final String getIntervalUnitAsString() {
            return intervalUnit;
        }

        @Override
        public final Builder intervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
            return this;
        }

        @Override
        public final Builder intervalUnit(IntervalUnitValues intervalUnit) {
            this.intervalUnit(intervalUnit.toString());
            return this;
        }

        public final void setIntervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
        }

        public final Collection<String> getTimes() {
            return times;
        }

        @Override
        public final Builder times(Collection<String> times) {
            this.times = TimesListCopier.copy(times);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder times(String... times) {
            times(Arrays.asList(times));
            return this;
        }

        public final void setTimes(Collection<String> times) {
            this.times = TimesListCopier.copy(times);
        }

        @Override
        public CreateRule build() {
            return new CreateRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
