/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLifecyclePolicyResponse extends DlmResponse implements
        ToCopyableBuilder<GetLifecyclePolicyResponse.Builder, GetLifecyclePolicyResponse> {
    private static final SdkField<LifecyclePolicy> POLICY_FIELD = SdkField.<LifecyclePolicy> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetLifecyclePolicyResponse::policy)).setter(setter(Builder::policy))
            .constructor(LifecyclePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD));

    private final LifecyclePolicy policy;

    private GetLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
    }

    /**
     * <p>
     * Detailed information about the lifecycle policy.
     * </p>
     * 
     * @return Detailed information about the lifecycle policy.
     */
    public LifecyclePolicy policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePolicyResponse)) {
            return false;
        }
        GetLifecyclePolicyResponse other = (GetLifecyclePolicyResponse) obj;
        return Objects.equals(policy(), other.policy());
    }

    @Override
    public String toString() {
        return ToString.builder("GetLifecyclePolicyResponse").add("Policy", policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((GetLifecyclePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DlmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLifecyclePolicyResponse> {
        /**
         * <p>
         * Detailed information about the lifecycle policy.
         * </p>
         * 
         * @param policy
         *        Detailed information about the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(LifecyclePolicy policy);

        /**
         * <p>
         * Detailed information about the lifecycle policy.
         * </p>
         * This is a convenience that creates an instance of the {@link LifecyclePolicy.Builder} avoiding the need to
         * create one manually via {@link LifecyclePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifecyclePolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #policy(LifecyclePolicy)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link LifecyclePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(LifecyclePolicy)
         */
        default Builder policy(Consumer<LifecyclePolicy.Builder> policy) {
            return policy(LifecyclePolicy.builder().applyMutation(policy).build());
        }
    }

    static final class BuilderImpl extends DlmResponse.BuilderImpl implements Builder {
        private LifecyclePolicy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePolicyResponse model) {
            super(model);
            policy(model.policy);
        }

        public final LifecyclePolicy.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        @Override
        public final Builder policy(LifecyclePolicy policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(LifecyclePolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public GetLifecyclePolicyResponse build() {
            return new GetLifecyclePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
