/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a lifecycle policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicySummary.Builder, LifecyclePolicySummary> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(LifecyclePolicySummary::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(LifecyclePolicySummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(LifecyclePolicySummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(LifecyclePolicySummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(LifecyclePolicySummary::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<Boolean> DEFAULT_POLICY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultPolicy").getter(getter(LifecyclePolicySummary::defaultPolicy))
            .setter(setter(Builder::defaultPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            DESCRIPTION_FIELD, STATE_FIELD, TAGS_FIELD, POLICY_TYPE_FIELD, DEFAULT_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyId;

    private final String description;

    private final String state;

    private final Map<String, String> tags;

    private final String policyType;

    private final Boolean defaultPolicy;

    private LifecyclePolicySummary(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.description = builder.description;
        this.state = builder.state;
        this.tags = builder.tags;
        this.policyType = builder.policyType;
        this.defaultPolicy = builder.defaultPolicy;
    }

    /**
     * <p>
     * The identifier of the lifecycle policy.
     * </p>
     * 
     * @return The identifier of the lifecycle policy.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The description of the lifecycle policy.
     * </p>
     * 
     * @return The description of the lifecycle policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The activation state of the lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link GettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The activation state of the lifecycle policy.
     * @see GettablePolicyStateValues
     */
    public final GettablePolicyStateValues state() {
        return GettablePolicyStateValues.fromValue(state);
    }

    /**
     * <p>
     * The activation state of the lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link GettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The activation state of the lifecycle policy.
     * @see GettablePolicyStateValues
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy manages the lifecycle of
     * Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code> indicates that the policy manages the lifecycle of EBS-backed
     * AMIs. <code>EVENT_BASED_POLICY</code> indicates that the policy automates cross-account snapshot copies for
     * snapshots that are shared with your account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy manages the lifecycle
     *         of Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code> indicates that the policy manages the lifecycle of
     *         EBS-backed AMIs. <code>EVENT_BASED_POLICY</code> indicates that the policy automates cross-account
     *         snapshot copies for snapshots that are shared with your account.
     * @see PolicyTypeValues
     */
    public final PolicyTypeValues policyType() {
        return PolicyTypeValues.fromValue(policyType);
    }

    /**
     * <p>
     * The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy manages the lifecycle of
     * Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code> indicates that the policy manages the lifecycle of EBS-backed
     * AMIs. <code>EVENT_BASED_POLICY</code> indicates that the policy automates cross-account snapshot copies for
     * snapshots that are shared with your account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy manages the lifecycle
     *         of Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code> indicates that the policy manages the lifecycle of
     *         EBS-backed AMIs. <code>EVENT_BASED_POLICY</code> indicates that the policy automates cross-account
     *         snapshot copies for snapshots that are shared with your account.
     * @see PolicyTypeValues
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * <b>[Default policies only]</b> The type of default policy. Values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VOLUME</code> - Default policy for EBS snapshots
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE</code> - Default policy for EBS-backed AMIs
     * </p>
     * </li>
     * </ul>
     * 
     * @return <b>[Default policies only]</b> The type of default policy. Values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VOLUME</code> - Default policy for EBS snapshots
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE</code> - Default policy for EBS-backed AMIs
     *         </p>
     *         </li>
     */
    public final Boolean defaultPolicy() {
        return defaultPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicySummary)) {
            return false;
        }
        LifecyclePolicySummary other = (LifecyclePolicySummary) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(description(), other.description())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(defaultPolicy(), other.defaultPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicySummary").add("PolicyId", policyId()).add("Description", description())
                .add("State", stateAsString()).add("Tags", hasTags() ? tags() : null).add("PolicyType", policyTypeAsString())
                .add("DefaultPolicy", defaultPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "DefaultPolicy":
            return Optional.ofNullable(clazz.cast(defaultPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyId", POLICY_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("DefaultPolicy", DEFAULT_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicySummary, T> g) {
        return obj -> g.apply((LifecyclePolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicySummary> {
        /**
         * <p>
         * The identifier of the lifecycle policy.
         * </p>
         * 
         * @param policyId
         *        The identifier of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The description of the lifecycle policy.
         * </p>
         * 
         * @param description
         *        The description of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The activation state of the lifecycle policy.
         * </p>
         * 
         * @param state
         *        The activation state of the lifecycle policy.
         * @see GettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GettablePolicyStateValues
         */
        Builder state(String state);

        /**
         * <p>
         * The activation state of the lifecycle policy.
         * </p>
         * 
         * @param state
         *        The activation state of the lifecycle policy.
         * @see GettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GettablePolicyStateValues
         */
        Builder state(GettablePolicyStateValues state);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy manages the lifecycle of
         * Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code> indicates that the policy manages the lifecycle of
         * EBS-backed AMIs. <code>EVENT_BASED_POLICY</code> indicates that the policy automates cross-account snapshot
         * copies for snapshots that are shared with your account.
         * </p>
         * 
         * @param policyType
         *        The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy manages the
         *        lifecycle of Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code> indicates that the policy manages the
         *        lifecycle of EBS-backed AMIs. <code>EVENT_BASED_POLICY</code> indicates that the policy automates
         *        cross-account snapshot copies for snapshots that are shared with your account.
         * @see PolicyTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyTypeValues
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy manages the lifecycle of
         * Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code> indicates that the policy manages the lifecycle of
         * EBS-backed AMIs. <code>EVENT_BASED_POLICY</code> indicates that the policy automates cross-account snapshot
         * copies for snapshots that are shared with your account.
         * </p>
         * 
         * @param policyType
         *        The type of policy. <code>EBS_SNAPSHOT_MANAGEMENT</code> indicates that the policy manages the
         *        lifecycle of Amazon EBS snapshots. <code>IMAGE_MANAGEMENT</code> indicates that the policy manages the
         *        lifecycle of EBS-backed AMIs. <code>EVENT_BASED_POLICY</code> indicates that the policy automates
         *        cross-account snapshot copies for snapshots that are shared with your account.
         * @see PolicyTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyTypeValues
         */
        Builder policyType(PolicyTypeValues policyType);

        /**
         * <p>
         * <b>[Default policies only]</b> The type of default policy. Values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VOLUME</code> - Default policy for EBS snapshots
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE</code> - Default policy for EBS-backed AMIs
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultPolicy
         *        <b>[Default policies only]</b> The type of default policy. Values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VOLUME</code> - Default policy for EBS snapshots
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE</code> - Default policy for EBS-backed AMIs
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPolicy(Boolean defaultPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String policyId;

        private String description;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String policyType;

        private Boolean defaultPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicySummary model) {
            policyId(model.policyId);
            description(model.description);
            state(model.state);
            tags(model.tags);
            policyType(model.policyType);
            defaultPolicy(model.defaultPolicy);
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(GettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyTypeValues policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final Boolean getDefaultPolicy() {
            return defaultPolicy;
        }

        public final void setDefaultPolicy(Boolean defaultPolicy) {
            this.defaultPolicy = defaultPolicy;
        }

        @Override
        public final Builder defaultPolicy(Boolean defaultPolicy) {
            this.defaultPolicy = defaultPolicy;
            return this;
        }

        @Override
        public LifecyclePolicySummary build() {
            return new LifecyclePolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
