/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeprecateRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeprecateRule> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(DeprecateRule.getter(DeprecateRule::count)).setter(DeprecateRule.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()}).build();
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Interval").getter(DeprecateRule.getter(DeprecateRule::interval)).setter(DeprecateRule.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()}).build();
    private static final SdkField<String> INTERVAL_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntervalUnit").getter(DeprecateRule.getter(DeprecateRule::intervalUnitAsString)).setter(DeprecateRule.setter(Builder::intervalUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, INTERVAL_FIELD, INTERVAL_UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeprecateRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer count;
    private final Integer interval;
    private final String intervalUnit;

    private DeprecateRule(BuilderImpl builder) {
        this.count = builder.count;
        this.interval = builder.interval;
        this.intervalUnit = builder.intervalUnit;
    }

    public final Integer count() {
        return this.count;
    }

    public final Integer interval() {
        return this.interval;
    }

    public final RetentionIntervalUnitValues intervalUnit() {
        return RetentionIntervalUnitValues.fromValue(this.intervalUnit);
    }

    public final String intervalUnitAsString() {
        return this.intervalUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalUnitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecateRule)) {
            return false;
        }
        DeprecateRule other = (DeprecateRule)obj;
        return Objects.equals(this.count(), other.count()) && Objects.equals(this.interval(), other.interval()) && Objects.equals(this.intervalUnitAsString(), other.intervalUnitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeprecateRule").add("Count", (Object)this.count()).add("Interval", (Object)this.interval()).add("IntervalUnit", (Object)this.intervalUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "IntervalUnit": {
                return Optional.ofNullable(clazz.cast(this.intervalUnitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Count", COUNT_FIELD);
        map.put("Interval", INTERVAL_FIELD);
        map.put("IntervalUnit", INTERVAL_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeprecateRule, T> g) {
        return obj -> g.apply((DeprecateRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer count;
        private Integer interval;
        private String intervalUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecateRule model) {
            this.count(model.count);
            this.interval(model.interval);
            this.intervalUnit(model.intervalUnit);
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final String getIntervalUnit() {
            return this.intervalUnit;
        }

        public final void setIntervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
        }

        @Override
        public final Builder intervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
            return this;
        }

        @Override
        public final Builder intervalUnit(RetentionIntervalUnitValues intervalUnit) {
            this.intervalUnit(intervalUnit == null ? null : intervalUnit.toString());
            return this;
        }

        public DeprecateRule build() {
            return new DeprecateRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeprecateRule> {
        public Builder count(Integer var1);

        public Builder interval(Integer var1);

        public Builder intervalUnit(String var1);

        public Builder intervalUnit(RetentionIntervalUnitValues var1);
    }
}

