/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Bad request. The request is missing required parameters or has invalid parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidRequestException extends DlmException implements
        ToCopyableBuilder<InvalidRequestException.Builder, InvalidRequestException> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvalidRequestException::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<List<String>> REQUIRED_PARAMETERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(InvalidRequestException::requiredParameters))
            .setter(setter(Builder::requiredParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MUTUALLY_EXCLUSIVE_PARAMETERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(InvalidRequestException::mutuallyExclusiveParameters))
            .setter(setter(Builder::mutuallyExclusiveParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutuallyExclusiveParameters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD,
            REQUIRED_PARAMETERS_FIELD, MUTUALLY_EXCLUSIVE_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final List<String> requiredParameters;

    private final List<String> mutuallyExclusiveParameters;

    private InvalidRequestException(BuilderImpl builder) {
        super(builder);
        this.code = builder.code;
        this.requiredParameters = builder.requiredParameters;
        this.mutuallyExclusiveParameters = builder.mutuallyExclusiveParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Code property for this object.
     * 
     * @return The value of the Code property for this object.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * The request omitted one or more required parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The request omitted one or more required parameters.
     */
    public List<String> requiredParameters() {
        return requiredParameters;
    }

    /**
     * <p>
     * The request included parameters that cannot be provided together.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The request included parameters that cannot be provided together.
     */
    public List<String> mutuallyExclusiveParameters() {
        return mutuallyExclusiveParameters;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidRequestException, T> g) {
        return obj -> g.apply((InvalidRequestException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidRequestException>, DlmException.Builder {
        /**
         * Sets the value of the Code property for this object.
         *
         * @param code
         *        The new value for the Code property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The request omitted one or more required parameters.
         * </p>
         * 
         * @param requiredParameters
         *        The request omitted one or more required parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredParameters(Collection<String> requiredParameters);

        /**
         * <p>
         * The request omitted one or more required parameters.
         * </p>
         * 
         * @param requiredParameters
         *        The request omitted one or more required parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredParameters(String... requiredParameters);

        /**
         * <p>
         * The request included parameters that cannot be provided together.
         * </p>
         * 
         * @param mutuallyExclusiveParameters
         *        The request included parameters that cannot be provided together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutuallyExclusiveParameters(Collection<String> mutuallyExclusiveParameters);

        /**
         * <p>
         * The request included parameters that cannot be provided together.
         * </p>
         * 
         * @param mutuallyExclusiveParameters
         *        The request included parameters that cannot be provided together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutuallyExclusiveParameters(String... mutuallyExclusiveParameters);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends DlmException.BuilderImpl implements Builder {
        private String code;

        private List<String> requiredParameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> mutuallyExclusiveParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidRequestException model) {
            super(model);
            code(model.code);
            requiredParameters(model.requiredParameters);
            mutuallyExclusiveParameters(model.mutuallyExclusiveParameters);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final Collection<String> getRequiredParameters() {
            return requiredParameters;
        }

        @Override
        public final Builder requiredParameters(Collection<String> requiredParameters) {
            this.requiredParameters = ParameterListCopier.copy(requiredParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredParameters(String... requiredParameters) {
            requiredParameters(Arrays.asList(requiredParameters));
            return this;
        }

        public final void setRequiredParameters(Collection<String> requiredParameters) {
            this.requiredParameters = ParameterListCopier.copy(requiredParameters);
        }

        public final Collection<String> getMutuallyExclusiveParameters() {
            return mutuallyExclusiveParameters;
        }

        @Override
        public final Builder mutuallyExclusiveParameters(Collection<String> mutuallyExclusiveParameters) {
            this.mutuallyExclusiveParameters = ParameterListCopier.copy(mutuallyExclusiveParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mutuallyExclusiveParameters(String... mutuallyExclusiveParameters) {
            mutuallyExclusiveParameters(Arrays.asList(mutuallyExclusiveParameters));
            return this;
        }

        public final void setMutuallyExclusiveParameters(Collection<String> mutuallyExclusiveParameters) {
            this.mutuallyExclusiveParameters = ParameterListCopier.copy(mutuallyExclusiveParameters);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidRequestException build() {
            return new InvalidRequestException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
