/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration of a lifecycle policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyDetails implements SdkPojo, Serializable, ToCopyableBuilder<PolicyDetails.Builder, PolicyDetails> {
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyDetails::policyTypeAsString)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PolicyDetails::resourceTypesAsStrings))
            .setter(setter(Builder::resourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TARGET_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(PolicyDetails::targetTags))
            .setter(setter(Builder::targetTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Schedule>> SCHEDULES_FIELD = SdkField
            .<List<Schedule>> builder(MarshallingType.LIST)
            .getter(getter(PolicyDetails::schedules))
            .setter(setter(Builder::schedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Schedule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.<Parameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(PolicyDetails::parameters)).setter(setter(Builder::parameters)).constructor(Parameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_FIELD,
            RESOURCE_TYPES_FIELD, TARGET_TAGS_FIELD, SCHEDULES_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyType;

    private final List<String> resourceTypes;

    private final List<Tag> targetTags;

    private final List<Schedule> schedules;

    private final Parameters parameters;

    private PolicyDetails(BuilderImpl builder) {
        this.policyType = builder.policyType;
        this.resourceTypes = builder.resourceTypes;
        this.targetTags = builder.targetTags;
        this.schedules = builder.schedules;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * This field determines the valid target resource types and actions a policy can manage. This field defaults to
     * EBS_SNAPSHOT_MANAGEMENT if not present.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return This field determines the valid target resource types and actions a policy can manage. This field
     *         defaults to EBS_SNAPSHOT_MANAGEMENT if not present.
     * @see PolicyTypeValues
     */
    public PolicyTypeValues policyType() {
        return PolicyTypeValues.fromValue(policyType);
    }

    /**
     * <p>
     * This field determines the valid target resource types and actions a policy can manage. This field defaults to
     * EBS_SNAPSHOT_MANAGEMENT if not present.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return This field determines the valid target resource types and actions a policy can manage. This field
     *         defaults to EBS_SNAPSHOT_MANAGEMENT if not present.
     * @see PolicyTypeValues
     */
    public String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The resource type.
     */
    public List<ResourceTypeValues> resourceTypes() {
        return ResourceTypeValuesListCopier.copyStringToEnum(resourceTypes);
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The resource type.
     */
    public List<String> resourceTypesAsStrings() {
        return resourceTypes;
    }

    /**
     * <p>
     * The single tag that identifies targeted resources for this policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The single tag that identifies targeted resources for this policy.
     */
    public List<Tag> targetTags() {
        return targetTags;
    }

    /**
     * <p>
     * The schedule of policy-defined actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The schedule of policy-defined actions.
     */
    public List<Schedule> schedules() {
        return schedules;
    }

    /**
     * <p>
     * A set of optional parameters that can be provided by the policy.
     * </p>
     * 
     * @return A set of optional parameters that can be provided by the policy.
     */
    public Parameters parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(targetTags());
        hashCode = 31 * hashCode + Objects.hashCode(schedules());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDetails)) {
            return false;
        }
        PolicyDetails other = (PolicyDetails) obj;
        return Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(resourceTypesAsStrings(), other.resourceTypesAsStrings())
                && Objects.equals(targetTags(), other.targetTags()) && Objects.equals(schedules(), other.schedules())
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PolicyDetails").add("PolicyType", policyTypeAsString())
                .add("ResourceTypes", resourceTypesAsStrings()).add("TargetTags", targetTags()).add("Schedules", schedules())
                .add("Parameters", parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypesAsStrings()));
        case "TargetTags":
            return Optional.ofNullable(clazz.cast(targetTags()));
        case "Schedules":
            return Optional.ofNullable(clazz.cast(schedules()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyDetails, T> g) {
        return obj -> g.apply((PolicyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyDetails> {
        /**
         * <p>
         * This field determines the valid target resource types and actions a policy can manage. This field defaults to
         * EBS_SNAPSHOT_MANAGEMENT if not present.
         * </p>
         * 
         * @param policyType
         *        This field determines the valid target resource types and actions a policy can manage. This field
         *        defaults to EBS_SNAPSHOT_MANAGEMENT if not present.
         * @see PolicyTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyTypeValues
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * This field determines the valid target resource types and actions a policy can manage. This field defaults to
         * EBS_SNAPSHOT_MANAGEMENT if not present.
         * </p>
         * 
         * @param policyType
         *        This field determines the valid target resource types and actions a policy can manage. This field
         *        defaults to EBS_SNAPSHOT_MANAGEMENT if not present.
         * @see PolicyTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyTypeValues
         */
        Builder policyType(PolicyTypeValues policyType);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(Collection<String> resourceTypes);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(String... resourceTypes);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ResourceTypeValues> resourceTypes);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ResourceTypeValues... resourceTypes);

        /**
         * <p>
         * The single tag that identifies targeted resources for this policy.
         * </p>
         * 
         * @param targetTags
         *        The single tag that identifies targeted resources for this policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTags(Collection<Tag> targetTags);

        /**
         * <p>
         * The single tag that identifies targeted resources for this policy.
         * </p>
         * 
         * @param targetTags
         *        The single tag that identifies targeted resources for this policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTags(Tag... targetTags);

        /**
         * <p>
         * The single tag that identifies targeted resources for this policy.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #targetTags(List<Tag>)}.
         * 
         * @param targetTags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTags(List<Tag>)
         */
        Builder targetTags(Consumer<Tag.Builder>... targetTags);

        /**
         * <p>
         * The schedule of policy-defined actions.
         * </p>
         * 
         * @param schedules
         *        The schedule of policy-defined actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedules(Collection<Schedule> schedules);

        /**
         * <p>
         * The schedule of policy-defined actions.
         * </p>
         * 
         * @param schedules
         *        The schedule of policy-defined actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedules(Schedule... schedules);

        /**
         * <p>
         * The schedule of policy-defined actions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Schedule>.Builder} avoiding the need to
         * create one manually via {@link List<Schedule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Schedule>.Builder#build()} is called immediately and its
         * result is passed to {@link #schedules(List<Schedule>)}.
         * 
         * @param schedules
         *        a consumer that will call methods on {@link List<Schedule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedules(List<Schedule>)
         */
        Builder schedules(Consumer<Schedule.Builder>... schedules);

        /**
         * <p>
         * A set of optional parameters that can be provided by the policy.
         * </p>
         * 
         * @param parameters
         *        A set of optional parameters that can be provided by the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameters parameters);

        /**
         * <p>
         * A set of optional parameters that can be provided by the policy.
         * </p>
         * This is a convenience that creates an instance of the {@link Parameters.Builder} avoiding the need to create
         * one manually via {@link Parameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link Parameters.Builder#build()} is called immediately and its result
         * is passed to {@link #parameters(Parameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link Parameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(Parameters)
         */
        default Builder parameters(Consumer<Parameters.Builder> parameters) {
            return parameters(Parameters.builder().applyMutation(parameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String policyType;

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> targetTags = DefaultSdkAutoConstructList.getInstance();

        private List<Schedule> schedules = DefaultSdkAutoConstructList.getInstance();

        private Parameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDetails model) {
            policyType(model.policyType);
            resourceTypesWithStrings(model.resourceTypes);
            targetTags(model.targetTags);
            schedules(model.schedules);
            parameters(model.parameters);
        }

        public final String getPolicyTypeAsString() {
            return policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyTypeValues policyType) {
            this.policyType(policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final Collection<String> getResourceTypesAsStrings() {
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String... resourceTypes) {
            resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceTypeValues> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceTypeValues... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
        }

        public final Collection<Tag.Builder> getTargetTags() {
            return targetTags != null ? targetTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetTags(Collection<Tag> targetTags) {
            this.targetTags = TargetTagListCopier.copy(targetTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTags(Tag... targetTags) {
            targetTags(Arrays.asList(targetTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTags(Consumer<Tag.Builder>... targetTags) {
            targetTags(Stream.of(targetTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetTags(Collection<Tag.BuilderImpl> targetTags) {
            this.targetTags = TargetTagListCopier.copyFromBuilder(targetTags);
        }

        public final Collection<Schedule.Builder> getSchedules() {
            return schedules != null ? schedules.stream().map(Schedule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schedules(Collection<Schedule> schedules) {
            this.schedules = ScheduleListCopier.copy(schedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedules(Schedule... schedules) {
            schedules(Arrays.asList(schedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedules(Consumer<Schedule.Builder>... schedules) {
            schedules(Stream.of(schedules).map(c -> Schedule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchedules(Collection<Schedule.BuilderImpl> schedules) {
            this.schedules = ScheduleListCopier.copyFromBuilder(schedules);
        }

        public final Parameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public PolicyDetails build() {
            return new PolicyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
