/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input to <a>CreateGlobalCluster</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlobalClusterRequest extends DocDbRequest implements
        ToCopyableBuilder<CreateGlobalClusterRequest.Builder, CreateGlobalClusterRequest> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterIdentifier").getter(getter(CreateGlobalClusterRequest::globalClusterIdentifier))
            .setter(setter(Builder::globalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDBClusterIdentifier").getter(getter(CreateGlobalClusterRequest::sourceDBClusterIdentifier))
            .setter(setter(Builder::sourceDBClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterIdentifier").build())
            .build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateGlobalClusterRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateGlobalClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(CreateGlobalClusterRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(CreateGlobalClusterRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(CreateGlobalClusterRequest::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_CLUSTER_IDENTIFIER_FIELD, SOURCE_DB_CLUSTER_IDENTIFIER_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD,
            DELETION_PROTECTION_FIELD, DATABASE_NAME_FIELD, STORAGE_ENCRYPTED_FIELD));

    private final String globalClusterIdentifier;

    private final String sourceDBClusterIdentifier;

    private final String engine;

    private final String engineVersion;

    private final Boolean deletionProtection;

    private final String databaseName;

    private final Boolean storageEncrypted;

    private CreateGlobalClusterRequest(BuilderImpl builder) {
        super(builder);
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.deletionProtection = builder.deletionProtection;
        this.databaseName = builder.databaseName;
        this.storageEncrypted = builder.storageEncrypted;
    }

    /**
     * <p>
     * The cluster identifier of the new global cluster.
     * </p>
     * 
     * @return The cluster identifier of the new global cluster.
     */
    public final String globalClusterIdentifier() {
        return globalClusterIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is
     *         optional.
     */
    public final String sourceDBClusterIdentifier() {
        return sourceDBClusterIdentifier;
    }

    /**
     * <p>
     * The name of the database engine to be used for this cluster.
     * </p>
     * 
     * @return The name of the database engine to be used for this cluster.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The engine version of the global cluster.
     * </p>
     * 
     * @return The engine version of the global cluster.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion
     * protection is enabled.
     * </p>
     * 
     * @return The deletion protection setting for the new global cluster. The global cluster can't be deleted when
     *         deletion protection is enabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB
     * will not create a database in the global cluster you are creating.
     * </p>
     * 
     * @return The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon
     *         DocumentDB will not create a database in the global cluster you are creating.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The storage encryption setting for the new global cluster.
     * </p>
     * 
     * @return The storage encryption setting for the new global cluster.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalClusterRequest)) {
            return false;
        }
        CreateGlobalClusterRequest other = (CreateGlobalClusterRequest) obj;
        return Objects.equals(globalClusterIdentifier(), other.globalClusterIdentifier())
                && Objects.equals(sourceDBClusterIdentifier(), other.sourceDBClusterIdentifier())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(storageEncrypted(), other.storageEncrypted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlobalClusterRequest").add("GlobalClusterIdentifier", globalClusterIdentifier())
                .add("SourceDBClusterIdentifier", sourceDBClusterIdentifier()).add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("DeletionProtection", deletionProtection())
                .add("DatabaseName", databaseName()).add("StorageEncrypted", storageEncrypted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(globalClusterIdentifier()));
        case "SourceDBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDBClusterIdentifier()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGlobalClusterRequest, T> g) {
        return obj -> g.apply((CreateGlobalClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGlobalClusterRequest> {
        /**
         * <p>
         * The cluster identifier of the new global cluster.
         * </p>
         * 
         * @param globalClusterIdentifier
         *        The cluster identifier of the new global cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterIdentifier(String globalClusterIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is
         * optional.
         * </p>
         * 
         * @param sourceDBClusterIdentifier
         *        The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is
         *        optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier);

        /**
         * <p>
         * The name of the database engine to be used for this cluster.
         * </p>
         * 
         * @param engine
         *        The name of the database engine to be used for this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The engine version of the global cluster.
         * </p>
         * 
         * @param engineVersion
         *        The engine version of the global cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion
         * protection is enabled.
         * </p>
         * 
         * @param deletionProtection
         *        The deletion protection setting for the new global cluster. The global cluster can't be deleted when
         *        deletion protection is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon
         * DocumentDB will not create a database in the global cluster you are creating.
         * </p>
         * 
         * @param databaseName
         *        The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon
         *        DocumentDB will not create a database in the global cluster you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The storage encryption setting for the new global cluster.
         * </p>
         * 
         * @param storageEncrypted
         *        The storage encryption setting for the new global cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbRequest.BuilderImpl implements Builder {
        private String globalClusterIdentifier;

        private String sourceDBClusterIdentifier;

        private String engine;

        private String engineVersion;

        private Boolean deletionProtection;

        private String databaseName;

        private Boolean storageEncrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalClusterRequest model) {
            super(model);
            globalClusterIdentifier(model.globalClusterIdentifier);
            sourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            engine(model.engine);
            engineVersion(model.engineVersion);
            deletionProtection(model.deletionProtection);
            databaseName(model.databaseName);
            storageEncrypted(model.storageEncrypted);
        }

        public final String getGlobalClusterIdentifier() {
            return globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        public final String getSourceDBClusterIdentifier() {
            return sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlobalClusterRequest build() {
            return new CreateGlobalClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
