/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBCluster implements SdkPojo, Serializable, ToCopyableBuilder<DBCluster.Builder, DBCluster> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(DBCluster::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").build()).build()).build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(DBCluster::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(DBCluster::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroup").getter(getter(DBCluster::dbClusterParameterGroup))
            .setter(setter(Builder::dbClusterParameterGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroup").build())
            .build();

    private static final SdkField<String> DB_SUBNET_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroup").getter(getter(DBCluster::dbSubnetGroup)).setter(setter(Builder::dbSubnetGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DBCluster::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> PERCENT_PROGRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PercentProgress").getter(getter(DBCluster::percentProgress)).setter(setter(Builder::percentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()).build();

    private static final SdkField<Instant> EARLIEST_RESTORABLE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EarliestRestorableTime").getter(getter(DBCluster::earliestRestorableTime))
            .setter(setter(Builder::earliestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestRestorableTime").build())
            .build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(DBCluster::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> READER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReaderEndpoint").getter(getter(DBCluster::readerEndpoint)).setter(setter(Builder::readerEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderEndpoint").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(DBCluster::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DBCluster::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DBCluster::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Instant> LATEST_RESTORABLE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestRestorableTime").getter(getter(DBCluster::latestRestorableTime))
            .setter(setter(Builder::latestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableTime").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(DBCluster::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(DBCluster::masterUsername)).setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(DBCluster::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(DBCluster::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> REPLICATION_SOURCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSourceIdentifier")
            .getter(getter(DBCluster::replicationSourceIdentifier))
            .setter(setter(Builder::replicationSourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSourceIdentifier")
                    .build()).build();

    private static final SdkField<List<String>> READ_REPLICA_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadReplicaIdentifiers")
            .getter(getter(DBCluster::readReplicaIdentifiers))
            .setter(setter(Builder::readReplicaIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReadReplicaIdentifier")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReadReplicaIdentifier").build()).build()).build()).build();

    private static final SdkField<List<DBClusterMember>> DB_CLUSTER_MEMBERS_FIELD = SdkField
            .<List<DBClusterMember>> builder(MarshallingType.LIST)
            .memberName("DBClusterMembers")
            .getter(getter(DBCluster::dbClusterMembers))
            .setter(setter(Builder::dbClusterMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterMember")
                            .memberFieldInfo(
                                    SdkField.<DBClusterMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterMember").build()).build()).build()).build();

    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<VpcSecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroups")
            .getter(getter(DBCluster::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupMembership")
                            .memberFieldInfo(
                                    SdkField.<VpcSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupMembership").build()).build()).build())
            .build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId").getter(getter(DBCluster::hostedZoneId)).setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").build()).build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(DBCluster::storageEncrypted)).setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DBCluster::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> DB_CLUSTER_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbClusterResourceId").getter(getter(DBCluster::dbClusterResourceId))
            .setter(setter(Builder::dbClusterResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterResourceId").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterArn").getter(getter(DBCluster::dbClusterArn)).setter(setter(Builder::dbClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterArn").build()).build();

    private static final SdkField<List<DBClusterRole>> ASSOCIATED_ROLES_FIELD = SdkField
            .<List<DBClusterRole>> builder(MarshallingType.LIST)
            .memberName("AssociatedRoles")
            .getter(getter(DBCluster::associatedRoles))
            .setter(setter(Builder::associatedRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterRole")
                            .memberFieldInfo(
                                    SdkField.<DBClusterRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterRole").build()).build()).build()).build();

    private static final SdkField<Instant> CLUSTER_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ClusterCreateTime").getter(getter(DBCluster::clusterCreateTime))
            .setter(setter(Builder::clusterCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()).build();

    private static final SdkField<List<String>> ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledCloudwatchLogsExports")
            .getter(getter(DBCluster::enabledCloudwatchLogsExports))
            .setter(setter(Builder::enabledCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(DBCluster::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            BACKUP_RETENTION_PERIOD_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_PARAMETER_GROUP_FIELD, DB_SUBNET_GROUP_FIELD,
            STATUS_FIELD, PERCENT_PROGRESS_FIELD, EARLIEST_RESTORABLE_TIME_FIELD, ENDPOINT_FIELD, READER_ENDPOINT_FIELD,
            MULTI_AZ_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, LATEST_RESTORABLE_TIME_FIELD, PORT_FIELD, MASTER_USERNAME_FIELD,
            PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, REPLICATION_SOURCE_IDENTIFIER_FIELD,
            READ_REPLICA_IDENTIFIERS_FIELD, DB_CLUSTER_MEMBERS_FIELD, VPC_SECURITY_GROUPS_FIELD, HOSTED_ZONE_ID_FIELD,
            STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DB_CLUSTER_RESOURCE_ID_FIELD, DB_CLUSTER_ARN_FIELD,
            ASSOCIATED_ROLES_FIELD, CLUSTER_CREATE_TIME_FIELD, ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD, DELETION_PROTECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> availabilityZones;

    private final Integer backupRetentionPeriod;

    private final String dbClusterIdentifier;

    private final String dbClusterParameterGroup;

    private final String dbSubnetGroup;

    private final String status;

    private final String percentProgress;

    private final Instant earliestRestorableTime;

    private final String endpoint;

    private final String readerEndpoint;

    private final Boolean multiAZ;

    private final String engine;

    private final String engineVersion;

    private final Instant latestRestorableTime;

    private final Integer port;

    private final String masterUsername;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final String replicationSourceIdentifier;

    private final List<String> readReplicaIdentifiers;

    private final List<DBClusterMember> dbClusterMembers;

    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;

    private final String hostedZoneId;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final String dbClusterResourceId;

    private final String dbClusterArn;

    private final List<DBClusterRole> associatedRoles;

    private final Instant clusterCreateTime;

    private final List<String> enabledCloudwatchLogsExports;

    private final Boolean deletionProtection;

    private DBCluster(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroup = builder.dbClusterParameterGroup;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.status = builder.status;
        this.percentProgress = builder.percentProgress;
        this.earliestRestorableTime = builder.earliestRestorableTime;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.multiAZ = builder.multiAZ;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
        this.readReplicaIdentifiers = builder.readReplicaIdentifiers;
        this.dbClusterMembers = builder.dbClusterMembers;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.hostedZoneId = builder.hostedZoneId;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterResourceId = builder.dbClusterResourceId;
        this.dbClusterArn = builder.dbClusterArn;
        this.associatedRoles = builder.associatedRoles;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.enabledCloudwatchLogsExports = builder.enabledCloudwatchLogsExports;
        this.deletionProtection = builder.deletionProtection;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the list of Amazon EC2 Availability Zones that instances in the cluster can be created in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides the list of Amazon EC2 Availability Zones that instances in the cluster can be created in.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * Specifies the number of days for which automatic snapshots are retained.
     * </p>
     * 
     * @return Specifies the number of days for which automatic snapshots are retained.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * Contains a user-supplied cluster identifier. This identifier is the unique key that identifies a cluster.
     * </p>
     * 
     * @return Contains a user-supplied cluster identifier. This identifier is the unique key that identifies a cluster.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * Specifies the name of the cluster parameter group for the cluster.
     * </p>
     * 
     * @return Specifies the name of the cluster parameter group for the cluster.
     */
    public final String dbClusterParameterGroup() {
        return dbClusterParameterGroup;
    }

    /**
     * <p>
     * Specifies information on the subnet group that is associated with the cluster, including the name, description,
     * and subnets in the subnet group.
     * </p>
     * 
     * @return Specifies information on the subnet group that is associated with the cluster, including the name,
     *         description, and subnets in the subnet group.
     */
    public final String dbSubnetGroup() {
        return dbSubnetGroup;
    }

    /**
     * <p>
     * Specifies the current state of this cluster.
     * </p>
     * 
     * @return Specifies the current state of this cluster.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Specifies the progress of the operation as a percentage.
     * </p>
     * 
     * @return Specifies the progress of the operation as a percentage.
     */
    public final String percentProgress() {
        return percentProgress;
    }

    /**
     * <p>
     * The earliest time to which a database can be restored with point-in-time restore.
     * </p>
     * 
     * @return The earliest time to which a database can be restored with point-in-time restore.
     */
    public final Instant earliestRestorableTime() {
        return earliestRestorableTime;
    }

    /**
     * <p>
     * Specifies the connection endpoint for the primary instance of the cluster.
     * </p>
     * 
     * @return Specifies the connection endpoint for the primary instance of the cluster.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the
     * Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader
     * endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the
     * cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in
     * your cluster.
     * </p>
     * <p>
     * If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary
     * instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas
     * in the cluster, you can then reconnect to the reader endpoint.
     * </p>
     * 
     * @return The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across
     *         the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the
     *         reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB
     *         replicas in the cluster. This functionality can help balance your read workload across multiple Amazon
     *         DocumentDB replicas in your cluster. </p>
     *         <p>
     *         If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the
     *         primary instance, your connection is dropped. To continue sending your read workload to other Amazon
     *         DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.
     */
    public final String readerEndpoint() {
        return readerEndpoint;
    }

    /**
     * <p>
     * Specifies whether the cluster has instances in multiple Availability Zones.
     * </p>
     * 
     * @return Specifies whether the cluster has instances in multiple Availability Zones.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * Provides the name of the database engine to be used for this cluster.
     * </p>
     * 
     * @return Provides the name of the database engine to be used for this cluster.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     * 
     * @return Indicates the database engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     * </p>
     * 
     * @return Specifies the latest time to which a database can be restored with point-in-time restore.
     */
    public final Instant latestRestorableTime() {
        return latestRestorableTime;
    }

    /**
     * <p>
     * Specifies the port that the database engine is listening on.
     * </p>
     * 
     * @return Specifies the port that the database engine is listening on.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Contains the master user name for the cluster.
     * </p>
     * 
     * @return Contains the master user name for the cluster.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as
     * determined by the <code>BackupRetentionPeriod</code>.
     * </p>
     * 
     * @return Specifies the daily time range during which automated backups are created if automated backups are
     *         enabled, as determined by the <code>BackupRetentionPeriod</code>.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time
     *         (UTC).
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Contains the identifier of the source cluster if this cluster is a secondary cluster.
     * </p>
     * 
     * @return Contains the identifier of the source cluster if this cluster is a secondary cluster.
     */
    public final String replicationSourceIdentifier() {
        return replicationSourceIdentifier;
    }

    /**
     * Returns true if the ReadReplicaIdentifiers property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReadReplicaIdentifiers() {
        return readReplicaIdentifiers != null && !(readReplicaIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains one or more identifiers of the secondary clusters that are associated with this cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReadReplicaIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains one or more identifiers of the secondary clusters that are associated with this cluster.
     */
    public final List<String> readReplicaIdentifiers() {
        return readReplicaIdentifiers;
    }

    /**
     * Returns true if the DBClusterMembers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDbClusterMembers() {
        return dbClusterMembers != null && !(dbClusterMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the list of instances that make up the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbClusterMembers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides the list of instances that make up the cluster.
     */
    public final List<DBClusterMember> dbClusterMembers() {
        return dbClusterMembers;
    }

    /**
     * Returns true if the VpcSecurityGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of virtual private cloud (VPC) security groups that the cluster belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides a list of virtual private cloud (VPC) security groups that the cluster belongs to.
     */
    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    /**
     * <p>
     * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     * </p>
     * 
     * @return Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * Specifies whether the cluster is encrypted.
     * </p>
     * 
     * @return Specifies whether the cluster is encrypted.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted cluster.
     * </p>
     * 
     * @return If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Region-unique, immutable identifier for the cluster. This identifier is found in CloudTrail log entries
     * whenever the KMS key for the cluster is accessed.
     * </p>
     * 
     * @return The Region-unique, immutable identifier for the cluster. This identifier is found in CloudTrail log
     *         entries whenever the KMS key for the cluster is accessed.
     */
    public final String dbClusterResourceId() {
        return dbClusterResourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the cluster.
     */
    public final String dbClusterArn() {
        return dbClusterArn;
    }

    /**
     * Returns true if the AssociatedRoles property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAssociatedRoles() {
        return associatedRoles != null && !(associatedRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM)
     * roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services
     * services on your behalf.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssociatedRoles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster.
     *         (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon
     *         Web Services services on your behalf.
     */
    public final List<DBClusterRole> associatedRoles() {
        return associatedRoles;
    }

    /**
     * <p>
     * Specifies the time when the cluster was created, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return Specifies the time when the cluster was created, in Universal Coordinated Time (UTC).
     */
    public final Instant clusterCreateTime() {
        return clusterCreateTime;
    }

    /**
     * Returns true if the EnabledCloudwatchLogsExports property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasEnabledCloudwatchLogsExports() {
        return enabledCloudwatchLogsExports != null && !(enabledCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log types that this cluster is configured to export to Amazon CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnabledCloudwatchLogsExports()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of log types that this cluster is configured to export to Amazon CloudWatch Logs.
     */
    public final List<String> enabledCloudwatchLogsExports() {
        return enabledCloudwatchLogsExports;
    }

    /**
     * <p>
     * Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot
     * be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
     * protects clusters from being accidentally deleted.
     * </p>
     * 
     * @return Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster
     *         cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
     *         <code>DeletionProtection</code> protects clusters from being accidentally deleted.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(earliestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasReadReplicaIdentifiers() ? readReplicaIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDbClusterMembers() ? dbClusterMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroups() ? vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedRoles() ? associatedRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledCloudwatchLogsExports() ? enabledCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBCluster)) {
            return false;
        }
        DBCluster other = (DBCluster) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(dbClusterParameterGroup(), other.dbClusterParameterGroup())
                && Objects.equals(dbSubnetGroup(), other.dbSubnetGroup()) && Objects.equals(status(), other.status())
                && Objects.equals(percentProgress(), other.percentProgress())
                && Objects.equals(earliestRestorableTime(), other.earliestRestorableTime())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(readerEndpoint(), other.readerEndpoint())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(latestRestorableTime(), other.latestRestorableTime()) && Objects.equals(port(), other.port())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(replicationSourceIdentifier(), other.replicationSourceIdentifier())
                && hasReadReplicaIdentifiers() == other.hasReadReplicaIdentifiers()
                && Objects.equals(readReplicaIdentifiers(), other.readReplicaIdentifiers())
                && hasDbClusterMembers() == other.hasDbClusterMembers()
                && Objects.equals(dbClusterMembers(), other.dbClusterMembers())
                && hasVpcSecurityGroups() == other.hasVpcSecurityGroups()
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups())
                && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dbClusterResourceId(), other.dbClusterResourceId())
                && Objects.equals(dbClusterArn(), other.dbClusterArn()) && hasAssociatedRoles() == other.hasAssociatedRoles()
                && Objects.equals(associatedRoles(), other.associatedRoles())
                && Objects.equals(clusterCreateTime(), other.clusterCreateTime())
                && hasEnabledCloudwatchLogsExports() == other.hasEnabledCloudwatchLogsExports()
                && Objects.equals(enabledCloudwatchLogsExports(), other.enabledCloudwatchLogsExports())
                && Objects.equals(deletionProtection(), other.deletionProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBCluster").add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("BackupRetentionPeriod", backupRetentionPeriod()).add("DBClusterIdentifier", dbClusterIdentifier())
                .add("DBClusterParameterGroup", dbClusterParameterGroup()).add("DBSubnetGroup", dbSubnetGroup())
                .add("Status", status()).add("PercentProgress", percentProgress())
                .add("EarliestRestorableTime", earliestRestorableTime()).add("Endpoint", endpoint())
                .add("ReaderEndpoint", readerEndpoint()).add("MultiAZ", multiAZ()).add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("LatestRestorableTime", latestRestorableTime()).add("Port", port())
                .add("MasterUsername", masterUsername()).add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("ReplicationSourceIdentifier", replicationSourceIdentifier())
                .add("ReadReplicaIdentifiers", hasReadReplicaIdentifiers() ? readReplicaIdentifiers() : null)
                .add("DBClusterMembers", hasDbClusterMembers() ? dbClusterMembers() : null)
                .add("VpcSecurityGroups", hasVpcSecurityGroups() ? vpcSecurityGroups() : null)
                .add("HostedZoneId", hostedZoneId()).add("StorageEncrypted", storageEncrypted()).add("KmsKeyId", kmsKeyId())
                .add("DbClusterResourceId", dbClusterResourceId()).add("DBClusterArn", dbClusterArn())
                .add("AssociatedRoles", hasAssociatedRoles() ? associatedRoles() : null)
                .add("ClusterCreateTime", clusterCreateTime())
                .add("EnabledCloudwatchLogsExports", hasEnabledCloudwatchLogsExports() ? enabledCloudwatchLogsExports() : null)
                .add("DeletionProtection", deletionProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "DBClusterParameterGroup":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroup()));
        case "DBSubnetGroup":
            return Optional.ofNullable(clazz.cast(dbSubnetGroup()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "PercentProgress":
            return Optional.ofNullable(clazz.cast(percentProgress()));
        case "EarliestRestorableTime":
            return Optional.ofNullable(clazz.cast(earliestRestorableTime()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "ReaderEndpoint":
            return Optional.ofNullable(clazz.cast(readerEndpoint()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "LatestRestorableTime":
            return Optional.ofNullable(clazz.cast(latestRestorableTime()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "ReplicationSourceIdentifier":
            return Optional.ofNullable(clazz.cast(replicationSourceIdentifier()));
        case "ReadReplicaIdentifiers":
            return Optional.ofNullable(clazz.cast(readReplicaIdentifiers()));
        case "DBClusterMembers":
            return Optional.ofNullable(clazz.cast(dbClusterMembers()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "DbClusterResourceId":
            return Optional.ofNullable(clazz.cast(dbClusterResourceId()));
        case "DBClusterArn":
            return Optional.ofNullable(clazz.cast(dbClusterArn()));
        case "AssociatedRoles":
            return Optional.ofNullable(clazz.cast(associatedRoles()));
        case "ClusterCreateTime":
            return Optional.ofNullable(clazz.cast(clusterCreateTime()));
        case "EnabledCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enabledCloudwatchLogsExports()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBCluster, T> g) {
        return obj -> g.apply((DBCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBCluster> {
        /**
         * <p>
         * Provides the list of Amazon EC2 Availability Zones that instances in the cluster can be created in.
         * </p>
         * 
         * @param availabilityZones
         *        Provides the list of Amazon EC2 Availability Zones that instances in the cluster can be created in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * Provides the list of Amazon EC2 Availability Zones that instances in the cluster can be created in.
         * </p>
         * 
         * @param availabilityZones
         *        Provides the list of Amazon EC2 Availability Zones that instances in the cluster can be created in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * Specifies the number of days for which automatic snapshots are retained.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        Specifies the number of days for which automatic snapshots are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * Contains a user-supplied cluster identifier. This identifier is the unique key that identifies a cluster.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        Contains a user-supplied cluster identifier. This identifier is the unique key that identifies a
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Specifies the name of the cluster parameter group for the cluster.
         * </p>
         * 
         * @param dbClusterParameterGroup
         *        Specifies the name of the cluster parameter group for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroup(String dbClusterParameterGroup);

        /**
         * <p>
         * Specifies information on the subnet group that is associated with the cluster, including the name,
         * description, and subnets in the subnet group.
         * </p>
         * 
         * @param dbSubnetGroup
         *        Specifies information on the subnet group that is associated with the cluster, including the name,
         *        description, and subnets in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroup(String dbSubnetGroup);

        /**
         * <p>
         * Specifies the current state of this cluster.
         * </p>
         * 
         * @param status
         *        Specifies the current state of this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the progress of the operation as a percentage.
         * </p>
         * 
         * @param percentProgress
         *        Specifies the progress of the operation as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentProgress(String percentProgress);

        /**
         * <p>
         * The earliest time to which a database can be restored with point-in-time restore.
         * </p>
         * 
         * @param earliestRestorableTime
         *        The earliest time to which a database can be restored with point-in-time restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestRestorableTime(Instant earliestRestorableTime);

        /**
         * <p>
         * Specifies the connection endpoint for the primary instance of the cluster.
         * </p>
         * 
         * @param endpoint
         *        Specifies the connection endpoint for the primary instance of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the
         * Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader
         * endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the
         * cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in
         * your cluster.
         * </p>
         * <p>
         * If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the
         * primary instance, your connection is dropped. To continue sending your read workload to other Amazon
         * DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.
         * </p>
         * 
         * @param readerEndpoint
         *        The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections
         *        across the Amazon DocumentDB replicas that are available in a cluster. As clients request new
         *        connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the
         *        Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload
         *        across multiple Amazon DocumentDB replicas in your cluster. </p>
         *        <p>
         *        If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be
         *        the primary instance, your connection is dropped. To continue sending your read workload to other
         *        Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readerEndpoint(String readerEndpoint);

        /**
         * <p>
         * Specifies whether the cluster has instances in multiple Availability Zones.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the cluster has instances in multiple Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * Provides the name of the database engine to be used for this cluster.
         * </p>
         * 
         * @param engine
         *        Provides the name of the database engine to be used for this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Indicates the database engine version.
         * </p>
         * 
         * @param engineVersion
         *        Indicates the database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         * </p>
         * 
         * @param latestRestorableTime
         *        Specifies the latest time to which a database can be restored with point-in-time restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRestorableTime(Instant latestRestorableTime);

        /**
         * <p>
         * Specifies the port that the database engine is listening on.
         * </p>
         * 
         * @param port
         *        Specifies the port that the database engine is listening on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Contains the master user name for the cluster.
         * </p>
         * 
         * @param masterUsername
         *        Contains the master user name for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * Specifies the daily time range during which automated backups are created if automated backups are enabled,
         * as determined by the <code>BackupRetentionPeriod</code>.
         * </p>
         * 
         * @param preferredBackupWindow
         *        Specifies the daily time range during which automated backups are created if automated backups are
         *        enabled, as determined by the <code>BackupRetentionPeriod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time
         * (UTC).
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Contains the identifier of the source cluster if this cluster is a secondary cluster.
         * </p>
         * 
         * @param replicationSourceIdentifier
         *        Contains the identifier of the source cluster if this cluster is a secondary cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSourceIdentifier(String replicationSourceIdentifier);

        /**
         * <p>
         * Contains one or more identifiers of the secondary clusters that are associated with this cluster.
         * </p>
         * 
         * @param readReplicaIdentifiers
         *        Contains one or more identifiers of the secondary clusters that are associated with this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers);

        /**
         * <p>
         * Contains one or more identifiers of the secondary clusters that are associated with this cluster.
         * </p>
         * 
         * @param readReplicaIdentifiers
         *        Contains one or more identifiers of the secondary clusters that are associated with this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaIdentifiers(String... readReplicaIdentifiers);

        /**
         * <p>
         * Provides the list of instances that make up the cluster.
         * </p>
         * 
         * @param dbClusterMembers
         *        Provides the list of instances that make up the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterMembers(Collection<DBClusterMember> dbClusterMembers);

        /**
         * <p>
         * Provides the list of instances that make up the cluster.
         * </p>
         * 
         * @param dbClusterMembers
         *        Provides the list of instances that make up the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterMembers(DBClusterMember... dbClusterMembers);

        /**
         * <p>
         * Provides the list of instances that make up the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBClusterMember>.Builder} avoiding the need
         * to create one manually via {@link List<DBClusterMember>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBClusterMember>.Builder#build()} is called immediately and
         * its result is passed to {@link #dbClusterMembers(List<DBClusterMember>)}.
         * 
         * @param dbClusterMembers
         *        a consumer that will call methods on {@link List<DBClusterMember>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterMembers(List<DBClusterMember>)
         */
        Builder dbClusterMembers(Consumer<DBClusterMember.Builder>... dbClusterMembers);

        /**
         * <p>
         * Provides a list of virtual private cloud (VPC) security groups that the cluster belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        Provides a list of virtual private cloud (VPC) security groups that the cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups);

        /**
         * <p>
         * Provides a list of virtual private cloud (VPC) security groups that the cluster belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        Provides a list of virtual private cloud (VPC) security groups that the cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups);

        /**
         * <p>
         * Provides a list of virtual private cloud (VPC) security groups that the cluster belongs to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcSecurityGroupMembership>.Builder}
         * avoiding the need to create one manually via {@link List<VpcSecurityGroupMembership>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcSecurityGroupMembership>.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcSecurityGroups(List<VpcSecurityGroupMembership>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on {@link List<VpcSecurityGroupMembership>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(List<VpcSecurityGroupMembership>)
         */
        Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups);

        /**
         * <p>
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * Specifies whether the cluster is encrypted.
         * </p>
         * 
         * @param storageEncrypted
         *        Specifies whether the cluster is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Region-unique, immutable identifier for the cluster. This identifier is found in CloudTrail log entries
         * whenever the KMS key for the cluster is accessed.
         * </p>
         * 
         * @param dbClusterResourceId
         *        The Region-unique, immutable identifier for the cluster. This identifier is found in CloudTrail log
         *        entries whenever the KMS key for the cluster is accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterResourceId(String dbClusterResourceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the cluster.
         * </p>
         * 
         * @param dbClusterArn
         *        The Amazon Resource Name (ARN) for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterArn(String dbClusterArn);

        /**
         * <p>
         * Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM)
         * roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services
         * services on your behalf.
         * </p>
         * 
         * @param associatedRoles
         *        Provides a list of the Identity and Access Management (IAM) roles that are associated with the
         *        cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access
         *        other Amazon Web Services services on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(Collection<DBClusterRole> associatedRoles);

        /**
         * <p>
         * Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM)
         * roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services
         * services on your behalf.
         * </p>
         * 
         * @param associatedRoles
         *        Provides a list of the Identity and Access Management (IAM) roles that are associated with the
         *        cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access
         *        other Amazon Web Services services on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(DBClusterRole... associatedRoles);

        /**
         * <p>
         * Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM)
         * roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services
         * services on your behalf.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBClusterRole>.Builder} avoiding the need
         * to create one manually via {@link List<DBClusterRole>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBClusterRole>.Builder#build()} is called immediately and
         * its result is passed to {@link #associatedRoles(List<DBClusterRole>)}.
         * 
         * @param associatedRoles
         *        a consumer that will call methods on {@link List<DBClusterRole>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedRoles(List<DBClusterRole>)
         */
        Builder associatedRoles(Consumer<DBClusterRole.Builder>... associatedRoles);

        /**
         * <p>
         * Specifies the time when the cluster was created, in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param clusterCreateTime
         *        Specifies the time when the cluster was created, in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCreateTime(Instant clusterCreateTime);

        /**
         * <p>
         * A list of log types that this cluster is configured to export to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudwatchLogsExports
         *        A list of log types that this cluster is configured to export to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports);

        /**
         * <p>
         * A list of log types that this cluster is configured to export to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudwatchLogsExports
         *        A list of log types that this cluster is configured to export to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudwatchLogsExports(String... enabledCloudwatchLogsExports);

        /**
         * <p>
         * Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster
         * cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
         * <code>DeletionProtection</code> protects clusters from being accidentally deleted.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the
         *        cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
         *        <code>DeletionProtection</code> protects clusters from being accidentally deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);
    }

    static final class BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private Integer backupRetentionPeriod;

        private String dbClusterIdentifier;

        private String dbClusterParameterGroup;

        private String dbSubnetGroup;

        private String status;

        private String percentProgress;

        private Instant earliestRestorableTime;

        private String endpoint;

        private String readerEndpoint;

        private Boolean multiAZ;

        private String engine;

        private String engineVersion;

        private Instant latestRestorableTime;

        private Integer port;

        private String masterUsername;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private String replicationSourceIdentifier;

        private List<String> readReplicaIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<DBClusterMember> dbClusterMembers = DefaultSdkAutoConstructList.getInstance();

        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private String hostedZoneId;

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private String dbClusterResourceId;

        private String dbClusterArn;

        private List<DBClusterRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();

        private Instant clusterCreateTime;

        private List<String> enabledCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private Boolean deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(DBCluster model) {
            availabilityZones(model.availabilityZones);
            backupRetentionPeriod(model.backupRetentionPeriod);
            dbClusterIdentifier(model.dbClusterIdentifier);
            dbClusterParameterGroup(model.dbClusterParameterGroup);
            dbSubnetGroup(model.dbSubnetGroup);
            status(model.status);
            percentProgress(model.percentProgress);
            earliestRestorableTime(model.earliestRestorableTime);
            endpoint(model.endpoint);
            readerEndpoint(model.readerEndpoint);
            multiAZ(model.multiAZ);
            engine(model.engine);
            engineVersion(model.engineVersion);
            latestRestorableTime(model.latestRestorableTime);
            port(model.port);
            masterUsername(model.masterUsername);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            replicationSourceIdentifier(model.replicationSourceIdentifier);
            readReplicaIdentifiers(model.readReplicaIdentifiers);
            dbClusterMembers(model.dbClusterMembers);
            vpcSecurityGroups(model.vpcSecurityGroups);
            hostedZoneId(model.hostedZoneId);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            dbClusterResourceId(model.dbClusterResourceId);
            dbClusterArn(model.dbClusterArn);
            associatedRoles(model.associatedRoles);
            clusterCreateTime(model.clusterCreateTime);
            enabledCloudwatchLogsExports(model.enabledCloudwatchLogsExports);
            deletionProtection(model.deletionProtection);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDbClusterParameterGroup() {
            return dbClusterParameterGroup;
        }

        @Override
        public final Builder dbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
            return this;
        }

        public final void setDbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
        }

        public final String getDbSubnetGroup() {
            return dbSubnetGroup;
        }

        @Override
        public final Builder dbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final void setDbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getPercentProgress() {
            return percentProgress;
        }

        @Override
        public final Builder percentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final void setPercentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
        }

        public final Instant getEarliestRestorableTime() {
            return earliestRestorableTime;
        }

        @Override
        public final Builder earliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
            return this;
        }

        public final void setEarliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getReaderEndpoint() {
            return readerEndpoint;
        }

        @Override
        public final Builder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final void setReaderEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Instant getLatestRestorableTime() {
            return latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getReplicationSourceIdentifier() {
            return replicationSourceIdentifier;
        }

        @Override
        public final Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        public final void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
        }

        public final Collection<String> getReadReplicaIdentifiers() {
            if (readReplicaIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return readReplicaIdentifiers;
        }

        @Override
        public final Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaIdentifiers(String... readReplicaIdentifiers) {
            readReplicaIdentifiers(Arrays.asList(readReplicaIdentifiers));
            return this;
        }

        public final void setReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
        }

        public final List<DBClusterMember.Builder> getDbClusterMembers() {
            List<DBClusterMember.Builder> result = DBClusterMemberListCopier.copyToBuilder(this.dbClusterMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dbClusterMembers(Collection<DBClusterMember> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copy(dbClusterMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(DBClusterMember... dbClusterMembers) {
            dbClusterMembers(Arrays.asList(dbClusterMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(Consumer<DBClusterMember.Builder>... dbClusterMembers) {
            dbClusterMembers(Stream.of(dbClusterMembers).map(c -> DBClusterMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDbClusterMembers(Collection<DBClusterMember.BuilderImpl> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copyFromBuilder(dbClusterMembers);
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier
                    .copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> VpcSecurityGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDbClusterResourceId() {
            return dbClusterResourceId;
        }

        @Override
        public final Builder dbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
            return this;
        }

        public final void setDbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
        }

        public final String getDbClusterArn() {
            return dbClusterArn;
        }

        @Override
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final void setDbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        public final List<DBClusterRole.Builder> getAssociatedRoles() {
            List<DBClusterRole.Builder> result = DBClusterRolesCopier.copyToBuilder(this.associatedRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder associatedRoles(Collection<DBClusterRole> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(DBClusterRole... associatedRoles) {
            associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<DBClusterRole.Builder>... associatedRoles) {
            associatedRoles(Stream.of(associatedRoles).map(c -> DBClusterRole.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssociatedRoles(Collection<DBClusterRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copyFromBuilder(associatedRoles);
        }

        public final Instant getClusterCreateTime() {
            return clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        public final Collection<String> getEnabledCloudwatchLogsExports() {
            if (enabledCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledCloudwatchLogsExports;
        }

        @Override
        public final Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledCloudwatchLogsExports(String... enabledCloudwatchLogsExports) {
            enabledCloudwatchLogsExports(Arrays.asList(enabledCloudwatchLogsExports));
            return this;
        }

        public final void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public DBCluster build() {
            return new DBCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
