/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbClusterSnapshotAttributesResponse extends DocDbResponse implements
        ToCopyableBuilder<DescribeDbClusterSnapshotAttributesResponse.Builder, DescribeDbClusterSnapshotAttributesResponse> {
    private static final SdkField<DBClusterSnapshotAttributesResult> DB_CLUSTER_SNAPSHOT_ATTRIBUTES_RESULT_FIELD = SdkField
            .<DBClusterSnapshotAttributesResult> builder(MarshallingType.SDK_POJO)
            .memberName("DBClusterSnapshotAttributesResult")
            .getter(getter(DescribeDbClusterSnapshotAttributesResponse::dbClusterSnapshotAttributesResult))
            .setter(setter(Builder::dbClusterSnapshotAttributesResult))
            .constructor(DBClusterSnapshotAttributesResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotAttributesResult")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DB_CLUSTER_SNAPSHOT_ATTRIBUTES_RESULT_FIELD));

    private final DBClusterSnapshotAttributesResult dbClusterSnapshotAttributesResult;

    private DescribeDbClusterSnapshotAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterSnapshotAttributesResult = builder.dbClusterSnapshotAttributesResult;
    }

    /**
     * Returns the value of the DBClusterSnapshotAttributesResult property for this object.
     * 
     * @return The value of the DBClusterSnapshotAttributesResult property for this object.
     */
    public final DBClusterSnapshotAttributesResult dbClusterSnapshotAttributesResult() {
        return dbClusterSnapshotAttributesResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterSnapshotAttributesResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterSnapshotAttributesResponse)) {
            return false;
        }
        DescribeDbClusterSnapshotAttributesResponse other = (DescribeDbClusterSnapshotAttributesResponse) obj;
        return Objects.equals(dbClusterSnapshotAttributesResult(), other.dbClusterSnapshotAttributesResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbClusterSnapshotAttributesResponse")
                .add("DBClusterSnapshotAttributesResult", dbClusterSnapshotAttributesResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterSnapshotAttributesResult":
            return Optional.ofNullable(clazz.cast(dbClusterSnapshotAttributesResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterSnapshotAttributesResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterSnapshotAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDbClusterSnapshotAttributesResponse> {
        /**
         * Sets the value of the DBClusterSnapshotAttributesResult property for this object.
         *
         * @param dbClusterSnapshotAttributesResult
         *        The new value for the DBClusterSnapshotAttributesResult property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshotAttributesResult(DBClusterSnapshotAttributesResult dbClusterSnapshotAttributesResult);

        /**
         * Sets the value of the DBClusterSnapshotAttributesResult property for this object.
         *
         * This is a convenience that creates an instance of the {@link DBClusterSnapshotAttributesResult.Builder}
         * avoiding the need to create one manually via {@link DBClusterSnapshotAttributesResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBClusterSnapshotAttributesResult.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dbClusterSnapshotAttributesResult(DBClusterSnapshotAttributesResult)}.
         * 
         * @param dbClusterSnapshotAttributesResult
         *        a consumer that will call methods on {@link DBClusterSnapshotAttributesResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterSnapshotAttributesResult(DBClusterSnapshotAttributesResult)
         */
        default Builder dbClusterSnapshotAttributesResult(
                Consumer<DBClusterSnapshotAttributesResult.Builder> dbClusterSnapshotAttributesResult) {
            return dbClusterSnapshotAttributesResult(DBClusterSnapshotAttributesResult.builder()
                    .applyMutation(dbClusterSnapshotAttributesResult).build());
        }
    }

    static final class BuilderImpl extends DocDbResponse.BuilderImpl implements Builder {
        private DBClusterSnapshotAttributesResult dbClusterSnapshotAttributesResult;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterSnapshotAttributesResponse model) {
            super(model);
            dbClusterSnapshotAttributesResult(model.dbClusterSnapshotAttributesResult);
        }

        public final DBClusterSnapshotAttributesResult.Builder getDbClusterSnapshotAttributesResult() {
            return dbClusterSnapshotAttributesResult != null ? dbClusterSnapshotAttributesResult.toBuilder() : null;
        }

        public final void setDbClusterSnapshotAttributesResult(
                DBClusterSnapshotAttributesResult.BuilderImpl dbClusterSnapshotAttributesResult) {
            this.dbClusterSnapshotAttributesResult = dbClusterSnapshotAttributesResult != null ? dbClusterSnapshotAttributesResult
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder dbClusterSnapshotAttributesResult(DBClusterSnapshotAttributesResult dbClusterSnapshotAttributesResult) {
            this.dbClusterSnapshotAttributesResult = dbClusterSnapshotAttributesResult;
            return this;
        }

        @Override
        public DescribeDbClusterSnapshotAttributesResponse build() {
            return new DescribeDbClusterSnapshotAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
