/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SwitchoverGlobalClusterRequest extends DocDbRequest implements
        ToCopyableBuilder<SwitchoverGlobalClusterRequest.Builder, SwitchoverGlobalClusterRequest> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterIdentifier").getter(getter(SwitchoverGlobalClusterRequest::globalClusterIdentifier))
            .setter(setter(Builder::globalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build())
            .build();

    private static final SdkField<String> TARGET_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetDbClusterIdentifier").getter(getter(SwitchoverGlobalClusterRequest::targetDbClusterIdentifier))
            .setter(setter(Builder::targetDbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDbClusterIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_CLUSTER_IDENTIFIER_FIELD, TARGET_DB_CLUSTER_IDENTIFIER_FIELD));

    private final String globalClusterIdentifier;

    private final String targetDbClusterIdentifier;

    private SwitchoverGlobalClusterRequest(BuilderImpl builder) {
        super(builder);
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.targetDbClusterIdentifier = builder.targetDbClusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon DocumentDB global database cluster to switch over. The identifier is the unique key
     * assigned by the user when the cluster is created. In other words, it's the name of the global cluster. This
     * parameter isn’t case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing global cluster (Amazon DocumentDB global database).
     * </p>
     * </li>
     * <li>
     * <p>
     * Minimum length of 1. Maximum length of 255.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code>
     * </p>
     * 
     * @return The identifier of the Amazon DocumentDB global database cluster to switch over. The identifier is the
     *         unique key assigned by the user when the cluster is created. In other words, it's the name of the global
     *         cluster. This parameter isn’t case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing global cluster (Amazon DocumentDB global database).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Minimum length of 1. Maximum length of 255.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code>
     */
    public final String globalClusterIdentifier() {
        return globalClusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the secondary Amazon DocumentDB cluster to promote to the new primary for the global database
     * cluster. Use the Amazon Resource Name (ARN) for the identifier so that Amazon DocumentDB can locate the cluster
     * in its Amazon Web Services region.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing secondary cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * Minimum length of 1. Maximum length of 255.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code>
     * </p>
     * 
     * @return The identifier of the secondary Amazon DocumentDB cluster to promote to the new primary for the global
     *         database cluster. Use the Amazon Resource Name (ARN) for the identifier so that Amazon DocumentDB can
     *         locate the cluster in its Amazon Web Services region.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing secondary cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Minimum length of 1. Maximum length of 255.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code>
     */
    public final String targetDbClusterIdentifier() {
        return targetDbClusterIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetDbClusterIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SwitchoverGlobalClusterRequest)) {
            return false;
        }
        SwitchoverGlobalClusterRequest other = (SwitchoverGlobalClusterRequest) obj;
        return Objects.equals(globalClusterIdentifier(), other.globalClusterIdentifier())
                && Objects.equals(targetDbClusterIdentifier(), other.targetDbClusterIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SwitchoverGlobalClusterRequest").add("GlobalClusterIdentifier", globalClusterIdentifier())
                .add("TargetDbClusterIdentifier", targetDbClusterIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(globalClusterIdentifier()));
        case "TargetDbClusterIdentifier":
            return Optional.ofNullable(clazz.cast(targetDbClusterIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SwitchoverGlobalClusterRequest, T> g) {
        return obj -> g.apply((SwitchoverGlobalClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, SwitchoverGlobalClusterRequest> {
        /**
         * <p>
         * The identifier of the Amazon DocumentDB global database cluster to switch over. The identifier is the unique
         * key assigned by the user when the cluster is created. In other words, it's the name of the global cluster.
         * This parameter isn’t case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing global cluster (Amazon DocumentDB global database).
         * </p>
         * </li>
         * <li>
         * <p>
         * Minimum length of 1. Maximum length of 255.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code>
         * </p>
         * 
         * @param globalClusterIdentifier
         *        The identifier of the Amazon DocumentDB global database cluster to switch over. The identifier is the
         *        unique key assigned by the user when the cluster is created. In other words, it's the name of the
         *        global cluster. This parameter isn’t case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing global cluster (Amazon DocumentDB global database).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Minimum length of 1. Maximum length of 255.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterIdentifier(String globalClusterIdentifier);

        /**
         * <p>
         * The identifier of the secondary Amazon DocumentDB cluster to promote to the new primary for the global
         * database cluster. Use the Amazon Resource Name (ARN) for the identifier so that Amazon DocumentDB can locate
         * the cluster in its Amazon Web Services region.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing secondary cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * Minimum length of 1. Maximum length of 255.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code>
         * </p>
         * 
         * @param targetDbClusterIdentifier
         *        The identifier of the secondary Amazon DocumentDB cluster to promote to the new primary for the global
         *        database cluster. Use the Amazon Resource Name (ARN) for the identifier so that Amazon DocumentDB can
         *        locate the cluster in its Amazon Web Services region.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing secondary cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Minimum length of 1. Maximum length of 255.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDbClusterIdentifier(String targetDbClusterIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbRequest.BuilderImpl implements Builder {
        private String globalClusterIdentifier;

        private String targetDbClusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(SwitchoverGlobalClusterRequest model) {
            super(model);
            globalClusterIdentifier(model.globalClusterIdentifier);
            targetDbClusterIdentifier(model.targetDbClusterIdentifier);
        }

        public final String getGlobalClusterIdentifier() {
            return globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getTargetDbClusterIdentifier() {
            return targetDbClusterIdentifier;
        }

        public final void setTargetDbClusterIdentifier(String targetDbClusterIdentifier) {
            this.targetDbClusterIdentifier = targetDbClusterIdentifier;
        }

        @Override
        public final Builder targetDbClusterIdentifier(String targetDbClusterIdentifier) {
            this.targetDbClusterIdentifier = targetDbClusterIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SwitchoverGlobalClusterRequest build() {
            return new SwitchoverGlobalClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
