/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the details of the DB instance’s server certificate.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">Updating Your Amazon
 * DocumentDB TLS Certificates</a> and <a
 * href="https://docs.aws.amazon.com/documentdb/latest/developerguide/security.encryption.ssl.html"> Encrypting Data in
 * Transit</a> in the <i>Amazon DocumentDB Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CertificateDetails.Builder, CertificateDetails> {
    private static final SdkField<String> CA_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CAIdentifier").getter(getter(CertificateDetails::caIdentifier)).setter(setter(Builder::caIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CAIdentifier").build()).build();

    private static final SdkField<Instant> VALID_TILL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidTill").getter(getter(CertificateDetails::validTill)).setter(setter(Builder::validTill))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidTill").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CA_IDENTIFIER_FIELD,
            VALID_TILL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String caIdentifier;

    private final Instant validTill;

    private CertificateDetails(BuilderImpl builder) {
        this.caIdentifier = builder.caIdentifier;
        this.validTill = builder.validTill;
    }

    /**
     * <p>
     * The CA identifier of the CA certificate used for the DB instance's server certificate.
     * </p>
     * 
     * @return The CA identifier of the CA certificate used for the DB instance's server certificate.
     */
    public final String caIdentifier() {
        return caIdentifier;
    }

    /**
     * <p>
     * The expiration date of the DB instance’s server certificate.
     * </p>
     * 
     * @return The expiration date of the DB instance’s server certificate.
     */
    public final Instant validTill() {
        return validTill;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(validTill());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateDetails)) {
            return false;
        }
        CertificateDetails other = (CertificateDetails) obj;
        return Objects.equals(caIdentifier(), other.caIdentifier()) && Objects.equals(validTill(), other.validTill());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CertificateDetails").add("CAIdentifier", caIdentifier()).add("ValidTill", validTill()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CAIdentifier":
            return Optional.ofNullable(clazz.cast(caIdentifier()));
        case "ValidTill":
            return Optional.ofNullable(clazz.cast(validTill()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CAIdentifier", CA_IDENTIFIER_FIELD);
        map.put("ValidTill", VALID_TILL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CertificateDetails, T> g) {
        return obj -> g.apply((CertificateDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CertificateDetails> {
        /**
         * <p>
         * The CA identifier of the CA certificate used for the DB instance's server certificate.
         * </p>
         * 
         * @param caIdentifier
         *        The CA identifier of the CA certificate used for the DB instance's server certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caIdentifier(String caIdentifier);

        /**
         * <p>
         * The expiration date of the DB instance’s server certificate.
         * </p>
         * 
         * @param validTill
         *        The expiration date of the DB instance’s server certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validTill(Instant validTill);
    }

    static final class BuilderImpl implements Builder {
        private String caIdentifier;

        private Instant validTill;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateDetails model) {
            caIdentifier(model.caIdentifier);
            validTill(model.validTill);
        }

        public final String getCaIdentifier() {
            return caIdentifier;
        }

        public final void setCaIdentifier(String caIdentifier) {
            this.caIdentifier = caIdentifier;
        }

        @Override
        public final Builder caIdentifier(String caIdentifier) {
            this.caIdentifier = caIdentifier;
            return this;
        }

        public final Instant getValidTill() {
            return validTill;
        }

        public final void setValidTill(Instant validTill) {
            this.validTill = validTill;
        }

        @Override
        public final Builder validTill(Instant validTill) {
            this.validTill = validTill;
            return this;
        }

        @Override
        public CertificateDetails build() {
            return new CertificateDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
