/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of <a>DescribeDBClusterSnapshots</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbClusterSnapshotsResponse extends DocDbResponse implements
        ToCopyableBuilder<DescribeDbClusterSnapshotsResponse.Builder, DescribeDbClusterSnapshotsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbClusterSnapshotsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBClusterSnapshot>> DB_CLUSTER_SNAPSHOTS_FIELD = SdkField
            .<List<DBClusterSnapshot>> builder(MarshallingType.LIST)
            .memberName("DBClusterSnapshots")
            .getter(getter(DescribeDbClusterSnapshotsResponse::dbClusterSnapshots))
            .setter(setter(Builder::dbClusterSnapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterSnapshot")
                            .memberFieldInfo(
                                    SdkField.<DBClusterSnapshot> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterSnapshot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterSnapshot").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_CLUSTER_SNAPSHOTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<DBClusterSnapshot> dbClusterSnapshots;

    private DescribeDbClusterSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterSnapshots = builder.dbClusterSnapshots;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBClusterSnapshots property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDbClusterSnapshots() {
        return dbClusterSnapshots != null && !(dbClusterSnapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of cluster snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbClusterSnapshots} method.
     * </p>
     * 
     * @return Provides a list of cluster snapshots.
     */
    public final List<DBClusterSnapshot> dbClusterSnapshots() {
        return dbClusterSnapshots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbClusterSnapshots() ? dbClusterSnapshots() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterSnapshotsResponse)) {
            return false;
        }
        DescribeDbClusterSnapshotsResponse other = (DescribeDbClusterSnapshotsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasDbClusterSnapshots() == other.hasDbClusterSnapshots()
                && Objects.equals(dbClusterSnapshots(), other.dbClusterSnapshots());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbClusterSnapshotsResponse").add("Marker", marker())
                .add("DBClusterSnapshots", hasDbClusterSnapshots() ? dbClusterSnapshots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBClusterSnapshots":
            return Optional.ofNullable(clazz.cast(dbClusterSnapshots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("DBClusterSnapshots", DB_CLUSTER_SNAPSHOTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterSnapshotsResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbClusterSnapshotsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Provides a list of cluster snapshots.
         * </p>
         * 
         * @param dbClusterSnapshots
         *        Provides a list of cluster snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshots(Collection<DBClusterSnapshot> dbClusterSnapshots);

        /**
         * <p>
         * Provides a list of cluster snapshots.
         * </p>
         * 
         * @param dbClusterSnapshots
         *        Provides a list of cluster snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshots(DBClusterSnapshot... dbClusterSnapshots);

        /**
         * <p>
         * Provides a list of cluster snapshots.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.docdb.model.DBClusterSnapshot.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.docdb.model.DBClusterSnapshot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.docdb.model.DBClusterSnapshot.Builder#build()} is called immediately
         * and its result is passed to {@link #dbClusterSnapshots(List<DBClusterSnapshot>)}.
         * 
         * @param dbClusterSnapshots
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.docdb.model.DBClusterSnapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterSnapshots(java.util.Collection<DBClusterSnapshot>)
         */
        Builder dbClusterSnapshots(Consumer<DBClusterSnapshot.Builder>... dbClusterSnapshots);
    }

    static final class BuilderImpl extends DocDbResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBClusterSnapshot> dbClusterSnapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterSnapshotsResponse model) {
            super(model);
            marker(model.marker);
            dbClusterSnapshots(model.dbClusterSnapshots);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBClusterSnapshot.Builder> getDbClusterSnapshots() {
            List<DBClusterSnapshot.Builder> result = DBClusterSnapshotListCopier.copyToBuilder(this.dbClusterSnapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterSnapshots(Collection<DBClusterSnapshot.BuilderImpl> dbClusterSnapshots) {
            this.dbClusterSnapshots = DBClusterSnapshotListCopier.copyFromBuilder(dbClusterSnapshots);
        }

        @Override
        public final Builder dbClusterSnapshots(Collection<DBClusterSnapshot> dbClusterSnapshots) {
            this.dbClusterSnapshots = DBClusterSnapshotListCopier.copy(dbClusterSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshots(DBClusterSnapshot... dbClusterSnapshots) {
            dbClusterSnapshots(Arrays.asList(dbClusterSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshots(Consumer<DBClusterSnapshot.Builder>... dbClusterSnapshots) {
            dbClusterSnapshots(Stream.of(dbClusterSnapshots).map(c -> DBClusterSnapshot.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbClusterSnapshotsResponse build() {
            return new DescribeDbClusterSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
